<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>ID</th>
                <th>Loại phương tiện</th>
                <th>Trạng thái</th>
                <th>Chi nhánh</th>
                <?php if(!onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id'])): ?>
                    <th>Người tạo</th>
                <?php endif; ?>
                <th>Địa chỉ</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $status = ['secondary', 'warning', 'warning', 'success', 'info', 'primary', 'danger'];
            ?>
            <?php $__currentLoopData = $orders_pickup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order_pickup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $hidden_text = checkShowInfoPickup($is_shipper, $order_pickup['order_pickup_status']);
                ?>
                <tr class="odd">
                    <td>
                        <?php if(!$hidden_text || true): ?>
                            <button id="btn_pickup_<?php echo e($key); ?>" onclick="showPickupDetail('<?php echo e($key); ?>')"
                                class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                                data-bs-toggle="collapse" data-bs-target="#pickup_<?php echo e($key); ?>"
                                aria-expanded="false">
                                <span class="icon">
                                    <i class="fa fa-plus"></i>
                                </span>
                            </button>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($order_pickup['order_pickup_code']); ?></td>
                    <td class="align-items-center">
                        <span class="d-block text-high-em">
                            <?php echo e($order_pickup['order_pickup_type_name']); ?>

                        </span>
                    </td>
                    <td>
                        <span class="badge badge-soft-<?php echo e($status[$order_pickup['order_pickup_status']]); ?> my-1">
                            <?php echo e($order_pickup['order_pickup_status_name']); ?>

                        </span>
                    </td>
                    <td><?php echo e($order_pickup['branch']['branch_name']); ?></td>
                    <?php if(!onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id'])): ?>
                        <td><?php echo e($order_pickup['user']['user_contact_name']); ?></td>
                    <?php endif; ?>
                    <td><?php echo e($order_pickup['order_pickup_address']); ?></td>
                </tr>
                <?php if(!$hidden_text || true): ?>
                    <tr class="child collapse" id="pickup_<?php echo e($key); ?>">
                        <td class="child" colspan="6">
                            <ul class="dtr-details">
                                <li>
                                    <span class="dtr-title"><strong>AWB:</strong></span>
                                    <span class="dtr-data"><?php echo e($order_pickup['order_pickup_awb']); ?></span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Phone:</strong></span>
                                    <span class="dtr-data"><?php echo e($order_pickup['order_pickup_phone']); ?></span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Date/Time:</strong></span>
                                    <span
                                        class="dtr-data"><?php echo e(formatFullDate($order_pickup['order_pickup_date_time'])); ?></span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Gross Weight:</strong></span>
                                    <span class="dtr-data"><?php echo e($order_pickup['order_pickup_gross_weight']); ?></span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Note:</strong></span>
                                    <span class="dtr-data"><?php echo e($order_pickup['order_pickup_note']); ?></span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Method:</strong></span>
                                    <span class="dtr-data">
                                        <?php if($order_pickup['order_pickup_status'] !== ORDER_PICKUP_STATUS_WAITING): ?>
                                            <font color="green">
                                                <i class="fas fa-shipping-fast"></i>
                                                <?php echo e(formatFullDate($order_pickup['order_pickup_date_time_method'])); ?>

                                            </font>
                                            <a href="<?php echo e(route('pickup.inpickup.show', ['order_pickup_code' => $order_pickup['order_pickup_code']])); ?>"
                                                target="_blank">
                                                <i class="fas fa-file-excel"></i>
                                            </a>
                                        <?php endif; ?>
                                    </span>
                                </li>

                                <?php if(isset($order_pickup['sale'])): ?>
                                    <li>
                                        <span class="dtr-title"><strong>Nhân viên sale phụ trách: </strong></span>
                                        <span class="dtr-data"><?php echo e($order_pickup['sale']['user_contact_name']); ?>

                                            (<?php echo e($order_pickup['sale']['user_code']); ?>)</span>
                                    </li>
                                <?php endif; ?>
                                <?php if(isset($order_pickup['fwd'])): ?>
                                    <li>
                                        <span class="dtr-title"><strong>Công ty: </strong></span>
                                        <span class="dtr-data"><?php echo e($order_pickup['fwd']['user_company_name']); ?>

                                            (<?php echo e($order_pickup['fwd']['user_code']); ?>)</span>
                                    </li>
                                <?php endif; ?>
                                <?php if(isset($order_pickup['shipper'])): ?>
                                    <li>
                                        <span class="dtr-title"><strong>Shipper: </strong></span>
                                        <span class="dtr-data"><?php echo e($order_pickup['shipper']['user_contact_name']); ?>

                                            (<?php echo e($order_pickup['shipper']['user_code']); ?>)</span>
                                    </li>
                                <?php endif; ?>
                                <?php if($is_edit || !$is_shipper): ?>
                                    <li class="mt-3">
                                        <button id="btn_edit_order_pickup_<?php echo e($order_pickup['order_pickup_id']); ?>"
                                            class="btn btn-sm btn-warning"
                                            onclick="onEditOrderPickup(<?php echo e($order_pickup['order_pickup_id']); ?>)">
                                            <i class="fa fa-pen"></i>
                                        </button>
                                        <?php if(
                                            (!isset($order_pickup['shipper_location_id']) &&
                                                $order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_WAITING &&
                                                $is_ops_leader) || onCheckAdminAccount()): ?>
                                            <button id="btn_edit_order_pickup_<?php echo e($order_pickup['order_pickup_id']); ?>"
                                                class="btn btn-sm btn-info ms-2"
                                                onclick="showModallAddShipper(<?php echo e($order_pickup['order_pickup_id']); ?>)">
                                                <i class="fas fa-shipping-fast"></i>
                                            </button>
                                        <?php endif; ?>
                                        <?php if(isset($order_pickup['shipper_location_id']) &&
                                                $order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_PENDING_CONFIRM &&
                                                onCheckPositionAccounts([SETTING_OPS_LEADER_ACCOUNT, SETTING_ADMIN_ACCOUNT], auth()->user()['position_id'])): ?>
                                            <button id="btn_delete_shipper_<?php echo e($order_pickup['order_pickup_id']); ?>"
                                                class="btn btn-sm btn-danger ms-2"
                                                onclick="onDeleteShipper(<?php echo e($order_pickup['order_pickup_id']); ?>)">
                                                <i class="fas fa-shipping-fast"></i>
                                            </button>
                                        <?php endif; ?>
                                        <?php if(
                                            !isset($order_pickup['shipper_location_id']) &&
                                                isGetAllData() &&
                                                $order_pickup['order_pickup_status'] != ORDER_PICKUP_STATUS_CANCEL): ?>
                                            <button id="btn_delete_order_pickup_<?php echo e($order_pickup['order_pickup_id']); ?>"
                                                class="btn btn-sm btn-danger ms-2"
                                                onclick="onCancelPickup(<?php echo e($order_pickup['order_pickup_id']); ?>)">
                                                <i class="fas fa-calendar-times"></i>
                                            </button>
                                        <?php endif; ?>
                                    </li>
                                <?php endif; ?>
                                <?php if($is_shipper): ?>
                                    <li class="mt-3">
                                        <?php if($order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_PENDING_CONFIRM): ?>
                                            <button class="btn btn-sm btn-warning btn-update-status"
                                                data-order_pickup_id="<?php echo e($order_pickup['order_pickup_id']); ?>"
                                                data-order_pickup_status="<?php echo e(ORDER_PICKUP_STATUS_CONFIRMED); ?>">
                                                <i class="fas fa-user-check"></i>
                                            </button>
                                        <?php endif; ?>
                                        <?php if($order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_CONFIRMED): ?>
                                            <button class="btn btn-sm btn-info btn-update-status"
                                                data-order_pickup_id="<?php echo e($order_pickup['order_pickup_id']); ?>"
                                                data-order_pickup_status="<?php echo e(ORDER_PICKUP_STATUS_GOING); ?>">
                                                <i class="fas fa-running"></i>
                                            </button>
                                        <?php endif; ?>
                                        <?php if($order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_GOING): ?>
                                            <button class="btn btn-sm btn-info btn-update-status"
                                                data-order_pickup_id="<?php echo e($order_pickup['order_pickup_id']); ?>"
                                                data-order_pickup_status="<?php echo e(ORDER_PICKUP_STATUS_GONE); ?>">
                                                <i class="fa fa-chalkboard-teacher"></i>
                                            </button>
                                        <?php endif; ?>
                                        <?php if($order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_GONE): ?>
                                            <button class="btn btn-sm btn-success btn-update-status-picked"
                                                data-order_pickup_id="<?php echo e($order_pickup['order_pickup_id']); ?>"
                                                data-order_pickup_status="<?php echo e(ORDER_PICKUP_STATUS_PICKED); ?>"
                                                data-bs-toggle="modal"
                                                data-bs-target="#modalUploadOrderPickupImageBackdrop">
                                                <i class="fa fa-check-circle"></i>
                                            </button>
                                        <?php endif; ?>
                                        <?php if(in_array($order_pickup['order_pickup_status'], [ORDER_PICKUP_STATUS_GOING, ORDER_PICKUP_STATUS_GONE])): ?>
                                            <button id="btn_delete_order_pickup_<?php echo e($order_pickup['order_pickup_id']); ?>"
                                                class="btn btn-sm btn-danger ms-2"
                                                onclick="onCancelPickup(<?php echo e($order_pickup['order_pickup_id']); ?>)">
                                                <i class="fas fa-calendar-times"></i>
                                            </button>
                                        <?php endif; ?>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </td>
                    </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div class="d-flex justify-content-center mt-5">
        <?php echo e($orders_pickup->links('components.pagination')); ?>

    </div>
</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/order-pickup/order-pickup-pagination.blade.php ENDPATH**/ ?>