<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>ID Bill </th>
                <th>Ngày</th>
                <th>Chi nhánh</th>
                <th>Dịch vụ</th>
                <th>Người nhận</th>
                <th>Trạng thái</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $colors = ['secondary', 'info', 'success', 'danger', 'danger'];
            ?>
            <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $checked = onCheckAcctionShipment($shipment, auth()->user());
                ?>
                <tr class="odd">
                    <td>
                        <button id="btn_shipment_<?php echo e($key); ?>" onclick="showShipmentDetail('<?php echo e($key); ?>')"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#shipment_<?php echo e($key); ?>"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="<?php echo e(route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']])); ?>">
                            <?php echo e($shipment['shipment_code']); ?>

                        </a>
                        <?php if(isGetAllData() && isset($shipment['created_lable_at'])): ?>
                            <button class="btn btn-icon btn-soft-info btn-animated btn-sm ms-3"><span class="icon">
                                    <i class="fas fa-exclamation"></i></span></button>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e(formatFullDate($shipment['created_at'])); ?></td>
                    <td class="align-items-center">
                        <?php echo e($shipment['branch']['branch_name']); ?>

                    </td>
                    <td>
                        <?php echo e($shipment['service']['service_name']); ?>

                    </td>
                    <td><?php echo e($shipment['receiver_contact_name']); ?></td>
                    <td>
                        <small class="badge badge-<?php echo e($colors[$shipment['shipment_status']]); ?>">
                            <?php echo e($shipment['shipment_status_name']); ?>

                        </small>
                    </td>
                </tr>
                <tr class="child collapse" id="shipment_<?php echo e($key); ?>">
                    <td class="child" colspan="7">
                        <ul>
                            <li class="mb-3">
                                <span class="dtr-title">Addresss: </span>
                                <span class="dtr-data">
                                    [ <a href="<?php echo e(getUrlTracking($shipment['shipment_code'])); ?>" target="_blank">
                                        <i class="fas fa-map-marker-alt"></i></a>
                                    <b> <?php echo e($shipment['country']['country_name']); ?></b>]
                                    - <?php echo e($shipment['receiver_address_1']); ?>

                                </span>
                            </li>
                            <?php if(!onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id'])): ?>
                                <li class="mb-3">
                                    <span class="dtr-title">TK tạo: </span>
                                    <span class="dtr-data">
                                        <?php echo $__env->make('components.badges-position-name', [
                                            'position_id' => $shipment['user']['position_id'],
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php echo e($shipment['user']['user_contact_name']); ?>

                                    </span>
                                </li>
                            <?php endif; ?>
                            <li class="mb-3">
                                <span class="dtr-title">Ref Code: </span>
                                <span class="dtr-data"><?php echo e($shipment['shipment_reference_code']); ?></span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Status: </span>
                                <span class="dtr-data">
                                    <small class="badge badge-<?php echo e($colors[$shipment['shipment_status']]); ?>">
                                        <?php echo e($shipment['shipment_status_name']); ?>

                                    </small>
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Thanh toán: </span>
                                <span
                                    class="dtr-data fw-bold text-<?php echo e($shipment['shipment_payment_status'] == 0 ? 'danger' : 'success'); ?>">
                                    <?php echo e($shipment['shipment_payment_status'] == 0 ? 'Chưa thanh toán' : 'Đã thanh toán'); ?>

                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Duyệt xuất: </span>
                                <?php if($shipment['accountant_status'] == 0): ?>
                                    <span class="dtr-data fw-bold text-secondary">
                                        Đang chờ xác nhận
                                    </span>
                                <?php elseif($shipment['accountant_status'] == 1): ?>
                                    <span class="dtr-data fw-bold text-success">
                                        Đã xác nhận
                                    </span>
                                <?php else: ?>
                                    <span class="dtr-data fw-bold text-danger">
                                        Đã hủy đơn
                                    </span>
                                    <p><strong>Nguyên nhân hủy: </strong><?php echo e($shipment['accountant_cancel_note']); ?></p>
                                <?php endif; ?>
                            </li>
                            <?php if(!onCheckIsEpacket($shipment['shipment_service_id']) && isGetAllData()): ?>
                                <li class="mb-3">
                                    <span class="dtr-title">Admin duyệt: </span>
                                    <span
                                        class="dtr-data fw-bold text-<?php echo e($shipment['checked_payment_status'] == 0 ? 'warning' : 'success'); ?>">
                                        <?php echo e($shipment['checked_payment_status'] == 0 ? 'Chưa duyệt' : 'Đã duyệt'); ?>

                                    </span>
                                    <?php if(!isset($shipment['checked_payment']['checked']) && $shipment['checked_payment_status'] == 1): ?>
                                        <span>
                                            <i title="Đơn duyệt thông qua Debit/Statement"
                                                class="fas fa-exclamation-circle text-warning"></i>
                                        </span>
                                    <?php endif; ?>
                                </li>
                            <?php endif; ?>
                            <li>
                                <span class="dtr-title"></span>
                                <span class="dtr-data">
                                    <form action="" method="POST">
                                        <a href="<?php echo e(route('shipments.print.bill.show', ['shipment_code' => $shipment['shipment_code']])); ?>"
                                            class="btn btn-primary  btn-sm" target="_blank"><i class="fa fa-print"></i>
                                            B
                                        </a>
                                        <a href="<?php echo e(route('shipments.print.label.show', ['shipment_code' => $shipment['shipment_code']])); ?>"
                                            class="btn btn-primary btn-sm" target="_blank"><i class="fa fa-print"></i>
                                            L
                                        </a>
                                        <?php if(isGetAllData() || onCheckDocumentAccount(SETTING_OPS_LEADER_ACCOUNT)): ?>
                                            <a href="<?php echo e(route('shipments.print.label-v2.show', ['shipment_code' => $shipment['shipment_code']])); ?>"
                                                class="btn btn-primary btn-sm" target="_blank"><i
                                                    class="fa fa-print"></i>
                                                L2
                                            </a>
                                        <?php endif; ?>
                                        <?php if(isGetAllData() ||
                                                isUserIdsShipment() ||
                                                onCheckDocumentAccount(SETTING_OPS_LEADER_ACCOUNT) ||
                                                onCheckDocumentAccount() ||
                                                $have_show_label_LF2): ?>
                                            <a href="<?php echo e(route('shipments.print.label-v2-f.show', ['shipment_code' => $shipment['shipment_code']])); ?>"
                                                class="btn btn-primary btn-sm" target="_blank"><i
                                                    class="fa fa-print"></i>
                                                L2F
                                            </a>
                                        <?php endif; ?>
                                        <?php if(isset($shipment['label']) && !onCheckPositionAccount(SETTING_ALL_ACCOUNT, auth()->user()['position_id'])): ?>
                                            <?php
                                                $label = $shipment['label'];
                                                $check_file = checkFileInfo($label['link']);
                                            ?>
                                            <?php if(isset($check_file) && $check_file['extension'] == 'txt'): ?>
                                                <a href="javascript:void(0)" class="btn btn-primary btn-sm"
                                                    onclick="onPrintFile('<?php echo e($label['link']); ?>')">
                                                    <i class="fas fa-file-pdf"></i> label
                                                </a>
                                            <?php else: ?>
                                                <a href="<?php echo e($label['in_directory'] == IN_DIRECTORY ? asset($label['link']) : $label['link']); ?>"
                                                    target="_blank" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-download"></i> label
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <a href="<?php echo e(route('shipments.print.invoice.show', ['shipment_code' => $shipment['shipment_code']])); ?>"
                                            class="btn btn-primary btn-sm" target="_blank"><i class="fa fa-print"></i>
                                            INV
                                        </a>
                                        <?php if($checked['is_edit']): ?>
                                            <a href="<?php echo e(route('shipments.edit.show', ['shipment_code' => $shipment['shipment_code']])); ?>"
                                                type="button" class="btn btn-warning btn-sm"><i
                                                    class="far fa-edit"></i></a>
                                        <?php endif; ?>
                                        <?php if(isGetAllData()): ?>
                                            <button type="button"
                                                onclick="onDeleteShipment('<?php echo e($shipment['shipment_code']); ?>')"
                                                class="btn btn-sm btn-danger"><i class="fas fa-trash-alt"></i></button>
                                        <?php endif; ?>
                                    </form>
                                </span>
                            </li>
                        </ul>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    <?php echo e($shipments->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/shipment/shipment-pagination.blade.php ENDPATH**/ ?>