<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>Payment date</th>
                <th>ID Bill</th>
                <th>Sale name</th>
                <th>Thu</th>
                <th>Cước gốc</th>
                <th>Method</th>
                <th>Phương thức</th>
                <th>image</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php
                $colors = ['secondary', 'info', 'success', 'danger', 'danger', ''];
            ?>
            <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="odd">
                    <td>
                        <button onclick="onActionBtnShowClick(this)"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#shipment_<?php echo e($shipment['shipment_id']); ?>"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>
                        <?php if(isset($shipment['shipment_payment_date']) && $shipment['shipment_payment_step'] >= 3): ?>
                            <?php echo e(formatFullDate($shipment['shipment_payment_date'])); ?>

                        <?php elseif($shipment['shipment_payment_status'] == 1 && empty($shipment['shipment_payment_date'])): ?>
                            Thanh toán trước 6/11
                        <?php else: ?>
                            Chờ thanh toán
                        <?php endif; ?>
                    </td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="<?php echo e(route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']])); ?>">
                            <?php echo e($shipment['shipment_code']); ?>

                        </a>
                    </td>
                    <td>
                        <?php if($shipment['user']): ?>
                            <?php echo e($shipment['user']['user_contact_name']); ?> [<?php echo e($shipment['user']['user_code']); ?>]
                        <?php else: ?>
                            <span class="text-danger">*Tài khoản này không còn tồn tại</span>
                        <?php endif; ?>
                    </td>
                    <td class="align-items-center">
                        <?php echo e(number_format($shipment['shipment_amount_total_customer'])); ?>

                    </td>
                    <td>
                        <?php echo e(number_format($shipment['shipment_final_amount'])); ?>

                    </td>
                    <td>
                        Thanh toán <?php echo e($shipment['shipment_paid_by'] == SHIPMENT_PAID_BY_REMAINING ? 'nợ' : 'sau'); ?>

                    </td>
                    <td><?php echo e($shipment['shipment_payment_method_name']); ?></td>
                    <td>
                        <?php if(isset($shipment['shipment_file_proof_of_payment'])): ?>
                            <?php $__currentLoopData = onConvertStrArrImage($shipment['shipment_file_proof_of_payment']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="p-2" href="<?php echo e(asset($item)); ?>" target="_blank"><i
                                        class="fas fa-image"></i></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </td>
                    <td>
                        
                        <?php if($shipment['shipment_payment_status'] == 0 && in_array($shipment['shipment_payment_step'], [1, 3])): ?>
                            <?php if($shipment['shipment_payment_step'] == 3 && $shipment['shipment_payment_method'] == CASH_AND_BANK ): ?>
                                <button
                                    onclick="onConfirmShipment2('<?php echo e($shipment['shipment_code']); ?>', <?php echo e($shipment['shipment_amount_total_customer']); ?>)"
                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Duyệt đơn"
                                    class="btn btn-icon btn-primary btn-animated btn-lg"><span class="icon"><i
                                            class="fas fa-file-invoice-dollar"></i></span></button>
                            <?php else: ?>
                                <button onclick="onConfirmShipment('<?php echo e($shipment['shipment_code']); ?>')"
                                    data-bs-toggle="tooltip" data-bs-placement="top" title="Duyệt đơn"
                                    class="btn btn-icon btn-primary btn-animated btn-lg"><span class="icon"><i
                                            class="fas fa-file-invoice-dollar"></i></span></button>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if($shipment['accountant_status'] == 0): ?>
                            <button onclick="onAccountantConfirm('<?php echo e($shipment['shipment_code']); ?>')"
                                data-bs-toggle="tooltip" data-bs-placement="top" title="Cho phép xuất hàng"
                                class="btn btn-icon btn-success btn-animated btn-lg"><span class="icon"><i
                                        class="far fa-check-circle"></i></span></button>
                        <?php endif; ?>
                        <?php if(in_array($shipment['shipment_payment_step'], [1, 3])): ?>
                            <button onclick="onCancelShipment('<?php echo e($shipment['shipment_code']); ?>')"
                                data-bs-toggle="tooltip" data-bs-placement="top" title="Hủy yêu cầu"
                                class="btn btn-icon btn-danger btn-animated btn-lg"><span class="icon"><i
                                        class="far fa-times-circle"></i></span></button>
                        <?php endif; ?>


                    </td>
                </tr>
                <tr class="child collapse" id="shipment_<?php echo e($shipment['shipment_id']); ?>">
                    <td class="child" colspan="7">
                        <ul>
                            <li class="mb-3">
                                <span class="dtr-title">Brand: </span>
                                <span class="dtr-data"><?php echo e($shipment['branch']['branch_name']); ?></span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Status: </span>
                                <span class="dtr-data">
                                    <small class="badge badge-<?php echo e($colors[$shipment['shipment_status']] ?? ''); ?>">
                                        <?php echo e($shipment['shipment_status_name'] ?? ''); ?>

                                    </small>
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Thanh toán: </span>
                                <span
                                    class="dtr-data fw-bold text-<?php echo e($shipment['shipment_payment_status'] == 0 ? 'danger' : 'success'); ?>">
                                    <?php echo e($shipment['shipment_payment_status'] == 0 ? 'Chưa thanh toán' : 'Đã thanh toán'); ?>

                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Ngày tạo đợn: </span>
                                <span class="dtr-data">
                                    <?php echo e(formatFullDate($shipment['created_at'])); ?>

                                </span>
                            </li>
                        </ul>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    <?php echo e($shipments->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/accounting-management/shipment/ajax/table-shipment.blade.php ENDPATH**/ ?>