<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th>ID Bill</th>
                <th>Địa chỉ</th>
                <th>Ngày</th>
                <th>Dịch vụ</th>
                <th>Người nhận</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="odd">
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="<?php echo e(route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']])); ?>">
                            <?php echo e($shipment['shipment_code']); ?>

                        </a>
                    </td>
                    <td>
                        [<b><?php echo e($shipment['country']['country_name']); ?></b>]
                        - <?php echo e($shipment['receiver_address_1']); ?>

                    </td>
                    <td><?php echo e(formatFullDate($shipment['created_at'])); ?></td>
                    <td>
                        <?php echo e($shipment['service']['service_name']); ?>

                    </td>
                    <td><?php echo e($shipment['receiver_contact_name']); ?></td>
                    <td>
                        <button type="button" class="btn btn-success button-approve-shipment"
                            data-shipment_code="<?php echo e($shipment['shipment_code']); ?>">
                            <i class="fa fa-check"></i>
                        </button>
                        <button type="button" class="btn btn-danger button-delete-shipment"
                            data-shipment_code="<?php echo e($shipment['shipment_code']); ?>">
                            <i class="fa fa-trash"></i>
                        </button>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    <?php echo e($shipments->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/shipment-approve/pagination.blade.php ENDPATH**/ ?>