<header class="chat-header">
    <a id="back_user_list" class="btn btn-sm btn-icon btn-flush-dark btn-rounded flush-soft-hover back-user-list"
        href="#">
        <span class="icon"><span class="feather-icon">
                <svg viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"
                    id="Chevron-Left--Streamline-Radix" height="16" width="16">
                    <desc>Chevron Left Streamline Icon: https://streamlinehq.com</desc>
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M11.862506666666667 0.3956266666666667C12.21344 0.7246933333333333 12.231253333333333 1.2759466666666666 11.902186666666667 1.6268799999999999L5.927359999999999 8L11.902186666666667 14.373013333333333C12.231253333333333 14.72416 12.21344 15.275413333333333 11.862506666666667 15.60448C11.511466666666667 15.93344 10.960213333333334 15.915626666666666 10.631146666666666 15.564693333333334L4.097813333333333 8.59584C3.78368 8.260693333333332 3.78368 7.739306666666667 4.097813333333333 7.404266666666666L10.631146666666666 0.4353066666666667C10.960213333333334 0.08437333333333334 11.511466666666667 0.06656 11.862506666666667 0.3956266666666667Z"
                        fill="currentColor" stroke-width="1"></path>
                </svg>
            </span></span>
    </a>
    <div class="media">
        <div class="media-head">
            <div class="avatar avatar-sm avatar-primary position-relative avatar-rounded">
                <span class="initial-wrap"><?php echo e(customTextAvatar($ticket['user']['user_contact_name'])); ?></span>
            </div>
        </div>
        <div class="media-body">
            <div class="user-name"><?php echo e($ticket['ticket_title']); ?></div>
            <div class="user-status"><?php echo e($ticket['user']['user_contact_name']); ?></div>
        </div>
    </div>
    <div class="chat-options-wrap">
        <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover chatapp-info-toggle active" href="#">
            <span class="icon" data-bs-toggle="tooltip" data-bs-placement="top" title=""
                data-bs-original-title="Info">
                <span class="feather-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="-0.5 -0.5 16 16"
                        stroke-linecap="round" stroke-linejoin="round" stroke="#000000"
                        id="Info-Circle--Streamline-Mynaui" height="16" width="16">
                        <desc>Info Circle Streamline Icon: https://streamlinehq.com</desc>
                        <path
                            d="M7.5 10.515375V6.746124999999999H7.1230625000000005M7.1230625000000005 10.515375H7.8769374999999995M7.5 4.8615625V4.484624999999999"
                            stroke-width="1"></path>
                        <path
                            d="M0.7153750000000001 7.5C0.7153750000000001 12.7228125 6.369249999999999 15.9870625 10.892312500000001 13.375625C12.9915 12.1636875 14.284625 9.9239375 14.284625 7.5C14.284625 2.2771875 8.63075 -0.9870625 4.1076875 1.6243750000000001C2.0085 2.8363125 0.7153750000000001 5.076062500000001 0.7153750000000001 7.5"
                            stroke-width="1"></path>
                    </svg>
                </span>
            </span>
        </a>
        <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover hk-navbar-togglable d-none d-xl-block"
            href="#" data-bs-toggle="tooltip" data-bs-placement="top" title=""
            data-bs-original-title="Collapse">
            <span class="icon">
                <span class="feather-icon">
                    <svg viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"
                        id="Chevron-Up--Streamline-Radix" height="10" width="10">
                        <desc>Chevron Up Streamline Icon: https://streamlinehq.com</desc>
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M0.3956266666666667 11.862506666666667C0.7246933333333333 12.21344 1.2759466666666666 12.231253333333333 1.6268799999999999 11.902186666666667L8 5.927359999999999L14.37312 11.902186666666667C14.72416 12.231253333333333 15.275413333333333 12.21344 15.60448 11.862506666666667C15.93344 11.511466666666667 15.915626666666666 10.960213333333334 15.5648 10.631146666666666L8.59584 4.097813333333333C8.260693333333332 3.78368 7.739306666666667 3.78368 7.404266666666666 4.097813333333333L0.4353066666666667 10.631146666666666C0.08437333333333334 10.960213333333334 0.06656 11.511466666666667 0.3956266666666667 11.862506666666667Z"
                            fill="currentColor" stroke-width="1"></path>
                    </svg>
                </span>
                <span class="feather-icon d-none">
                    <svg viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"
                        id="Chevron-Down--Streamline-Radix" height="10" width="10">
                        <desc>Chevron Down Streamline Icon: https://streamlinehq.com</desc>
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M0.3956266666666667 4.1374933333333335C0.7246933333333333 3.78656 1.2759466666666666 3.7687466666666665 1.6268799999999999 4.097813333333333L8 10.07264L14.37312 4.097813333333333C14.72416 3.7687466666666665 15.275413333333333 3.78656 15.60448 4.1374933333333335C15.93344 4.488533333333334 15.915626666666666 5.039786666666667 15.5648 5.368853333333333L8.59584 11.902186666666667C8.260693333333332 12.21632 7.739306666666667 12.21632 7.404266666666666 11.902186666666667L0.4353066666666667 5.368853333333333C0.08437333333333334 5.039786666666667 0.06656 4.488533333333334 0.3956266666666667 4.1374933333333335Z"
                            fill="currentColor" stroke-width="1"></path>
                    </svg>
                </span>
            </span>
        </a>
    </div>
</header>
<div data-simplebar id="chat_body" class="chat-body">
    <ul class="list-unstyled chat-single-list" id="single_chat_list">
        <?php $__currentLoopData = $ticket['ticketMessages']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(isset($message['sender_id']) && $message['ticket_type'] == TICKET_TYPE_TEXT): ?>
                <li class="media received">
                    <div class="media-body">
                        <div class="msg-box">
                            <div>
                                <p><?php echo $message['ticket_message_content']; ?></p>
                                <span class="chat-time"><?php echo e(formatFullDate($message['created_at'])); ?></span>
                            </div>
                        </div>
                    </div>
                </li>
            <?php elseif(isset($message['sender_id']) && $message['ticket_type'] == TICKET_TYPE_FILE): ?>
                <?php
                    $file = checkFileInfo($message['ticket_message_content']);
                ?>
                <?php if(isset($file)): ?>    
                    <li class="media media-attachment received">
                        <div class="media-body <?php echo e($file['is_image'] ? 'msg-imgs' : 'msg-docs'); ?>">
                            <div class="msg-box">
                                <div>
                                    <?php if($file['is_image']): ?>
                                        <img class="d-block img-fluid" src="<?php echo e(asset($message['ticket_message_content'])); ?>"
                                            alt="<?php echo e($file['extension']); ?>">
                                    <?php else: ?>
                                        <div class="media">
                                            <div class="avatar avatar-icon avatar-sm avatar-blue">
                                                <span class="initial-wrap fs-3">
                                                    <i class="<?php echo e($file['icon']); ?>"></i>
                                                </span>
                                            </div>
                                            <div class="media-body">
                                                <p class="file-name"><?php echo e($file['name']); ?></p>
                                                <p class="file-size"><?php echo e(formatNumber($file['size'])); ?> KB</p>
                                            </div>
                                        </div>
                                        <div class="file-overlay">
                                            <a href="<?php echo e(asset($message['ticket_message_content'])); ?>" download
                                                class="btn btn-sm btn-icon btn-rounded btn-secondary">
                                                <span class="icon">
                                                    <span class="feather-icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                            height="24" viewBox="0 0 24 24" fill="none"
                                                            stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                            stroke-linejoin="round" class="feather feather-arrow-down">
                                                            <line x1="12" y1="5" x2="12"
                                                                y2="19"></line>
                                                            <polyline points="19 12 12 19 5 12"></polyline>
                                                        </svg>
                                                    </span>
                                                </span>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php if($file['is_image']): ?>
                                    <div class="msg-action">
                                        <a href="<?php echo e(asset($message['ticket_message_content'])); ?>" download
                                            class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover no-caret">
                                            <span class="icon">
                                                <span class="feather-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                        viewBox="0 0 24 24" id="Download-Bottom--Streamline-Ultimate"
                                                        height="24" width="24">
                                                        <desc>Download Bottom Streamline Icon: https://streamlinehq.com
                                                        </desc>
                                                        <path stroke="#000000" stroke-linecap="round"
                                                            stroke-linejoin="round" d="M12.001 3.75v12"
                                                            stroke-width="1.5">
                                                        </path>
                                                        <path stroke="#000000" stroke-linecap="round"
                                                            stroke-linejoin="round" d="m7.501 11.25 4.5 4.5 4.5 -4.5"
                                                            stroke-width="1.5"></path>
                                                        <path stroke="#000000" stroke-linecap="round"
                                                            stroke-linejoin="round"
                                                            d="M23.251 15.75v1.5c0 0.7956 -0.3161 1.5587 -0.8787 2.1213 -0.5626 0.5626 -1.3257 0.8787 -2.1213 0.8787h-16.5c-0.79565 0 -1.55871 -0.3161 -2.12132 -0.8787 -0.56261 -0.5626 -0.878681 -1.3257 -0.878681 -2.1213v-1.5"
                                                            stroke-width="1.5"></path>
                                                    </svg>
                                                </span>
                                            </span>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </li>
                <?php else: ?>
                    <li class="media media-attachment received">
                        <div class="media-body msg-imgs">
                            <div class="msg-box">
                                <div>
                                    <img class="d-block img-fluid" src=""
                                        alt="">
                                </div>
                            </div>
                        </div>
                    </li>
                <?php endif; ?>
            <?php elseif(isset($message['answer_id']) && $message['ticket_type'] == TICKET_TYPE_TEXT): ?>
                <li class="media sent">
                    <div class="media-body">
                        <div class="msg-box">
                            <div>
                                <p><?php echo $message['ticket_message_content']; ?></p>
                                <span class="chat-time"><?php echo e(formatFullDate($message['created_at'])); ?></span>
                            </div>
                        </div>
                    </div>
                </li>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<footer class="chat-footer">
    <span class="btn-icon btn-rounded flex-shrink-0"></span>
    <div class="input-group">
        <span class="input-affix-wrapper">
            <input type="text" name="input_message_ticket_answer"
                class="input-msg-send form-control rounded-input" placeholder="Type your message...">
            <span class="input-suffix">
                <button type="button" class="btn btn-icon btn-flush-primary btn-rounded dropdown-toggle no-caret"
                    id="on_send_message_ticket_answer">
                    <span style="z-index: 999">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            id="Arrow-Right--Streamline-Ultimate" height="14" width="16">
                            <desc>Arrow Right Streamline Icon: https://streamlinehq.com</desc>
                            <path stroke="#000000" stroke-linecap="round" stroke-linejoin="round" d="M0.75 12h22.5"
                                stroke-width="1.5"></path>
                            <path stroke="#000000" stroke-linecap="round" stroke-linejoin="round"
                                d="M12.75 22.5 23.25 12 12.75 1.5" stroke-width="1.5"></path>
                        </svg>
                    </span>
                </button>
            </span>
        </span>
    </div>
    <span class="btn-icon btn-rounded"></span>
</footer>
<div class="chat-info">
    <div data-simplebar class="nicescroll-bar">
        <button type="button" class="info-close btn-close">
            <span aria-hidden="true">×</span>
        </button>
        <div class="text-center">
            <div class="avatar avatar-xxl avatar-rounded">
                <img src="<?php echo e($ticket['user']['user_logo']); ?>" alt="logo" class="avatar-img">
            </div>
            <div class="cp-name text-truncate mt-2"><?php echo e($ticket['user']['user_contact_name']); ?></div>
            <p class="text-truncate"><?php echo e($ticket['user']['position']['position_name']); ?></p>
        </div>
        <ul class="nav nav-justified nav-light nav-tabs nav-segmented-tabs active-theme mt-4">
            <li class="nav-item">
                <a class="nav-link active" data-bs-toggle="tab" href="#tab_info">
                    <span class="nav-link-text">Info</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="tab" href="#tab_files">
                    <span class="nav-link-text">Files</span>
                </a>
            </li>
        </ul>
        <div class="tab-content mt-4">
            <div class="tab-pane fade show active" id="tab_info">
                <div class="collapse-simple mt-3">
                    <div class="card">
                        <div class="card-header">
                            <a role="button" data-bs-toggle="collapse" href="#general_info"
                                aria-expanded="true">Thông tin</a>
                        </div>
                        <div id="general_info" class="collapse show">
                            <div class="card-body">
                                <ul class="cp-info">
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span class="cp-icon-wrap fw-bold">
                                                #<?php echo $ticket['ticket_title']; ?>

                                            </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span class="cp-icon-wrap fw-bold">
                                                #Mã kiểm tra:
                                                <?php echo e(isset($ticket['ticket_transaction_code']) ? $ticket['ticket_transaction_code'] : '---'); ?>

                                            </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span class="cp-icon-wrap fw-bold">
                                                #Note:
                                                <?php echo e(isset($ticket['ticket_note']) ? $ticket['ticket_note'] : '---'); ?>

                                            </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span class="cp-icon-wrap">
                                                <span class="feather-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="#000000"
                                                        class="bi bi-briefcase" viewBox="0 0 16 16"
                                                        id="Briefcase--Streamline-Bootstrap" height="16"
                                                        width="16">
                                                        <desc>Briefcase Streamline Icon: https://streamlinehq.com</desc>
                                                        <path
                                                            d="M6.53 1.63C5.7181 1.63 5.06 2.2881 5.06 3.1V3.59H1.63C0.8181 3.59 0.16 4.2481 0.16 5.06V12.9C0.16 13.7119 0.8181 14.37 1.63 14.37H14.37C15.1819 14.37 15.84 13.7119 15.84 12.9V5.06C15.84 4.2482 15.1818 3.59 14.37 3.59H10.94V3.1C10.94 2.2882 10.2818 1.63 9.47 1.63ZM6.53 2.61H9.47C9.7406 2.61 9.96 2.8294 9.96 3.1V3.59H6.04V3.1C6.04 2.8294 6.2594 2.61 6.53 2.61M8.3783 9.3857L14.86 7.658V12.9C14.86 13.1706 14.6406 13.39 14.37 13.39H1.63C1.3594 13.39 1.14 13.1706 1.14 12.9V7.657L7.6217 9.3857C7.8696 9.4517 8.1304 9.4517 8.3783 9.3857M1.63 4.57H14.37C14.6406 4.57 14.86 4.7894 14.86 5.06V6.6437L8.1264 8.439C8.0436 8.4612 7.9564 8.4612 7.8736 8.439L1.14 6.6437V5.06C1.14 4.7894 1.3594 4.57 1.63 4.57"
                                                            stroke-width="1"></path>
                                                    </svg>
                                                </span>
                                            </span>
                                            <?php echo e($ticket['user']['user_company_name']); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span class="cp-icon-wrap">
                                                <span class="feather-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="-0.5 -0.5 16 16"
                                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" class="feather feather-mail"
                                                        id="Mail--Streamline-Feather" height="16" width="16">
                                                        <desc>Mail Streamline Icon: https://streamlinehq.com</desc>
                                                        <path
                                                            d="M2.5 2.5h10c0.6875 0 1.25 0.5625 1.25 1.25v7.5c0 0.6875 -0.5625 1.25 -1.25 1.25H2.5c-0.6875 0 -1.25 -0.5625 -1.25 -1.25V3.75c0 -0.6875 0.5625 -1.25 1.25 -1.25z"
                                                            stroke-width="1"></path>
                                                        <path d="m13.75 3.75 -6.25 4.375L1.25 3.75" stroke-width="1">
                                                        </path>
                                                    </svg>
                                                </span>
                                            </span>
                                            <?php echo e($ticket['user']['user_name']); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span class="cp-icon-wrap">
                                                <span class="feather-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="-0.5 -0.5 16 16"
                                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" class="feather feather-user"
                                                        id="User--Streamline-Feather" height="16" width="16">
                                                        <desc>User Streamline Icon: https://streamlinehq.com</desc>
                                                        <path
                                                            d="M12.5 13.125v-1.25a2.5 2.5 0 0 0 -2.5 -2.5H5a2.5 2.5 0 0 0 -2.5 2.5v1.25"
                                                            stroke-width="1"></path>
                                                        <path d="M5 4.375a2.5 2.5 0 1 0 5 0 2.5 2.5 0 1 0 -5 0"
                                                            stroke-width="1"></path>
                                                    </svg>
                                                </span>
                                            </span>
                                            <?php echo e($ticket['user']['user_contact_name']); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span class="cp-icon-wrap">
                                                <span class="feather-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="-0.5 -0.5 16 16"
                                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" class="feather feather-phone"
                                                        id="Phone--Streamline-Feather" height="16" width="16">
                                                        <desc>Phone Streamline Icon: https://streamlinehq.com</desc>
                                                        <path
                                                            d="M13.75 10.575000000000001v1.875a1.25 1.25 0 0 1 -1.3625 1.25 12.368749999999999 12.368749999999999 0 0 1 -5.393750000000001 -1.91875 12.1875 12.1875 0 0 1 -3.75 -3.75 12.368749999999999 12.368749999999999 0 0 1 -1.91875 -5.41875A1.25 1.25 0 0 1 2.56875 1.25h1.875a1.25 1.25 0 0 1 1.25 1.075 8.025 8.025 0 0 0 0.4375 1.75625 1.25 1.25 0 0 1 -0.28125 1.3187499999999999L5.05625 6.19375a10 10 0 0 0 3.75 3.75l0.79375 -0.79375a1.25 1.25 0 0 1 1.3187499999999999 -0.28125 8.025 8.025 0 0 0 1.75625 0.4375A1.25 1.25 0 0 1 13.75 10.575000000000001z"
                                                            stroke-width="1"></path>
                                                    </svg>
                                                </span>
                                            </span>
                                            <?php echo e($ticket['user']['user_phone']); ?>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card">
                        <div class="card-header">
                            <a role="button" data-bs-toggle="collapse" href="#shipments" aria-expanded="true">
                                Đơn hàng gần đây
                            </a>
                        </div>
                        <div id="shipments" class="collapse show">
                            <div class="card-body">
                                <ul class="cp-action">
                                    <?php $__currentLoopData = $ticket['shipments']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']])); ?>"
                                                target="_blank">
                                                <?php echo e($shipment['shipment_code']); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="tab_files">
                <div class="collapse-simple mt-3">
                    <div class="card">
                        <div id="files_collapse" class="collapse show">
                            <div class="card-body">
                                <ul class="cp-files">
                                    <?php $__currentLoopData = collect($ticket['ticketMessages'])->where('ticket_type', TICKET_TYPE_FILE); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $file_info = checkFileInfo($file['ticket_message_content']);
                                        ?>
                                        <?php if(isset($file_info)): ?>    
                                            <li>
                                                <div class="media">
                                                    <div class="media-head">
                                                        <div class="avatar avatar-logo avatar-sm avatar-soft-blue">
                                                            <?php if($file_info['is_image']): ?>
                                                                <span class="initial-wrap">
                                                                    <img src="<?php echo e(asset($file['ticket_message_content'])); ?>"
                                                                        alt="file">
                                                                </span>
                                                            <?php else: ?>
                                                                <span class="initial-wrap fs-3">
                                                                    <i class="<?php echo e($file_info['icon']); ?>"></i>
                                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <div class="media-body">
                                                        <div>
                                                            <p class="file-name"><?php echo e($file_info['name']); ?></p>
                                                            <p class="file-size"><?php echo e(formatNumber($file_info['size'])); ?> KB
                                                            </p>
                                                        </div>
                                                        <div>
                                                            <a href="<?php echo e(asset($file['ticket_message_content'])); ?>"
                                                                download
                                                                class="btn btn-sm btn-icon btn-flush-dark btn-rounded flush-soft-hover no-caret">
                                                                <span class="icon">
                                                                    <span class="feather-icon">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            id="Download-Bottom--Streamline-Ultimate"
                                                                            height="24" width="24">
                                                                            <desc>Download Bottom Streamline Icon:
                                                                                https://streamlinehq.com</desc>
                                                                            <path stroke="#000000" stroke-linecap="round"
                                                                                stroke-linejoin="round" d="M12.001 3.75v12"
                                                                                stroke-width="1.5"></path>
                                                                            <path stroke="#000000" stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="m7.501 11.25 4.5 4.5 4.5 -4.5"
                                                                                stroke-width="1.5"></path>
                                                                            <path stroke="#000000" stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M23.251 15.75v1.5c0 0.7956 -0.3161 1.5587 -0.8787 2.1213 -0.5626 0.5626 -1.3257 0.8787 -2.1213 0.8787h-16.5c-0.79565 0 -1.55871 -0.3161 -2.12132 -0.8787 -0.56261 -0.5626 -0.878681 -1.3257 -0.878681 -2.1213v-1.5"
                                                                                stroke-width="1.5"></path>
                                                                        </svg>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/supports/tickets/single-chat.blade.php ENDPATH**/ ?>