<?php $__env->startSection('content'); ?>
    <div class="hk-pg-wrapper pb-0">
        <div class="p-3">
            <!-- Page Header -->
            <div class="hk-pg-header pg-header-wth-tab pt-2">
                <div class="card">
                    <div class="card-body d-flex justify-content-between">
                        <div>
                            <h5 class="pg-title">Đơn hàng: <?php echo e($package['package_code']); ?></h5>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Page Header -->

            <div class="hk-pg-body mb-5">
                <section class="row">
                    <div class="col-md-3">
                        <div class="card ">
                            <div class="card-header bg-primary">
                                <h5 class="text-white"> <i data-feather="info" class="me-1"></i>Thông tin lô hàng</h5>
                            </div>
                            <div class="card-body">
                                <div class="card mb-4">
                                    <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                                        <span>
                                            <span class="feather-icon"><i data-feather="info"></i></span>
                                            Logo dịch vụ
                                        </span>
                                    </div>
                                    <div class="card-body mt-2">
                                        <div class="">
                                            <img src="<?php echo e(asset(isset($shipment['service']['logoService']) ? $shipment['service']['logoService']['logo'] : 'assets/images/kango-post.png')); ?>"
                                                style="max-width: 100%; object-fit: cover">
                                        </div>
                                        <p class="card-text text-info">
                                            <?php echo e($shipment['service']['logoService']['title'] ?? ''); ?>

                                        </p>
                                        <p class="text-danger text-sm fst-italic">
                                            <?php echo e($shipment['service']['logoService']['description'] ?? ''); ?>

                                        </p>
                                    </div>
                                </div>

                                <div class="card mb-4">
                                    <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                                        <span>
                                            <span class="feather-icon"><i data-feather="info"></i></span>
                                            Thông tin người gửi
                                        </span>
                                    </div>
                                    <div class="card-body mt-2">
                                        <p class="card-text">
                                            - Công ty:
                                            <strong><?php echo e($shipment['user']['user_company_name']); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Tên người gửi:
                                            <strong><?php echo e($shipment['user']['user_contact_name']); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Số Điện Thoại:
                                            <strong><?php echo e($shipment['user']['user_phone']); ?></strong>
                                        </p>
                                    </div>
                                </div>

                                <div class="card mb-4">
                                    <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                                        <span>
                                            <span class="feather-icon"><i data-feather="info"></i></span>
                                            Thông tin dịch vụ
                                        </span>
                                    </div>
                                    <div class="card-body mt-2">
                                        <p class="card-text">
                                            - Dịch vụ:
                                            <strong><?php echo e($shipment['service']['service_name']); ?></strong>
                                        <p class="card-text">
                                            - Loại dịch vụ:
                                            <strong><?php echo e($service_kind_label[$shipment['service']['promotion_flg']] ?? 'Khác'); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Brand:
                                            <strong><?php echo e($shipment['branch']['branch_name']); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Dịch vụ chữ ký người nhận:
                                            <strong><?php echo e($shipment['shipment_signature_name']); ?></strong>
                                        </p>
                                    </div>
                                </div>

                                <div class="card">
                                    <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                                        <span>
                                            <span class="feather-icon"><i data-feather="info"></i></span>
                                            Thông tin người nhận
                                        </span>
                                    </div>
                                    <div class="card-body mt-2">
                                        <p class="card-text">
                                            - Công ty:
                                            <strong><?php echo e($shipment['receiver_company_name']); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Tên người nhận:
                                            <strong><?php echo e($shipment['receiver_contact_name']); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Số Điện Thoại:
                                            <strong><?php echo e($shipment['receiver_telephone']); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Địa chỉ:
                                            <strong><?php echo e($shipment['receiver_address_1']); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Thành Phố:
                                            <strong><?php echo e($shipment['city']['city_name'] ?? ''); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Post code:
                                            <strong><?php echo e($shipment['receiver_postal_code'] ?? ''); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Khu vực:
                                            <strong><?php echo e($shipment['state']['state_name'] ?? $shipment['receiver_state_name']); ?></strong>
                                        </p>
                                        <p class="card-text">
                                            - Quốc Gia:
                                            <strong><?php echo e($shipment['country']['country_name']); ?></strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-9">
                        <div class="card ">
                            <div class="card-header bg-primary">
                                <h5 class="text-white"><i data-feather="package" class="me-1"></i> Thông tin kiện hàng
                                </h5>
                            </div>
                            <div class="card-body">
                                <hr>
                                <h6 class="text-uppercase">Chỉnh sửa danh sách phụ thu</h6>
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr class="table-warning">
                                                <th>Mã HAWB</th>
                                                <th>Type</th>
                                                <th>Weight(kg)</th>
                                                <th class="text-uppercase">Converted Weight</th>
                                                <th class="text-uppercase">Charged Weight</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="table-secondary">
                                                <td><?php echo e($package['package_hawb_code']); ?></td>
                                                <td><?php echo e($package_types[$package['package_type']]); ?></td>
                                                <td><strong><?php echo e($package['package_weight']); ?></strong> kg </td>
                                                <td> <?php echo e($package['package_length']); ?>(<strong>L</strong>)x
                                                    <?php echo e($package['package_weight']); ?>(<strong>W</strong>)x
                                                    <?php echo e($package['package_height']); ?>(<strong>H</strong>)/6000 =
                                                    <?php echo e($package['package_converted_weight']); ?>

                                                </td>
                                                <td><strong> <?php echo e($package['package_charged_weight']); ?> kg</strong></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <hr>
                                <h6 class="text-uppercase">Chỉnh sửa danh sách phụ thu</h6>
                                <div class="row">
                                    <div class="form-floating col-sm-3 mb-3">
                                        <input value="<?php echo e($package['package_length']); ?>" type="number" class="form-control"
                                            id="length" min="0" readonly style="cursor: not-allowed;">
                                        <label for="length">Length</label>
                                    </div>
                                    <div class="form-floating col-sm-3 mb-3">
                                        <input value="<?php echo e($package['package_width']); ?>" type="number" class="form-control"
                                            id="width" min="0" readonly style="cursor: not-allowed;">
                                        <label for="width">Width</label>
                                    </div>
                                    <div class="form-floating col-sm-3 mb-3">
                                        <input value="<?php echo e($package['package_height']); ?>" type="number" class="form-control"
                                            id="height" min="0" readonly style="cursor: not-allowed;">
                                        <label for="height">Height</label>
                                    </div>
                                    <div class="form-floating col-sm-3">
                                        <input value="<?php echo e($package['package_weight']); ?>" type="number" class="form-control"
                                            id="weight" min="0" readonly style="cursor: not-allowed;">
                                        <label for="weight">Weight</label>
                                    </div>
                                    <h7><strong>Khai hàng</strong></h7>
                                    <div id="declare-internal-goods-container">
                                        <?php $__currentLoopData = $package_surcharge_goods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $surcharge_good): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="row surcharge-row">
                                                <div class="col-sm-7 mt-3">
                                                    <select class="form-select col-sm-8 surcharge-selector"
                                                        name="declare_internal_goods" id=""
                                                        aria-label="Default select example">
                                                        <?php $__currentLoopData = $surcharge_goods_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goods): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option
                                                                data-surcharge-price="<?php echo e($goods['surcharge_goods_price']); ?>"
                                                                value="<?php echo e($goods['surcharge_goods_id']); ?>"
                                                                <?php echo e($goods['surcharge_goods_id'] == $surcharge_good['surcharge_goods_id'] ? 'selected' : ''); ?>>
                                                                <?php echo e($goods['surcharge_goods_id']); ?>-<?php echo e($goods['surcharge_goods_name']); ?>[<?php echo e($goods['surcharge_goods_price']); ?>/<?php echo e($goods['surcharge_goods_type']); ?>]
                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="col-sm-4 mt-3">
                                                    <input value="<?php echo e($surcharge_good['count']); ?>" type="number"
                                                        class="form-control" id="count" min="1"
                                                        placeholder="Số lượng">
                                                </div>
                                                <div class="col-sm-1 mt-3">
                                                    <button type="button" class="btn btn-sm btn-outline-danger">
                                                        <i data-feather="trash-2" class="me-1"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="col-sm-12 mt-3 text-start">
                                        <button type="button" id="declare-internal-goods-btn"
                                            class="btn btn-sm btn-danger">
                                            <i data-feather="plus" class="me-1"></i> Thêm
                                        </button>
                                    </div>
                                    <div class="mt-3 col-sm-12 text-end">
                                        <button data-package-id="<?php echo e($package['package_id']); ?>" type="button"
                                            id="update-surcharge-btn" class="btn btn-primary">Cập nhật</button>
                                    </div>
                                </div>

                                <hr style="border-top: 2px solid red;">

                                <h6 class="text-uppercase mb-3">Chỉnh sửa danh sách phụ thu ngoài hệ thống</h6>
                                <div id="declare-external-goods-container">
                                    <div class="row">
                                        <div class="mb-3 col-sm-5">
                                            <label for="" class="form-label">Nhập tên mặt hàng phụ thu</label>
                                        </div>
                                        <div class="mb-3 col-sm-3">
                                            <label for="" class="form-label">Nhập số lượng</label>
                                        </div>
                                        <div class="mb-3 col-sm-3">
                                            <label for="" class="form-label">Nhập đơn giá/số lượng</label>
                                        </div>
                                        <div class="mb-3 col-sm-1">
                                            <label for="" class="form-label"></label>
                                        </div>

                                        <?php $__currentLoopData = $package_external_surcharge_goods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $external_surcharge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="row external-surcharge-row">
                                                <div class="mb-3 col-sm-5">
                                                    <input value="<?php echo e($external_surcharge['external_surcharge_name']); ?>" type="text"
                                                        class="form-control" id="external-surcharge-name"
                                                        placeholder="Nhập tên mặt hàng phụ thu ngoài hệ thống">
                                                </div>
                                                <div class="mb-3 col-sm-3">
                                                    <input value="<?php echo e($external_surcharge['count']); ?>" type="number"  
                                                        class="form-control" id="external-surcharge-quantity" min="1"
                                                        placeholder="Số lượng">
                                                </div>
                                                <div class="mb-3 col-sm-3">
                                                    <input value="<?php echo e($external_surcharge['external_surcharge_unit_price']); ?>" type="number"
                                                        class="form-control" id="external-surcharge-unit-price" min="1"
                                                        placeholder="Đơn giá">
                                                </div>
                                                <div class="col-sm-1">
                                                    <button type="button" class="btn btn-sm btn-outline-danger">
                                                        <i data-feather="trash-2" class="me-1"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        
                                    </div>
                                </div>
                                <div class="col-sm-12 mt-3 text-start">
                                    <button type="button" id="declare-external-goods-btn" class="btn btn-sm btn-danger">
                                        <i data-feather="plus" class="me-1"></i> Thêm
                                    </button>
                                </div>
                                <div class="mb-3 col-sm-12 text-end">
                                    <button data-package-id="<?php echo e($package['package_id']); ?>" type="button" 
                                        id="update-external-surcharge-btn" class="btn btn-primary">Cập nhật</button>
                                </div>

                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
        <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/shipment/detail-imported-goods.js')); ?>"></script>
    <script>
        const internalSurchargeTemplateHtml = `
            <div class="row surcharge-row">
                <div class="col-sm-7 mt-3">
                    <select class="form-select col-sm-8 surcharge-selector" name="declare_goods" id=""
                        aria-label="Default select example">
                        <?php $__currentLoopData = $surcharge_goods_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goods): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option data-surcharge-price="<?php echo e($goods['surcharge_goods_price']); ?>" value="<?php echo e($goods['surcharge_goods_id']); ?>"
                                <?php echo e($goods['surcharge_goods_id'] == $package['surcharge_goods_id'] ? 'selected' : ''); ?>>
                                <?php echo e($goods['surcharge_goods_id']); ?>-<?php echo e($goods['surcharge_goods_name']); ?>[<?php echo e($goods['surcharge_goods_price']); ?>/<?php echo e($goods['surcharge_goods_type']); ?>]
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-sm-4 mt-3">
                    <input value="1" type="number" class="form-control"
                        id="count" min="1" placeholder="Số lượng">
                </div>
                <div class="col-sm-1 mt-3">
                    <button type="button" class="btn btn-sm btn-outline-danger">
                        <i data-feather="trash-2" class="me-1"></i>
                    </button>
                </div>
            </div>
        `;
        // <label for="goods_name" class="form-label">Nhập tên mặt hàng phụ thu</label>
        // <label for="quantity" class="form-label">Nhập số lượng</label>
        // <label for="price_quotation" class="form-label">Nhập đơn giá/số lượng</label>


        const externalSurchargeTemplateHtml = `
            <div class="row external-surcharge-row">
                <div class="mb-3 col-sm-5">
                    <input type="text" class="form-control" id="external-surcharge-name"
                        placeholder="Nhập tên mặt hàng phụ thu ngoài hệ thống">
                </div>
                <div class="mb-3 col-sm-3">
                    <input type="number" value="1" class="form-control" id="external-surcharge-quantity" min="1"
                        placeholder="Số lượng">
                </div>
                <div class="mb-3 col-sm-3">
                    <input type="number" value="1" class="form-control" id="external-surcharge-unit-price" min="1"
                        placeholder="Đơn giá">
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-sm btn-outline-danger">
                        <i data-feather="trash-2" class="me-1"></i>
                    </button>
                </div>
            </div>
            `;
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/shipment/detail-imported-goods.blade.php ENDPATH**/ ?>