<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>PRINT BILL KANGO <?php echo e($shipment['shipment_code']); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>">
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" type="image/x-icon">
    <!-- CSS -->
    <link href="<?php echo e(asset('assets/dist/css/style.css')); ?>" rel="stylesheet" type="text/css">
    <style>
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }

        @media print {
            @page {
                margin-left: 0in;
                margin-right: 0in;
                margin-top: 0in;
                margin-bottom: 0;
            }

            .pt-5 {
                padding-top: 1.3rem !important;
            }

            .form-print-bill {
                width: 100%;
                height: 100vh;
            }

            .fs-5 {
                font-size: 0.7rem !important;
            }

            .fs-6 {
                font-size: 0.7rem !important;
            }

            .fs-7 {
                font-size: 0.6rem !important;
            }

            .fs-8 {
                font-size: 0.5rem !important;
            }

            .mb-3 {
                margin-bottom: 0.3rem !important;
            }

            .mb-4 {
                margin-bottom: 0.4rem !important;
            }

            .mb-5 {
                margin-bottom: 0.5rem !important;
            }

            .container {
                max-width: 100% !important;
            }
        }
    </style>
</head>

<body>
    <?php
        $is_epacket_imported = false;
    ?>
    <?php for($i = 0; $i < 3; $i++): ?>
        <div class="p-5 pt-5 fs-7 d-flex justify-content-center form-print-bill container">
            <div>
                <div class="row row-cols-2 border border-dark">
                    <div class="col-4 border-end border-dark">
                        <div
                            style="width: 100%; height: 100%; display: flex; justify-content: center; align-items: center;">
                            <?php if(onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id'])): ?>
                                <img src="<?php echo e(asset('assets/images/logo-kango.png')); ?>" alt=""
                                    style="max-width: 100%; max-height: 100%; object-fit: contain;">
                            <?php else: ?>
                                <img src="<?php echo e(asset('assets/images/KIKI-logo.png')); ?>" alt=""
                                        style="max-width: 100%; max-height: 100%; object-fit: contain;">
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-8 fs-8">
                        <div class="row p-0">
                            <div class="col-6 p-0 border-end border-dark">
                                <div class="text-danger fw-bold fs-6 d-flex justify-content-center align-items-center"
                                    style="height: 50px">
                                    <?php if(onCheckPositionAccount(SETTING_SALE_ACCOUNT, auth()->user()['position_id'])): ?>
                                        KIKI EXPRESS
                                    <?php else: ?>
                                        KANGO EXPRESS
                                    <?php endif; ?>
                                </div>
                                <div style="height: 80px"
                                    class="text-dark fw-bold d-flex justify-content-center align-items-center border-top border-dark">
                                    Telephone: <?php echo e($system_settings[SETTING_HOTLINE]['value']); ?>

                                </div>
                            </div>
                            <div class="col-6 p-0">
                                <div style="height: 50px" class="d-flex justify-content-center align-items-center">
                                    <?php echo $barcode; ?>

                                </div>
                                <div style="height: 80px"
                                    class="d-flex justify-content-center align-items-center flex-column border-top border-dark">
                                    <div class="fs-5">Air waybill</div>
                                    <div class="text-dark fw-bold fs-4"><?php echo e($shipment['shipment_code']); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row row-cols-3 border border-top-0 border-dark text-dark fst-italic">
                    <div class="col text-center p-1 border-end border-dark">
                        <span class="fw-bold fs-6">
                            <?php if(settingPrintBillType()): ?>
                                Website: https://kikiexpress.vn/
                            <?php else: ?>
                                Website: http://<?php echo e(Str::lower($system_settings[SETTING_WEBSITE_ADDRESS]['value'])); ?>

                            <?php endif; ?>
                        </span>
                    </div>
                    <div class="col text-center p-1 border-end border-dark">
                        <span class="fw-bold fs-6">
                            Branch: <?php echo e($shipment['branch']['branch_name']); ?>

                        </span>
                    </div>
                    <div class="col text-center p-1">
                        <span class="fw-bold fs-6">
                            Service: <?php echo e($shipment['service']['service_name']); ?>

                        </span>
                    </div>
                </div>
                <div class="row row-cols-1 border border-top-0 border-dark">
                    <div class="col text-center p-1">
                        <span class="fw-bold fs-8 text-dark fst-italic">
                            Address: <?php echo e($shipment['branch']['branch_description']); ?>

                        </span>
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark p-1 bg-gradient-warning">
                    <div class="col">
                        <span class="fw-bold fst-italic text-dark">1. From (Senders) :</span>
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark text-dark">
                    <div class="col border-end border-dark">
                        <div class="d-flex align-content-between flex-column">
                            <div class="row row-cols-2">
                                <div class="col mt-1">
                                    <div class="fst-italic">
                                        Account Number
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['user']['user_code']); ?>

                                    </div>
                                </div>
                                <div class="col mt-1">
                                    <div class="fst-italic">
                                        Internal Reference
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['user']['reference_code']); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-2">
                                <div class="col">
                                    <div class="fst-italic">
                                        Contact Name
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['sender_contact_name']); ?>

                                    </div>
                                </div>
                                <div class="col">
                                    <div class="fst-italic">
                                        Phone
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['sender_telephone']); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-1">
                                <div class="col">
                                    <div class="fst-italic">
                                        Company Name
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['sender_company_name']); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-1">
                                <div class="col">
                                    <div class="fst-italic">
                                        Zip Code/Postal Code
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['user']['zip_code']); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-1">
                                <div class="col">
                                    <div class="fst-italic">
                                        Address
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['sender_address']); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-1 mb-1">
                                <div class="col">
                                    <div class="fst-italic">
                                        Ward, District, City, Country
                                    </div>
                                    <div class="fs-6">
                                        <?php echo e($shipment['sender_ward_name']); ?>,
                                        <?php echo e($shipment['sender_district_name']); ?>,
                                        <?php echo e($shipment['sender_city_name']); ?>,
                                        Viet Nam
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="row row-cols-3" style="height:calc(100% / 3)">
                            <div class="col border-dark border-end d-flex justify-content-center align-items-center">
                                Packages Number
                            </div>
                            <div class="col border-dark border-end d-flex justify-content-center align-items-center">
                                Gross Weight
                            </div>
                            <div class="col d-flex justify-content-center align-items-center">
                                Charged Weight
                            </div>
                        </div>
                        <div class="row row-cols-3 border-top border-dark fs-5" style="height:calc(100% / 3)">
                            <div class="fs-4 col border-dark border-end d-flex justify-content-center align-items-center">
                                <?php echo e(collect($shipment['packages'])->where('package_status', '!=', SHIPMENT_STATUS_RETURNED)->count()); ?>

                            </div>
                            <div class="fs-4 col border-dark border-end d-flex justify-content-center align-items-center">
                                <?php echo e(collect($shipment['packages'])->where('package_status', '!=', SHIPMENT_STATUS_RETURNED)->sum($is_epacket_imported ? 'package_weight_actual' : 'package_weight')); ?>

                            </div>
                            <div class="fs-4 col d-flex justify-content-center align-items-center">
                                <?php echo e(collect($shipment['packages'])->where('package_status', '!=', SHIPMENT_STATUS_RETURNED)->sum($is_epacket_imported ? 'package_charged_weight_actual' : 'package_charged_weight')); ?>

                            </div>
                        </div>
                        <div class="row row-cols-3 border-top border-dark" style="height:calc(100% / 3)">
                            <?php if(onCheckPositionAccount(SETTING_SALE_ACCOUNT, auth()->user()['position_id'])): ?>
                                <div
                                    class="col-3 border-dark border-end d-flex justify-content-center align-items-center flex-column">
                                    <div class="fst-italic fs-8 text-center">Bảo hiểm hàng hóa</div>
                                    <div>
                                        <?php echo e($shipment['shipment_amount_insurance'] > 0 ? 'YES' : 'NO'); ?>

                                    </div>
                                </div>
                                <div
                                    class="col-3 border-dark border-end d-flex justify-content-center align-items-center flex-column">
                                    <div class="fst-italic fs-8 text-center">Giá Trị Khai Báo Bảo Hiểm</div>
                                    <div>
                                        <?php echo e(formatNumber($shipment['shipment_amount_insurance'])); ?>

                                    </div>
                                </div>
                                <div
                                    class="col-3 d-flex justify-content-center align-items-center flex-column border-end border-dark">
                                    <div class="fst-italic fs-8 text-center">Phí Mua Bảo Hiểm</div>
                                    <div>
                                        <?php echo e(formatNumber($shipment['shipment_amount_insurance'])); ?>

                                    </div>
                                </div>
                                <div class="col-3 d-flex justify-content-center align-items-center flex-column">
                                    <div class="fst-italic fs-8 text-center">Total Pay</div>
                                    <div>

                                        <?php echo e(formatNumber($shipment['shipment_amount_total_customer'])); ?>

                                    </div>
                                </div>
                            <?php else: ?>
                                <div
                                    class="col border-dark border-end d-flex justify-content-center align-items-center flex-column">
                                    <div class="fst-italic fs-8">Receiver's Signature</div>
                                    <div>
                                        <?php echo e($shipment['shipment_signature_flg'] == SHIPMENT_SIGNATURE_YES ? 'YES' : 'NO'); ?>

                                    </div>
                                </div>
                                <div
                                    class="col d-flex justify-content-center align-items-center flex-column border-end border-dark">
                                    <div class="fst-italic fs-8">Payment Type</div>
                                    <div>
                                        SPX
                                    </div>
                                </div>
                                <div class="col d-flex justify-content-center align-items-center flex-column">
                                    <div class="fst-italic fs-8">Payment Type</div>
                                    <div>

                                        <?php echo e($shipment['shipment_payment_method_name']); ?>

                                    </div>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark p-1 bg-gradient-warning">
                    <div class="col">
                        <span class="fw-bold fst-italic text-dark">2. To (Receiver):</span>
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark text-dark">
                    <div class="col border-end border-dark">
                        <div class="d-flex align-content-between flex-column">
                            <div class="row row-cols-2 mt-1">
                                <div class="col">
                                    <div class="fst-italic">
                                        Contact Name
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['receiver_contact_name']); ?>

                                    </div>
                                </div>
                                <div class="col">
                                    <div class="fst-italic">
                                        Phone
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['receiver_telephone']); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-2">
                                <div class="col">
                                    <div class="fst-italic">
                                        Company Name
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['receiver_company_name']); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-1">
                                <div class="col">
                                    <div class="fst-italic">
                                        Street Address
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['receiver_address_1'] ?? ''); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-1">
                                <div class="col">
                                    <div class="fst-italic">
                                        Street Address
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['receiver_address_2'] ?? ''); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-2">
                                <div class="col">
                                    <div class="fst-italic">
                                        City
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e($shipment['city']['city_name'] ?? ''); ?>

                                    </div>
                                </div>
                                <div class="col">
                                    <div class="fst-italic">
                                        State
                                    </div>
                                    <div class="fs-6 mb-3">
                                        <?php echo e(empty($shipment['receiver_state_name']) ? $shipment['state']['state_name'] : $shipment['receiver_state_name']); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row row-cols-2 mb-1">
                                <div class="col">
                                    <div class="fst-italic">
                                        Country
                                    </div>
                                    <div class="fs-6">
                                        <?php echo e($shipment['country']['country_name']); ?>

                                        -
                                        <?php echo e($shipment['country']['country_code'] ?? ''); ?>

                                    </div>
                                </div>
                                <div class="col">
                                    <div class="fst-italic">
                                        Zip/Post Code
                                    </div>
                                    <div class="fs-6">
                                        <?php echo e($shipment['receiver_postal_code']); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="row row-cols-4 fw-bold fs-6"
                            style="height:calc(100% / <?php echo e(collect($shipment['packages'])->where('package_status', '!=', SHIPMENT_STATUS_RETURNED)->count() + 1); ?>)">
                            <div
                                class="col border-dark border-end d-flex justify-content-center align-items-center bg-warning">
                                Quantity
                            </div>
                            <div
                                class="col border-dark border-end d-flex justify-content-center align-items-center bg-warning">
                                L (cm)
                            </div>
                            <div
                                class="col border-dark border-end d-flex justify-content-center align-items-center bg-warning">
                                W (cm)
                            </div>
                            <div class="col d-flex justify-content-center align-items-center bg-warning">
                                H (cm)
                            </div>
                        </div>
                        <?php $__currentLoopData = $to_receiver_packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="row row-cols-4 border-top border-dark fs-5 <?php echo e(collect($package)->first()['package_status'] != SHIPMENT_STATUS_RETURNED ? '' : 'd-none'); ?>"
                                style="height:calc(100% / <?php echo e(collect($shipment['packages'])->where('package_status', '!=', SHIPMENT_STATUS_RETURNED)->count() + 1); ?>)">
                                <div
                                    class="col border-dark border-end d-flex justify-content-center align-items-center">
                                    
                                    <?php echo e(count($package)); ?>

                                </div>
                                <div
                                    class="col border-dark border-end d-flex justify-content-center align-items-center">
                                    <?php echo e(collect($package)->first() ? collect($package)->first()[$is_epacket_imported ? 'package_length_actual' : 'package_length'] : ''); ?>

                                </div>
                                <div
                                    class="col border-dark border-end d-flex justify-content-center align-items-center">
                                    <?php echo e(collect($package)->first() ? collect($package)->first()[$is_epacket_imported ? 'package_width_actual' : 'package_width'] : ''); ?>

                                </div>
                                <div class="col d-flex justify-content-center align-items-center">
                                    <?php echo e(collect($package)->first() ? collect($package)->first()[$is_epacket_imported ? 'package_height_actual' : 'package_height'] : ''); ?>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark p-1 bg-gradient-warning">
                    <div class="col">
                        <span class="fw-bold fst-italic text-dark">3. Thông tin Đơn hàng (Shipment Information)</span>
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark p-1">
                    <div class="col">
                        <span>Description of goods : <?php echo e($shipment['shipment_goods_name']); ?></span>
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark p-1">
                    <div class="col">
                        <span>Value invoice: <?php echo e($shipment['shipment_value']); ?>$</span>
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark fw-bold text-dark">
                    <div class="col border-end border-dark">
                        <div class="fs-7 mt-1">
                            Đồng Ý Điều Khoản / Shippers Signature
                        </div>
                        <div class="mb-5" style="font-size:10px">
                            Tôi/Chúng tôi đồng ý sử dụng điều khoản của Kango trên vận đơn đường hàng không này áp dụng
                            cho
                            lô hàng này và giới hạn tổn thất hoặc thiệt hại cao nhất là $100,00 USD /1 lô hàng.
                            Tôi/Chúng tôi hiểu rằng Kango không VẬN CHUYỂN TIỀN MẶT và xác nhận rằng tất cả lô hàng
                            không
                            chứa bất kỳ chất nổ trái phép, thiết bị phá hoại nào hoặc vật liệu nguy hiểm theo IATA và
                            điều
                            khoản sử dụng dịch vụ của Kango Express. Tôi biết rằng sự xác nhận và chữ ký gốc, cùng với
                            các
                            tài liệu khác, sẽ được được lưu giữ trong hồ sơ cho đến khi lô hàng được giao.
                        </div>
                        <div class="row mb-1">
                            <div class="col-auto">Signature</div>
                            <div class="col" style="border-bottom: 1px dashed;"></div>
                            <div class="col-auto">Date Created: <?php echo e(formatDate($shipment['created_at'])); ?></div>
                        </div>
                    </div>
                    <div class="col fs-7">
                        <div class="mt-1 mb-4">
                            Xác Nhận Nhận Hàng Của Kango / Collected for Kango Express
                        </div>
                        <div class="row">
                            <div class="col-auto">Tên Nhân Viên / Name: <?php echo e($scaner['user_contact_name'] ?? ''); ?></div>
                            <div class="col-12 justify-content-center">
                                <?php if(isset($scaner['user_signature'])): ?>
                                    <div class="p-3" style="">
                                        <img src="<?php echo e(asset($scaner['user_signature'])); ?>" alt=""
                                            style="width: 100%; height: 100%;object-fit: cover;">
                                    </div>
                                <?php endif; ?>
                                <div class="text-center col-12" style="border-bottom: 1px dashed;">
                                    <?php if(isset($scaner['user_signature'])): ?>
                                        <p><?php echo e($scaner['user_contact_name'] ?? ''); ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="col-12 text-center">
                                    <?php if(isset($scaner['user_signature'])): ?>
                                        <p><?php echo e($scaner['user_contact_name'] ?? ''); ?></p>
                                    <?php endif; ?>
                                    <p>Ngày nhập:
                                        <?php echo e(isset($scaner['created_at']) ? formatFullDate($scaner['created_at']) : ''); ?></p>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endfor; ?>
    <div class="p-5 pt-5 fs-7 form-print-bill container text-dark">
        <div class="fw-bold fs-5 text-center col-12 d-print-none mb-3">
            CÔNG VĂN CAM KẾT NỘI DUNG HÀNG XUẤT
        </div>
        <div class="fw-bold fs-5 fst-italic text-center col-12 mb-5 d-print-none mb-3">
            LETTER OF GUARANTEE
        </div>
        <div class="fw-bold fs-5 text-center col-12 mb-3">
            Kính gửi: CHI CỤC HẢI QUAN CHUYỂN PHÁT NHANH (Express Customs Offices)
        </div>
        <div class="fw-bold fs-5 text-center col-12 mb-3">
            Dear: ĐỘI SOI CHIẾU AN NINH HÀNG KHÔNG (Airline Security Screening)
        </div>
        <div class="fw-bold fs-5 text-center col-12 mb-3">
            <?php echo e($shipment['user']['user_company_name']); ?>

        </div>
        <div class="fw-bold fs-5 text-center col-12 mb-4">
            CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO / KANGO LOGISTICS
        </div>
        <div class="fs-6 mb-3">
            Chúng tôi/ We are: KANGO EXPRESS
        </div>
        <div class="fs-6 mb-3">
            Mã số thuế (Chứng minh nhân dân)/ Tax code or ID: AAABBB
        </div>
        <div class="fs-6 mb-3">
            Địa chỉ/ Address:
        </div>
        <div class="fs-6 mb-3">
            Chúng tôi có một lô hàng với số vận đơn / We have shipment with AWB no:
            <?php echo e($shipment['shipment_code']); ?>

        </div>
        <div class="fs-6 mb-3">
            Số kiện: <?php echo e(count($shipment['packages'])); ?>

        </div>
        <div class="fs-6 mb-3">
            Trọng lượng: <?php echo e(collect($shipment['packages'])->sum('package_charged_weight')); ?>

        </div>
        <div class="fs-6 col-12 mb-3">
            Tên hàng và chi tiết hàng hóa/ Commodity and description of goods
            <table class="table table-bordered border-dark">
                <thead>
                    <tr>
                        <th class="fs-6">#</th>
                        <th class="fs-6">Full Description of Goods</th>
                        <th class="fs-6">Unit Type</th>
                        <th class="fs-6">Unit</th>
                        <th class="fs-6">Unit Price</th>
                        <th class="fs-6">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $shipment['invoices']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td>
                                <?php echo e($invoice['invoice_goods_details']); ?>

                            </td>
                            <td>
                                <?php echo e($invoice['invoice_unit_name']); ?>

                            </td>
                            <td>
                                <?php echo e($invoice['invoice_quantity']); ?>

                            </td>
                            <td>
                                <?php echo e($invoice['invoice_price']); ?>

                            </td>
                            <td>
                                <?php echo e($invoice['invoice_total_price']); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="fs-6 mb-3">
            Chúng tôi xin cam kết lô hàng trên của chúng tôi gửi đi là hàng không độc hại, không phải là hàng quốc cấm,
            không có chất ăn mòn, không phải là hàng Pin bị hư hại, không có nguy cơ gây cháy nổ, không chứa khí, Gas và
            không có bất kỳ thành phần nào cấm vận chuyển bằng đường hàng không.hàng hóa cấm xuất nhập khẩu tại cửa khẩu
            đi và đến.Tất cả thông tin cung cấp trên vận đơn và hóa đơn đính kèm hàng là chính xác. Nếu có
            bất kì vấn đề sự cố nào xảy ra, Chúng tôi xin chịu hoàn toàn mọi trách nhiệm với nội dung khai báo trên.
        </div>
        <div class="fs-6 mb-4">
            We commit that the above shipment non-banned from export. It is non-dangerous goods according to IATA
            Regulations and poses no risk to environment & community and is not included in the non-restriction goods in
            origin and destination regulated by the local authorities. We declare all the information contained in this
            letter to be true and correct. If any problem occurs, We would like to take full responsibility before the
            law for the content of the above declaration.
        </div>
        <div class="row">
            <div class="col-6"></div>
            <div class="col-6 text-center">
                <div class="mb-3 fs-6 text-danger">
                    HCM , Ngày <?php echo e(\Carbon\Carbon::now()->format('d')); ?> Tháng <?php echo e(\Carbon\Carbon::now()->format('m')); ?>

                    Năm <?php echo e(\Carbon\Carbon::now()->format('Y')); ?>

                </div>
                <div class="mb-3 fs-6 fst-italic">
                    Ký tên, đóng dấu
                </div>
                <div class="mb-3 fs-6 fst-italic">
                    (Ghi rõ họ tên, chức vụ)
                </div>
                <div class="mb-3 fs-6 fst-italic">
                    Name/ Title & Sign:
                </div>
            </div>
        </div>
    </div>
    <script>
        var is_printed = false;
        window.onload = async function() {
            await window.scrollTo(0, 0);
            if (window.scrollY == 0 && !is_printed) {
                is_printed = true;
                window.print();
            }
            window.addEventListener('scroll', function() {
                if (window.scrollY == 0 && !is_printed) {
                    is_printed = true;
                    window.print();
                }
            });
        }
    </script>
</body>

</html>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/shipment/prints/bill.blade.php ENDPATH**/ ?>