<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>Date Create</th>
                <th>Người tạo</th>
                <th>ID Bill Kango</th>
                <th>WEIGHT(KG)</th>
                <th>Weight Diff</th>
                <th>Price Created</th>
                <th>Price Actual</th>
                <th>Price Diff</th>
                <th>Note</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $colors = ['secondary', 'success', 'warning', 'danger'];
            ?>
            <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $package_length = collect($shipment['packages'])->sum('package_length');
                    $package_width = collect($shipment['packages'])->sum('package_width');
                    $package_height = collect($shipment['packages'])->sum('package_height');
                    $package_weight = collect($shipment['packages'])->sum('package_weight');
                    $package_charged_weight = collect($shipment['packages'])->sum('package_charged_weight');

                    $package_length_actual = collect($shipment['packages'])->sum('package_length_actual');
                    $package_width_actual = collect($shipment['packages'])->sum('package_width_actual');
                    $package_height_actual = collect($shipment['packages'])->sum('package_height_actual');
                    $package_weight_actual = collect($shipment['packages'])->sum('package_weight_actual');
                    $package_charged_weight_actual = collect($shipment['packages'])->sum(
                        'package_charged_weight_actual',
                    );
                ?>
                <tr class="odd">
                    <td>
                        <button id="btn_shipment_<?php echo e($key); ?>" onclick="showShipmentDetail('<?php echo e($key); ?>')"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#shipment_<?php echo e($key); ?>"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td><?php echo e(formatFullDate($shipment['created_at'])); ?></td>
                    <td><?php echo e($shipment['user']['user_contact_name']); ?></td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="<?php echo e(route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']])); ?>">
                            <?php echo e($shipment['shipment_code']); ?>

                        </a>
                    </td>
                    <td class="align-items-center">
                        <?php echo e(formatNumber($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE ? $package_charged_weight : $package_charged_weight_actual)); ?>

                    </td>
                    <?php if($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE): ?>
                        <td class="text-success">
                            0
                        </td>
                    <?php else: ?>
                        <td
                            class="<?php echo e($package_charged_weight > $package_charged_weight_actual ? 'text-danger' : 'text-success'); ?>">
                            <?php echo e($package_charged_weight_actual - $package_charged_weight); ?>

                        </td>
                    <?php endif; ?>

                    <td>
                        <?php echo e(formatNumber($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE ? $shipment['shipment_final_amount'] : $shipment['shipment_total_amount_actual'])); ?>

                    </td>
                    <td>
                        <?php echo e(formatNumber($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE ? 0 : $shipment['shipment_final_amount'])); ?>

                    </td>
                    <?php if($shipment['shipment_status'] == SHIPMENT_STATUS_CREATE): ?>
                        <td class="text-success">
                            <?php echo e(formatNumber($shipment['shipment_final_amount'])); ?>

                        </td>
                    <?php else: ?>
                        <td
                            class="<?php echo e($shipment['shipment_total_amount_actual'] < $shipment['shipment_final_amount'] ? 'text-danger' : 'text-success'); ?>">
                            <?php echo e(formatNumber($shipment['shipment_total_amount_actual'] - $shipment['shipment_final_amount'])); ?>

                        </td>
                    <?php endif; ?>

                    <td>
                        <?php if(!isGetAllData()): ?>
                            <?php echo e($shipment['shipment_note']); ?>

                        <?php else: ?>
                            <input type="text" class="form-control change_shipment_note"
                                data-shipment_code="<?php echo e($shipment['shipment_code']); ?>"
                                value="<?php echo e($shipment['shipment_note']); ?>">
                        <?php endif; ?>
                    </td>
                </tr>
                <?php $__currentLoopData = $shipment['packages']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="child collapse" id="shipment_<?php echo e($key); ?>">
                        <td class="child" colspan="5">
                            <ul>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        HAWB Kango:
                                    </span>
                                    <span class="dtr-data fw-bold text-secondary">
                                        <?php echo e($package['package_hawb_code']); ?>

                                        <?php if($package['package_tracking_code']): ?>
                                            -
                                            <?php echo e($package['package_tracking_code']); ?>

                                            <a href="<?php echo e(getUrlTracking($package['package_hawb_code'])); ?>"
                                                target="_blank">
                                                <i class="fas fa-map-marker-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        Người tạo:
                                    </span>
                                    <span class="dtr-data fw-bold text-secondary">
                                        <?php echo e($shipment['user']['user_contact_name']); ?>

                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        L:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_length'] : $package['package_length_actual'])); ?>

                                        -
                                        H:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_width'] : $package['package_width_actual'])); ?>

                                        -
                                        R:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_height'] : $package['package_height_actual'])); ?>

                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        GW Created:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_weight'] : $package['package_weight_actual'])); ?>

                                        -
                                        CW Created:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? $package['package_charged_weight'] : $package['package_charged_weight_actual'])); ?>

                                    </span>
                                </li>
                            </ul>
                        </td>
                        <td></td>
                        <td class="child" colspan="5">
                            <ul>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        Nhân viên xử lý:
                                    </span>
                                    <span class="dtr-data fw-bold text-secondary">
                                        <?php echo e($shipment['packages'][0]['processingStaff']['user_code'] ?? ''); ?>

                                        -
                                        <?php echo e($shipment['packages'][0]['processingStaff']['user_contact_name'] ?? ''); ?>

                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        Trạng thái:
                                    </span>
                                    <span class="dtr-data">
                                        <small class="badge badge-<?php echo e($colors[$package['package_approve']]); ?>">
                                            <?php echo e($package['package_approve_name']); ?>

                                        </small>
                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        L:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_length'])); ?>

                                        -
                                        H:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_width'])); ?>

                                        -
                                        R:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_height'])); ?>

                                    </span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title">
                                        Actual GW Created:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_weight'])); ?>

                                        -
                                        Actual CW Created:
                                        <?php echo e(formatNumber($package['package_status'] == SHIPMENT_STATUS_CREATE ? 0 : $package['package_charged_weight'])); ?>

                                    </span>
                                </li>
                            </ul>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    <?php echo e($shipments->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/audit-epacket/pagination.blade.php ENDPATH**/ ?>