<?php

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ListController;
use App\Http\Controllers\ScanController;
use App\Http\Controllers\DebitController;
use App\Http\Controllers\SepayController;
use App\Http\Controllers\CreditController;
use App\Http\Controllers\ManageController;
use App\Http\Controllers\NzPostController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\CirroAuController;
use App\Http\Controllers\WisewayController;
use App\Http\Controllers\ShipmentController;
use App\Http\Controllers\TransferController;
use App\Http\Controllers\StatementController;
use App\Http\Controllers\UtilitiesController;
use App\Http\Controllers\AccountantController;
use App\Http\Controllers\BulkUploadController;
use App\Http\Controllers\SmsManagerController;
use App\Http\Controllers\ApiDocumnetController;
use App\Http\Controllers\LogoServiceController;
use App\Http\Controllers\MawbManagerController;
use App\Http\Controllers\OrderPickupController;
use App\Http\Controllers\SaleManagerController;
use App\Http\Controllers\AuditEpacketController;
use App\Http\Controllers\InitiallizeLabelHistoryController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::controller(AuthController::class)->group(function () {
    Route::get('/login', 'displayLogin')->name('login.show');
    Route::post('/login', 'handleLogin')->name('login.handle');

    Route::post('/register', 'handleRegister');

    Route::get('/accuracy', 'displayAccuracy')->name('accuracy.show');
    Route::post('/accuracy', 'handleAccuracy')->name('accuracy.handle');

    Route::get('/forgot-password', 'displayForgotPassword')->name('forgot.show');
    Route::post('/forgot-password', 'handleForgotPassword')->name('forgot.handle');
    Route::post('/new-password', 'handleNewPassword')->name('new-pass.handle');
});

Route::controller(SepayController::class)->prefix('sepay')->name('sepay.')->group(function () {
    Route::post('/hooks', 'handleSepayWebhook')->name('hooks.handle');
});

Route::controller(WalletController::class)->prefix('recharge')->name('recharge.')->group(function () {
    Route::get('/return-vnpay', 'returnVNPAY')->name('vnpay.return');
});

Route::middleware(['auth.main'])->group(function () {
    Route::controller(SepayController::class)->prefix('sepay')->name('sepay.')->group(function () {
        Route::get('/recharge/{recharge_id}', 'displaySepayRecharge')->name('recharge.show');
        Route::post('/recharge', 'handleSepayRecharge')->name('recharge.handle');
        Route::post('/check-payment', 'checkSepayPayment')->name('check-payment.show');
    });

    Route::controller(LogoServiceController::class)->prefix('logo-service')->name('logo-service.')->group(function () {
        Route::get('/', 'displayLogoService')->name('show');
        Route::post('/pagination', 'getDataLogoService')->name('pagination.show');
        Route::post('/upload', 'handleUploadLogoService')->name('upload-logo.handle');
        Route::post('/delete-logo', 'handleDeleteLogoService')->name('delete-logo.handle');
    });

    Route::get('/logout', [AuthController::class, 'handleLogout'])->name('logout.handle');
    Route::controller(HomeController::class)->group(function () {
        //Hiển thị giao diện trang chủ
        Route::get('/', 'displayHome')->name('dashboard');
        //Lấy dữ liệu giao diện trang chủ
        Route::post('/dashboard', 'getDataDashboard')->name('dashboard.show');


        //Hiển thị giao diện danh sách thông báo
        Route::get('/notifications', 'displayNotifications')->name('notifications.show');
        //Lấy dữ liệu danh sách thông báo
        Route::post('/notifications', 'getNotifications')->name('notifications.pagination.show');
        //Hiển thị giao diện thêm thông báo
        Route::get('/notifications/create', 'displayNotificationsCreate')->name('notifications.create.show');
        //Xử lý dữ liệu thêm thông báo
        Route::post('/notifications/create', 'handleNotificationsCreate')->name('notifications.create.handle');
        //Hiển thị giao diện chi tiết thông báo
        Route::get('/notifications/detail/{notification_id}', 'displayNotificationsDetail')->name('notifications.detail.show');
        //Hiển thị giao diện chỉnh sửa thông báo
        Route::get('/notifications/edit/{notification_id}', 'displayNotificationsEdit')->name('notifications.edit.show');
        //Xử lý dữ liệu chỉnh sửa thông báo
        Route::post('/notifications/edit', 'handleNotificationsEdit')->name('notifications.edit.handle');
        //Xử lý xóa thông báo
        Route::post('/notifications/delete', 'handleNotificationsDelete')->name('notifications.delete.handle');
    });

    Route::controller(OrderPickupController::class)->prefix('order-pickup')->name('pickup.')->group(function () {
        // Hiển thị giao diện order pickup
        Route::get('/', 'displayIndex')->name('show');
        //Lấy dữ liệu order pickup
        Route::post('/pagination', 'getOrderPickup')->name('pagination.show');
        //Cập nhật dữ liệu order pickup
        Route::post('/update', 'handleUpdateOrderPickup')->name('update.handle');
        // Cập nhật trạng thái order pickup
        Route::post('/update-status', 'handleUpdateStatusOrderPickup')->name('update-status.handle');
        //Lấy thông tin chi tiết order pickup
        Route::post('/detail', 'getDetailOrderPickup')->name('detail.show');
        //Xóa order pickup
        Route::post('/delete', 'handleDeleteOrderPickup')->name('delete.handle');
        //In pickup
        Route::get('/inpickup/{order_pickup_code}', 'displayDetailOrderPickup')->name('inpickup.show');

        // Danh sách shipper đang rảnh
        Route::post('/shipper-free', 'showListShipperFree')->name('shipper-free.handle');
        // chỉ định shipper lấy hàng
        Route::post('/shipper-take', 'handleshipperTakePackage')->name('shipper-take.handle');
        // Xóa shipper trả về chờ xác nhận
        Route::post('/shipper-cancel', 'onCancelShipper')->name('shipper-cancel.handle');
    });

    Route::controller(ShipmentController::class)->prefix('shipments')->name('shipments.')->group(function () {
        // Hiển thị giao diện Package Manager
        Route::get('/', 'displayShipmentsList')->name('list.show');
        // Lấy danh sách shipment
        Route::post('/pagination', 'getShipments')->name('list.pagination.show');
        // Lấy danh sách shipment
        Route::post('/upload-label', 'onUploadLabel')->name('upload-label');
        // Hiển thị giao diện in bill
        Route::get('print/bill/{shipment_code}', 'displayShipmentsPrintBill')->name('print.bill.show');
        // Hiển thị giao diện in bill
        Route::get('print/label/{shipment_code}', 'displayShipmentsPrintLabel')->name('print.label.show');
        // Hiển thị giao diện in bill 2
        Route::get('print/label-v2/{shipment_code}', 'displayShipmentsPrintLabelV2')->name('print.label-v2.show');
        // Hiển thị giao diện in bill 2f
        Route::get('print/label-v2-f/{shipment_code}', 'displayShipmentsPrintLabelV2F')->name('print.label-v2-f.show');
        // Hiển thị giao diện in bill 2f đã nhập đầy đủ thông tin
        Route::post('print/label-v2-changed', 'displayShipmentsPrintLabelV2Changed')->name('print.label-v2-changed.show');
        // Hiển thị giao diện in invoice
        Route::get('print/invoice/{shipment_code}', 'displayShipmentsPrintInvoice')->name('print.invoice.show');
        // Hiển thị giao diện tạo shipment
        Route::get('/create', 'displayShipmentCreate')->name('create.show');
        // Xử lý tạo shipment
        Route::post('/create', 'handleShipmentCreate')->name('create.handle');
        // Hiển thị giao diện chi tiết shipment
        Route::get('/detail/{shipment_code}', 'displayShipmentDetail')->name('detail.show');
        // Hiển thị chi tiết package
        Route::post('/detail/package', 'getDetailPackage')->name('detail.package');
        // Cập nhật lại phương thức thanh toán
        Route::post('/detail/reload-paid-by', 'onChangePaymentMethod')->name('detail.reload-paid-by');
        // Hiển thị danh sách các package
        Route::post('/list/package', 'showListPackages')->name('list.package');
        // Cập nhật chi phí phụ thu của package
        Route::post('/update/package-sg', 'updatePackageSurchageGoods')->name('update.packageSg');
        // Hiển thị giao diện cập nhật chi phí vận hành công ty
        Route::post('/detail/shipment-operating-costs', 'getShipmentDetailOperatingCosts')->name('detail.shipment-operating-costs.show');
        // Xử lý cập nhật chi phí vận hành công ty
        Route::post('/detail/save-shipment-operating-costs', 'handleShipmentDetailOperatingCosts')->name('detail.shipment-operating-costs.handle');
        // Xử lý xóa shipment
        Route::post('/delete', 'handleShipmentDelete')->name('delete.handle');
        // Hiển thị giao diện chỉnh sửa shipment
        Route::get('/edit/{shipment_code}', 'displayShipmentEdit')->name('edit.show');
        // Xử lý chỉnh sửa shipment
        Route::post('/edit', 'handleShipmentEdit')->name('edit.handle');

        // Xử lý cập nhật label
        Route::post('/update-label', 'handleLabelEdit')->name('label.handle');
        // Xử lý tạo lại label
        Route::post('/create-label-reload', 'onCreateLabelReload')->name('label.reload');
        // Xử lý cập nhật method
        Route::post('/update-method', 'handleMethodEdit')->name('method.handle');
        // Xử lý cập nhật freight
        Route::post('/update-freight', 'handleAmountFreight')->name('freight.handle');

        // Hiển thị giao diện location
        Route::get('/location/{code}', 'displayLocation')->name('location.show');

        // Hiển thị giao diện chuyển trạng thái shipment hold
        Route::post('/check-hold-shipment', 'handleCheckHoldShipment')->name('check-hold-shipment.handle');
    
        // Thanh toán shipment
        Route::post('/payment', 'handlePaymentShipment')->name('payment.handle');

        //Hiển thị giao diện duyệt shipment khi bulk-upload
        Route::get('/approve', 'displayApproveShipment')->name('approve.show');
        //Lấy dữ liệu duyệt shipment khi bulk-upload
        Route::post('/approve/pagination', 'getApproveShipments')->name('approve.pagination.show');
        //Xử lý duyệt shipment khi bulk-upload
        Route::post('/approve/confirm', 'handleConfirmApproveShipment')->name('approve.confirm.handle');
        //Xử lý xóa shipment khi bulk-upload
        Route::post('/approve/delete', 'handleDeleteApproveShipment')->name('approve.delete.handle');
    });

    Route::controller(AuditEpacketController::class)->prefix('audit-epacket')->name('audit-epacket.')->group(function () {
        // Danh sách dịch vụ Epackage
        Route::get('/epackage-services', 'getEPackageServices')->name('epackage-services');
        // Danh sách dịch vụ PackageManager
        Route::get('/package-manager-services', 'getPackageManagerServices')->name('package-manager-services');
        // Danh sách trạng thái
        Route::get('/shipment-statuses', 'getShipmentStatuses')->name('shipment-statuses');
        // Hiển thị giao diện Audit Epackage
        Route::get('/', 'displayAuditEpacketList')->name('list.show');
        // Lấy danh sách shipment
        Route::post('/pagination', 'getShipments')->name('list.pagination.show');
        // Cập nhật ghi chú
        Route::post('/update-note', 'handleUpdateNote')->name('update-note.handle');
    });

    Route::controller(BulkUploadController::class)->prefix('bulk-upload')->name('bulk.')->group(function () {
        Route::get('/', 'displayBulkUpload')->name('show'); // Đường dẫn đến giao diện chính bulk-upload
        Route::post('/handle', 'handleBulkUpload')->name('handle'); // 
    });

    Route::controller(InitiallizeLabelHistoryController::class)->prefix('initiallize-label-history')->name('initiallize-label-history.')->group(function () {
        Route::get('/', 'displayInitiallizeLabelHistories')->name('show'); // Đường dẫn đến giao diện chính
        Route::post('/pagination', 'getInitiallizeLabelHistories')->name('show.pagination');
        Route::post('/delete', 'handleDeleteInitiallizeLabelHistory')->name('delete.handle');
    });

    Route::name('supports.')->group(function () {
        Route::controller(TicketController::class)->prefix('tickets')->name('tickets.')->group(function () {
            Route::post('/me', 'getTicketsByUser')->name('me.show');
            Route::post('/add', 'handleAddTicket')->name('add.handle');
            Route::post('/detail', 'getDetailTicket')->name('detail.show');
            Route::post('/add-message', 'handleAddTicketMessage')->name('add-message.handle');
            Route::get('/', 'displayTickets')->name('show');
            Route::post('/list', 'getTicketsList')->name('list.show');
            Route::post('/single-chat', 'showSingleChatTicket')->name('single-chat.show');
            Route::post('/update-status', 'handleUpdateTicketStatus')->name('update-status.handle');
            Route::post('/update-note', 'handleUpdateTicketNote')->name('update-note.handle');
        });
    });

    Route::controller(MawbManagerController::class)->prefix('mawb-manager')->name('mawb.')->group(function () {
        Route::get('/', 'displayIndex')->name('show'); // Đường dẫn đến giao diện chính mawb-manager
        Route::get('/export-excel-rp/{sm_tracktry_id}', 'exportRpPackage')->name('export.excel-rp');
        Route::get('/export-excel-pkg/{sm_tracktry_id}', 'exportPkgPackage')->name('export.excel-pkg');

        Route::post('/update-tracking-hawb-by-mawb', 'onUpdateStatusPackageByStatusTraking')->name('update-tracking.hawb-by-mawb'); // Thêm status tracking cho mawb
        Route::post('/search-hawb', 'onShowHawb')->name('search-hawb'); // Thêm status tracking cho mawb
        Route::get('/add-tracking/{awb_code}', 'addTracking')->name('add-tracking'); // Đường dẫn khi nhấn vô btn icon add tracking đến giao diện thêm mawb-manager
        Route::get('/print-bagcode/{item_code}', 'printPackageBagCode')->name('print-bagcode'); // Đường dẫn khi nhấn vô btn icon add tracking đến giao diện thêm mawb-manager
        Route::post('/add-tracking/paginate', 'showListTrackingStatus')->name('add-tracking.paginate'); // Thêm status tracking cho mawb
        Route::post('/add-tracking', 'handleShipmentStatusCreate')->name('add-tracking.handle'); // Thêm status tracking cho mawb
        Route::post('/add-tracking/delete', 'handleShipmentStatusDelete')->name('add-tracking.delete'); // Thêm status tracking cho mawb

        Route::get('/bill-shipment/{awb_code}', 'billShipment')->name('bill-shipment'); // Đường dẫn khi nhấn vô btn icon eye  đến giao diện  bill-shipment
        Route::post('/bill-package/export-excel', 'onExportExcelBillByType')->name('bill-shipment.export'); // Thêm status tracking cho mawb
        Route::get('/bill-package/{package_code}', 'billPackage')->name('bill-package'); // Đường dẫn khi nhấn vô btn icon eye  đến giao diện  bill-shipment


        Route::get('/inlabel/{awb_code}', 'printMawb')->name('print-mawb'); // Đường dẫn khi nhấn vô btn icon eye  đến giao diện  bill-shipment


        Route::post('/list-sm-tracktry', 'showListSmTracktry')->name('list.sm-tracktry'); //
        Route::post('/detail-sm-tracktry', 'showDetailSmTracking')->name('detail.sm-tracktry'); //
        Route::post('/create-sm-tracktry', 'handleCreateSMTracktry')->name('create.sm-tracktry'); //
        Route::post('/update-sm-tracktry', 'handleUpdateSMTracktry')->name('update.sm-tracktry'); //
        Route::post('/hiden-sm-tracktry', 'hidenSMTracktry')->name('hiden.sm-tracktry'); //

        Route::post('/list-package-bill', 'showListPackageMawb')->name('list.package-bill'); //
        Route::post('/update-tracking', 'updatePackagesMawbByTrackTry')->name('update.tracking'); //
        Route::post('/remove-tracking', 'removePackagesMawbByTrackTry')->name('remove.tracking'); //

        Route::post('/package-tracking/update', 'handlePackageTrackingStatus')->name('package-tracking.update'); //
        Route::post('/package-tracking/list', 'listPackageTrackingStatus')->name('package-tracking.list'); //
        Route::post('/package-tracking/delete', 'deletePackageTrackingStatus')->name('package-tracking.delete'); //
        Route::post('/package-tracking/update-tracking-code', 'onUpdatePackageTrackingCode')->name('package-tracking.update-tracking-code'); //
        Route::post('/package-tracking/update-new-tracking', 'onCreateTrackingOnePackage')->name('package-tracking.update-new-tracking'); //

    });

    Route::controller(WisewayController::class)->prefix('wiseway')->name('wiseway.')->group(function () {
        Route::get('/', 'displayIndex')->name('show'); // Đi đến màn hình Create Wise Way
    });

    Route::controller(NzPostController::class)->prefix('labels')->name('nz-post.')->group(function () {
        Route::get('/', 'displayIndex')->name('show'); // Đi đến màn hình Create NZ-Post
        Route::post('/paginate', 'showListLabels')->name('list'); // Đi đến màn hình Create NZ-Post
        Route::post('/', 'handleAddNzPost')->name('handle'); // Khởi tạo label với api của omsapi.worldtech.eu
        Route::post('/auk', 'handleCreateLabelAUK')->name('handle.auk'); // Khởi tạo label với api của auk.global-parcel-hub
        Route::post('/dpd', 'handleCreateLabelDPD')->name('handle.dpd'); // Khởi tạo label với api của auk.global-parcel-hub
        Route::post('/etower', 'handleCreateLabelETOWER')->name('handle.etower'); // Khởi tạo label với api của etower
        Route::post('/top-log-au', 'handleCreateLabelTopLogAu')->name('handle.top-log-au'); // Khởi tạo label với api của top-log-au
        Route::post('/get-top-log-au', 'handleGetLabelTopLogAu')->name('handle.get-top-log-au'); // lấy label với api của get-top-log-au
    });

    Route::controller(CirroAuController::class)->prefix('cirro-au')->name('cirro-au.')->group(function () {
        Route::get('/', 'displayIndex')->name('show'); // Đi đến màn hình Create Cirro-AU
    });

    Route::controller(ApiDocumnetController::class)->prefix('api-documents')->name('api-document.')->group(function () {
        Route::get('/', 'displayIndex')->name('show'); // Đi đến màn hình chính API Document
        Route::post('/paginate', 'showListApi')->name('paginate'); // Đi đến màn hình chính API Document
        Route::get('/create', 'displayCreate')->name('create'); // Đi đến màn hình Create APi khi nhấn vào "Thêm Api"
        Route::get('/update/{slug}', 'displayUpdate')->name('update'); // Đi đến màn hình Update khi nhấn vào btn Pen trên mỗi item
        Route::post('/handle', 'handleCreateOrUpdate')->name('handle'); // Đi đến màn hình Create APi khi nhấn vào "Thêm Api"
        Route::get('/detail/{slug}', 'displayDetail')->name('detail'); // Đi đến màn hình Chi tiết khi nhấn vào Tên Api trên mỗi item
        Route::post('/delete', 'deleteApiDocument')->name('delete'); // Đi đến màn hình Chi tiết khi nhấn vào Tên Api trên mỗi item
    });

    Route::controller(SmsManagerController::class)->prefix('sms-manager')->name('sms-manager.')->group(function () {
        Route::get('/', 'displayIndex')->name('show');  // Đi đến màn hình chính SMS Kiki Manager
        Route::get('/send', 'displaySend')->name('send-sms'); // Đi đến màn hình gửi em khi nhấn vào "Gửi tin nhắn CSKH"

        // Test gửi tin nhắn ngày lễ
        Route::post('/send-sms-holiday-test', 'handleSendSmsHolidayTest')->name('send-sms-holiday-test.handle');
        // Gửi tin nhắn ngày lễ
        Route::post('/send-sms-holiday', 'handleSendSmsHoliday')->name('send-sms-holiday.handle');
        // Lấy danh sách user gửi sms ngày lễ
        Route::post('/get-users-send-sms-holiday', 'getUsersSendSmsHoliday')->name('get-users-send-sms-holiday.show');
        // CHọn tất cả user gửi sms ngày lễ
        Route::post('/checked-all-users-send-sms-holiday', 'checkedAllUsersSendSmsHoliday')->name('checked-all-users-send-sms-holiday.show');

        Route::post('/history-sms', 'showHistorySms')->name('history-sms'); // danh sách lịch sử sms
    });

    Route::controller(ScanController::class)->group(function () {

        Route::prefix('scan')->name('scan.')->group(function () {
            Route::get('/import', 'displayImport')->name('import');  // Đi đến màn hình  Scan nhập hàng
            Route::get('/import/{hawb_code}', 'displayImportHawbCode')->name('import.hawb');  // Đi đến màn hình  Scan nhập hàng

            Route::get('/bag-code', 'displayScanBagCode')->name('bag-code');  // Đi đến màn hình  Scan bag code
            Route::post('/bag-code/check', 'checkBarCode')->name('bag-code.check');

            Route::get('/export', 'displayExport')->name('export');  // Đi đến màn hình  Scan xuất hàng
            Route::post('/export/modal', 'showDetailPackage')->name('export.modal');

            Route::get('/return', 'displayReturn')->name('return');  // Đi đến màn hình  Scan trả hàng
            Route::get('/confirm-bill', 'displayConfirmBill')->name('confirm'); // Đi đến màn hình  Scan chốt bill
            Route::get('/document', 'displayDocument')->name('document');  // Đi đến màn hình  Scan for document

            Route::get('/transit-hn', 'displayTransitHN')->name('transit-hn');  // Đi đến màn hình  Scan transit HN


            Route::post('/update-status', 'handleCreateHistory')->name('update-status');  // scan cập nhật trạng thái
            Route::post('/list/surchage-goods', 'showSurchageGoods')->name('list.surchage-goods');
        });
        Route::prefix('list')->name('list.')->group(function () {
            Route::get('/scan-import', 'displayListScan')->name('scan');  // Đi đến màn hình  List scan nhập hàng
            Route::get('/expire48', 'displayExpire24h')->name('expire24');  // Đi đến màn hình  List hàng quá 48h

            Route::get('/bag-code', 'displayBagCode')->name('bag-code');  // Đi đến màn hình  List Bag code
            Route::get('/bag-code-uk', 'displayBagCodeUK')->name('code-uk'); // Đi đến màn hình  List Bag code uk
            Route::post('/bag-code/create', 'handleCreateBagCode')->name('bag-code.create');  // tạo bag code
            Route::post('/bag-code', 'showListBags')->name('bag-code.list');  // danh sách bag code
            Route::get('/bag-code/print/{bag_code_id}', 'onPrintBagCode')->name('bag-code.print');  // print

            Route::post('/scan-table', 'showListHistoryScan')->name('scan.show');  // lịch sử scan
            Route::post('/cancel-status', 'handleCancelStatus')->name('cancel.status');  // hủy bỏ trạng thái đưa về create
        });
    });

    Route::controller(ListController::class)->prefix('list')->name('list.')->group(function () {});

    Route::controller(DebitController::class)->prefix('debit')->name('debit.')->group(function () {
        Route::post('/verify', 'verifyToShowDebit')->name('verify');
        Route::get('/manager', 'displayDebitFwd')->name('index.fwd');  // Màn hình debit tài khoản fwd 
        Route::post('/fwd-paginate', 'showDebitsFwd')->name('paginate.fwd');  // Màn hình debit tài khoản fwd 


        Route::get('/list', 'displayListDebit')->name('list.index');  // Đi đến màn hình  
        Route::get('/detail/{debit_code}', 'displayDebitDetail')->name('detail');  // Đi đến màn hình  
        Route::get('/customer-detail/{user_code}', 'displayCustomerDetail')->name('customer');  // Đi đến màn hình  
        Route::get('/edit-subpackage', 'displaySubPackage')->name('subpackage');  // Đi đến màn hình  
        Route::get('/list-import', 'displayListImport')->name('list.import');  // Đi đến màn hình  

        // Danh sách debits
        Route::post('/list', 'showListDebit')->name('list.show');
        Route::post('/payment', 'paymentDebit')->name('payment');
        Route::post('/payment-fwd', 'sendPaymentDebitFwd')->name('payment-fwd');
        Route::post('/advance-fwd', 'advanceDebit')->name('advance-fwd');

        Route::post('/detail-shipment', 'showListShipmentDebit')->name('detail.shipment.show');
        // xác nhận duyệt các đơn shipment trong debit
        Route::post('/accountant-confirm', 'onAcountantConfimInDebit')->name('accountant-confirm');

        
        // của fwd 
        Route::prefix('/fwd')->name('fwd.')->group(function () {
            Route::get('/list', 'displayListDebitFwd')->name('list.index');  // Đi đến màn hình  Quản lý 
            Route::get('/detail', 'displayDebitDetailFwd')->name('list.detail');  // Đi đến màn hình  chi tiết khi nhấn vào 

            Route::get('/detail-sm-fwd', 'displayDetailCompany')->name('detail.sm-fwd');
            Route::post('/detail-sm-fwd', 'paginateListShipmentFwd')->name('detail.sm-fwd.paginate');

            Route::get('/list-sm-fwd', 'displayListShipmentFwd')->name('list.sm-fwd');  // Đi đến màn hình  Quản lý 
            Route::post('/shipment-fwd', 'showListShipmentFwd')->name('shipment-fwd');

            Route::get('/imported-goods', 'displayImportedGoods')->name('imported-goods'); // Màn hình danh sách hàng nhập
            Route::post('/imported-goods', 'showImportedGoods')->name('imported-goods.index');  // Đổ data danh sách hàng nhập
            Route::get('/imported-goods/detail/{package_code}', 'displayImportedGoodsDetail')->name('imported-goods.detail'); // Chi tiết hàng nhập
            Route::post('/imported-goods/detail/update-internal-surcharge/{package_code}', 'updateInternalSurcharge')->name('imported-goods.detail.update-internal-surcharge'); // Cập nhật phụ thu TRONG hệ thống
            Route::post('/imported-goods/detail/update-external-surcharge/{package_code}', 'updateExternalSurcharge')->name('imported-goods.detail.update-external-surcharge'); // Cập nhật phụ thu NGOÀI hệ thống

            Route::post('/create-debit', 'createDebitFwd')->name('debit.create');
            Route::post('/create-debit2', 'createDebitFwd2')->name('debit.create2');
            Route::post('/cancel-debit', 'onCancelDebit')->name('debit.cancel');

            Route::post('/export-shipment', 'onExportShipmentByDebit')->name('export.shipment');
            Route::get('/export-bill-debit', 'exportBillDebit')->name('export.bill.debit');
        });
    });

    Route::controller(AccountantController::class)->prefix('accountant')->name('accountant.')->group(function () {
        Route::get('/expense', 'displayExpense')->name('expense.display');  // Đi đến màn hình  Q
        // Route::get('/detail', 'displayCreditDetail')->name('list.detail');  // Đi đến màn hình  chi tiết
        Route::get('/wallet-fluctuations', 'displayWalletFluctuation')->name('wallet-fluctuations.display');
        Route::post('/wallet-fluctuations/paginate', 'showListWalletFluctuation')->name('wallet-fluctuations.paginate');

        Route::get('/shipments-pending', 'displayShipmentPendding')->name('shipment.display');  // 
        Route::post('/shipment-paginate', 'showListShipment')->name('shipment-paginate');  // 
        Route::post('/shipment-acction', 'handleShipmentAction')->name('shipment.action');  // 

        Route::get('/financial', 'displayFinancial')->name('financial.show');  // Màn hình quan lý chi tiêu
        Route::post('/financial-handle', 'handleCreateOrUpdateFinancial')->name('financial.handle');  // Tạo/cập nhật chi tiêu
        Route::post('/financial-detail', 'showDetailFinancial')->name('financial.detail');  // Xóa chi tiêu
        Route::post('/financial-delete', 'onDeleteFinancial')->name('financial.delete');  // Xóa chi tiêu
        Route::post('/financial-paginate', 'showListFinancial')->name('financial.paginate');  // Danh sách quản lý chi tiêu


    });

    Route::controller(CreditController::class)->prefix('credit')->name('credit.')->group(function () {
        Route::get('/', 'indexCredit')->name('index.show');  // Đi đến màn hình  Quản lý Credit
        Route::post('/', 'onShowListCredit')->name('index.paginate');  // 
        Route::post('/create', 'handleCreateCredit')->name('create');  // 
        Route::post('/cancel', 'onCancelCredit')->name('cancel');  // 

        Route::get('/detail/{credit_no}', 'displayCreditDetail')->name('detail.show');
        Route::get('/detail/excel', 'displayExcel')->name('detail.excel');
        Route::post('/detail/paginate', 'showListPackageInCredit')->name('detail.paginate');  // 
        Route::get('/detail/excel/packages-export', 'showListPackageInCredit')->name('detail.packages-export');  // 
        Route::post('/detail/add-package', 'handleAddPackageInCredit')->name('detail.add-package');  // 
        Route::post('/detail/remove-package', 'onRemovePackageInCredit')->name('detail.remove-package');  // 
        Route::post('/detail/value-package', 'onUpdateValuePackage')->name('detail.value-package');  // 
        Route::post('/detail/payment', 'onPaymentCredit')->name('detail.payment');  // 

    });

    Route::controller(StatementController::class)->prefix('statement')->name('statement.')->group(function () {
        Route::get('/', 'displayIndex')->name('display');
        Route::post('/paginate', 'showListStatement')->name('paginate');
        Route::post('/create', 'handleCreateStatement')->name('create');
        Route::post('/cancel', 'handleCancelStatement')->name('cancel');
        Route::post('/payment', 'onPaymentStatement')->name('payment');
        Route::get('/detail', 'displayStatementDetail')->name('detail.display');
        Route::get('/export-bill', 'exportBillStateMent')->name('detail.export');

    });

    Route::controller(AuthController::class)->prefix('profile')->name('profile.')->group(function () {
        Route::get('/{tab?}', 'displayProfile')->name('show');  // Đi đến màn hình  profile 
        Route::post('/info', 'getInfo')->name('info');  // Lấy thông tin user
        Route::post('/edit', 'handleEdit')->name('edit');  // Cập nhật thông tin user
        Route::post('/update-password', 'handleNewPassword')->name('new-password');  // Cập nhật lại mật khẩu user
        Route::post('/update-user-accountant-key', 'handleUpdateUserAccountantKey')->name('new-accountant-key');  // Cập nhật lại mã kế toán
    });

    Route::controller(WalletController::class)->group(function () {
        Route::prefix('wallet')->name('wallet.')->group(function () {
            Route::post('/user', 'getWalletByUser')->name('user');
            Route::post('/vnpay', 'getVNPAY')->name('user');
            Route::post('/fluctuation', 'showListWalletFlut')->name('fluctuation.show');
        });

        Route::prefix('recharge')->name('recharge.')->group(function () {
            Route::get('/', 'displayAllRecharge')->name('show'); // Lấy danh sách thông tin yêu cầu nạp của 1 ng
            Route::post('/list', 'showListRecharge')->name('list'); // Lấy danh sách thông tin yêu cầu nạp của 1 ng
            Route::post('/create', 'handleRecharge')->name('create'); // Tạo yêu cầu nạp

            Route::post('/detail', 'handleShowDetailRecharge')->name('detail');
            Route::post('/detail/user', 'handleShowDetailRecharge')->name('detail.user');

            Route::post('/detail/fail', 'onFailRecharge')->name('detail.fail');
            Route::post('/detail/success', 'onSuccessRecharge')->name('detail.success');

            Route::post('/statistical', 'getStatistical')->name('statistical');

            Route::post('/vnpay', 'handleVNPAY')->name('vnpay.handle');


            Route::get('/setting', 'showRechargeSetting')->name('setting.show');
            Route::post('/setting', 'handleRechargeSetting')->name('setting.handle');
        });
    });

    Route::name('manages.')->prefix('/manages')->controller(ManageController::class)->group(function () {
        Route::name('admin.')->prefix('/admin')->group(function () {
            Route::name('system.')->prefix('/system')->group(function () {
                // Hiển thị trang quản lý hệ thống
                Route::get('', 'displayManageAdminSystem')->name('show');

                //Hiển thị giao diện trang loại tài khoản
                Route::post('/positions/display', 'displayManageAdminSystemPositions')->name('positions.show');
                //Lấy dữ liệu chức vụ nhân viên
                Route::post('/positions/display/pagination', 'getDataPositions')->name('positions.pagination.show');
                //Lấy dữ liệu chi tiết của một chức vụ nhân viên
                Route::post('/positions/detail', 'getDataPosition')->name('positions.detail.show');
                //Xử lý dữ liệu chức vụ nhân viên
                Route::post('/positions/update', 'updateDataPosition')->name('positions.update.handle');
                //Xoá dữ liệu chức vụ nhân viên và chặn tất cả tài khoản mang chức vụ này
                Route::post('/positions/delete', 'deleteDataPosition')->name('positions.delete.handle');

                //Hiển thị giao diện trang chi nhánh công ty
                Route::post('/branchs/display', 'displayManageAdminSystemBranchs')->name('branchs.show');
                //Lấy dữ liệu chi nhánh công ty
                Route::post('/branchs/display/pagination', 'getDataBranchs')->name('branchs.pagination.show');
                //Lấy dữ liệu chi tiết của một chi nhánh công ty
                Route::post('/branchs/detail', 'getDataBranch')->name('branchs.detail.show');
                //Xử lý dữ liệu chi nhánh công ty
                Route::post('/branchs/update', 'updateDataBranch')->name('branchs.update.handle');
                //Xoá dữ liệu chi nhánh công ty và chặn tất cả tài khoản mang chức vụ này
                Route::post('/branchs/delete', 'deleteDataBranch')->name('branchs.delete.handle');

                //Hiển thị giao diện trang danh sách account công ty
                Route::post('/users/display', 'displayManageAdminSystemUsers')->name('users.show');
                //Lấy dữ liệu danh sách tài khoản công ty
                Route::post('/users/display/pagination', 'getDataUsers')->name('users.pagination.show');
                //Hiển thị danh giao diện thêm account công ty
                Route::post('/users/create/display', 'displayManageAdminSystemUsersCreate')->name('users.create.show');
                //Xử lý dữ liệu thêm account công ty
                Route::post('/users/create/handle', 'handleManageAdminSystemUsersCreate')->name('users.create.handle');
                //Hiển thị giao diện chỉnh sửa account công ty
                Route::post('/users/edit/display', 'displayManageAdminSystemUsersEdit')->name('users.edit.show');
                //Xử lý dữ liệu chỉnh sửa account công ty
                Route::post('/users/edit/handle', 'handleManageAdminSystemUsersEdit')->name('users.edit.handle');
                //Xử lý trạng thái account công ty
                Route::post('/users/lock', 'handleManageAdminSystemUsersLock')->name('users.lock.handle');
                //Xử lý trạng thái export công ty
                Route::post('/users/lock-export', 'handleManageAdminSystemUsersLockExport')->name('users.lock-export.handle');
                //Xoá dữ liệu account
                Route::post('/users/delete', 'handleManageAdminSystemUsersDelete')->name('users.delete.handle');

                // làm mới ví
                Route::post('/refresh-wallet', 'onRefreshWallet')->name('refresh-wallet');
                // Trừ tiền trong ví
                Route::post('/deduct-wallet', 'onDeductWallet')->name('deduct-wallet');
                // Reset công nợ
                Route::post('/refresh-debit', 'onResetDebit')->name('refresh-debit');
                // Trừ công nợ
                Route::post('/deduct-debit', 'onDeductDebit')->name('deduct-debit');

                //Hiển thị giao diện danh sách hàng hóa phụ thu
                Route::post('/surcharge-goods/display', 'displayManageAdminSystemSurchargeGoods')->name('surcharge-goods.show');
                //Lấy dữ liệu hàng hóa phụ thu
                Route::post('/surcharge-goods/display/pagination', 'getDataSurchargeGoodsList')->name('surcharge-goods.pagination.show');
                //Lấy dữ liệu chi tiết của một hàng hóa phụ thu
                Route::post('/surcharge-goods/detail', 'getDataSurchargeGoods')->name('surcharge-goods.detail.show');
                //Xử lý dữ liệu hàng hóa phụ thu
                Route::post('/surcharge-goods/update', 'updateDataSurchargeGoods')->name('surcharge-goods.update.handle');
                //Xoá dữ liệu hàng hóa phụ thu
                Route::post('/surcharge-goods/delete', 'deleteDataSurchargeGoods')->name('surcharge-goods.delete.handle');

                //Hiển thị giao diện danh sách quốc gia
                Route::post('/countries/display', 'displayManageAdminSystemCountries')->name('countries.show');
                //Lấy dữ liệu quốc gia
                Route::post('/countries/display/pagination', 'getDataCountries')->name('countries.pagination.show');
                //Lấy dữ liệu chi tiết của một quốc gia
                Route::post('/countries/detail', 'getDataCountry')->name('countries.detail.show');
                //Xử lý dữ liệu quốc gia
                Route::post('/countries/update', 'updateDataCountry')->name('countries.update.handle');
                //Xoá dữ liệu quốc gia
                Route::post('/countries/delete', 'deleteDataCountry')->name('countries.delete.handle');

                //Hiển thị giao diện danh sách dịch vụ
                Route::post('/services/display', 'displayManageAdminSystemServices')->name('services.show');
                //Lấy dữ liệu dịch vụ
                Route::post('/services/display/pagination', 'getDataServices')->name('services.pagination.show');
                //Lấy dữ liệu chi tiết của một dịch vụ
                Route::post('/services/detail', 'getDataService')->name('services.detail.show');
                //Xử lý dữ liệu dịch vụ
                Route::post('/services/update', 'updateDataService')->name('services.update.handle');
                //Xoá dữ liệu dịch vụ
                Route::post('/services/delete', 'deleteDataService')->name('services.delete.handle');

                Route::name('service-surcharge-fee.')->prefix('/service-surcharge-fee')->group(function () {
                    //Hiển thị giao diện danh sách phụ thu dịch vụ
                    Route::post('/display', 'displayServiceSurchargeFee')->name('show');
                    //Lấy dữ liệu phụ thu dịch vụ
                    Route::post('/display/pagination', 'getServiceSurchargeFees')->name('pagination.show');
                    //Lấy dữ liệu chi tiết phụ thu của một dịch vụ
                    Route::post('/detail', 'getServiceSurchargeFee')->name('detail.show');
                    //Xử lý dữ liệu phụ thu dịch vụ
                    Route::post('/update', 'handleServiceSurchargeFee')->name('update.handle');
                    //Xoá dữ liệu phụ thu dịch vụ
                    Route::post('/delete', 'deleteServiceSurchargeFee')->name('delete.handle');
                });

                //Hiển thị giao diện danh sách state/province
                Route::post('/states/display', 'displayManageAdminSystemStates')->name('states.show');
                //Lấy dữ liệu state/province
                Route::post('/states/display/pagination', 'getDataStates')->name('states.pagination.show');
                //Lấy dữ liệu chi tiết của một state/province
                Route::post('/states/detail', 'getDataState')->name('states.detail.show');
                //Xử lý dữ liệu state/province
                Route::post('/states/update', 'updateDataState')->name('states.update.handle');
                //Xoá dữ liệu state/province
                Route::post('/states/delete', 'deleteDataState')->name('states.delete.handle');

                //Hiển thị giao diện danh sách liên kết quốc gia - dịch vụ
                Route::post('/countries-services/display', 'displayManageAdminSystemCountriesServicesList')->name('countries-services.show');
                //Lấy dữ liệu liên kết quốc gia - dịch vụ
                Route::post('/countries-services/display/pagination', 'getDataCountriesServices')->name('countries-services.pagination.show');
                //Lấy dữ liệu chi tiết của một liên kết quốc gia - dịch vụ
                Route::post('/countries-services/detail', 'getDataCountryService')->name('countries-services.detail.show');
                //Xử lý dữ liệu liên kết quốc gia - dịch vụ
                Route::post('/countries-services/update', 'updateDataCountryService')->name('countries-services.update.handle');
                //Xoá dữ liệu liên kết quốc gia - dịch vụ
                Route::post('/countries-services/delete', 'deleteDataCountryService')->name('countries-services.delete.handle');

                //Hiển thị giao diện danh sách thêm thành phố vào hệ thống
                Route::post('/cities/display', 'displayManageAdminSystemCities')->name('cities.show');
                //Lấy dữ liệu thêm thành phố vào hệ thống
                Route::post('/cities/display/pagination', 'getDataCities')->name('cities.pagination.show');
                //Lấy dữ liệu chi tiết của một thêm thành phố vào hệ thống
                Route::post('/cities/detail', 'getDataCity')->name('cities.detail.show');
                //Xử lý dữ liệu thêm thành phố vào hệ thống
                Route::post('/cities/update', 'updateDataCity')->name('cities.update.handle');
                //Xoá dữ liệu thêm thành phố vào hệ thống
                Route::post('/cities/delete', 'deleteDataCity')->name('cities.delete.handle');

                //Hiển thị giao diện danh sách dịch vụ khuyến mãi
                Route::post('/promotion-services/display', 'displayManageAdminSystemPromotionServices')->name('promotion-services.show');
                //Lấy dữ liệu thêm dịch vụ khuyến mãi
                Route::post('/promotion-services/display/pagination', 'getDataPromotionServices')->name('promotion-services.pagination.show');
                //Xử lý dữ liệu dịch vụ khuyến mãi
                Route::post('/promotion-services/update', 'updateDataPromotionService')->name('promotion-services.update.handle');
                //Xoá dữ liệu dịch vụ khuyến mãi
                Route::post('/promotion-services/delete', 'deleteDataPromotionService')->name('promotion-services.delete.handle');

                //Hiển thị giao diện danh sách chỉnh sửa hệ thống
                Route::post('/settings/display', 'displayManageAdminSystemSettings')->name('settings.show');
                //Xử lý dữ liệu chỉnh sửa hệ thống
                Route::post('/settings/update', 'updateDataSettings')->name('settings.update.handle');
                //Hiển thị giao diện chỉnh sửa thông tin debit
                Route::post('/info-debit/display', 'displayManageAdminSystemInfoDebit')->name('info-debit.show');
                //Cập nhật thông tin debit
                Route::post('/info-debit/handle', 'handleManageAdminSystemInfoDebit')->name('info-debit.handle');
                //Hiển thị giao diện danh sách chỉnh sửa hệ thống sidebar
                Route::post('/menu-settings/display', 'displayManageAdminSystemMenuSettings')->name('menu-settings.show');
                //Cập nhật giao diện danh sách chỉnh sửa hệ thống sidebar
                Route::post('/menu-settings/handle', 'handleManageAdminSystemMenuSettings')->name('menu-settings.handle');
                //Hiển thị giao diện danh sách chỉnh sửa hệ thống sale
                Route::post('/menu-sale/display', 'displayManageAdminSystemMenuSale')->name('menu-sale.show');
                //Cập nhật giao diện danh sách chỉnh sửa hệ thống sale
                Route::post('/menu-sale/handle', 'handleManageAdminSystemMenuSale')->name('menu-sale.handle');

                //Hiển thị giao diện danh sách discount tài khoản
                Route::post('/discount-users/display', 'displayManageAdminSystemDiscountUsers')->name('discount-users.show');
                //Lấy dữ liệu thêm discount tài khoản
                Route::post('/discount-users/display/pagination', 'getDataDiscountUsers')->name('discount-users.pagination.show');
                //Lấy dữ liệu chi tiết của một discount tài khoản
                Route::post('/discount-users/detail', 'getDataDiscountUser')->name('discount-users.detail.show');
                //Xử lý dữ liệu chỉnh sửa discount tài khoản
                Route::post('/discount-users/update', 'updateDataDiscountUser')->name('discount-users.update.handle');
                //Xoá dữ liệu discount tài khoản
                Route::post('/discount-users/delete', 'deleteDataDiscountUser')->name('discount-users.delete.handle');

                // Hiển thị áp giá origin của shipment
                Route::post('/set-amount-origin-shipment/display', 'displayManageAmountOriginShipment')->name('amount-origin-shipment.show');
                Route::post('/set-amount-origin-shipment/display/pagination', 'paginateManageAmountOriginShipment')->name('amount-origin-shipment.paginate');
                Route::post('/set-amount-origin-shipment/handle', 'handleManageAmountOriginShipment')->name('amount-origin-shipment.handle');
                Route::post('/set-amount-origin-shipment/delete', 'deleteManageAmountOriginShipment')->name('amount-origin-shipment.delete');


                //Hiển thị giao diện trang danh sách account FWD
                Route::post('/fwd-users/display', 'displayManageAdminSystemFWDUsers')->name('fwd-users.show');
                //Lấy dữ liệu danh sách account FWD
                Route::post('/fwd-users/display/pagination', 'getDataFWDUsers')->name('fwd-users.pagination.show');
                //Hiển thị danh giao diện thêm account FWD
                Route::post('/fwd-users/create/display', 'displayManageAdminSystemFWDUsersCreate')->name('fwd-users.create.show');
                //Xử lý dữ liệu thêm account FWD
                Route::post('/fwd-users/create/handle', 'handleManageAdminSystemFWDUsersCreate')->name('fwd-users.create.handle');
                //Hiển thị giao diện chỉnh sửa account FWD
                Route::post('/fwd-users/edit/display', 'displayManageAdminSystemFWDUsersEdit')->name('fwd-users.edit.show');
                //Xử lý dữ liệu chỉnh sửa account FWD
                Route::post('/fwd-users/edit/handle', 'handleManageAdminSystemFWDUsersEdit')->name('fwd-users.edit.handle');
                //Xử lý trạng thái account FWD
                Route::post('/fwd-users/lock', 'handleManageAdminSystemFWDUsersLock')->name('fwd-users.lock.handle');

                //Hiển thị giao diện cài đặt bảng giá
                Route::post('/price-list/settings/display', 'displayManageAdminSystemPriceListSettings')->name('price-list.settings.show');
                //Lấy dữ liệu danh sách cài đặt bảng giá
                Route::post('/price-list/settings/display/pagination', 'getDataPriceListSettings')->name('price-list.settings.pagination.show');
                //Hiển thị danh giao diện thêm cài đặt bảng giá
                Route::post('/price-list/settings/create/display', 'displayManageAdminSystemPriceListSettingsCreate')->name('price-list.settings.create.show');
                //Lấy dữ liệu khi chọn loại bảng giá dịch vụ
                Route::post('/price-list/settings/item-child-price-list/sub-child-price-list-type', 'getDataManageAdminSystemPriceListSettingsSubChildPriceListType')->name('price-list.settings.sub-child-price-list-type.show');
                //Xử lý cài đặt bảng giá
                Route::post('/price-list/settings/create/handle', 'handleManageAdminSystemPriceListSettingsCreate')->name('price-list.settings.create.handle');
                //Hiển thị danh giao diện thêm cài đặt bảng giá
                Route::post('/price-list/settings/create/item-child-price-list/display', 'displayManageAdminSystemPriceListSettingsCreateItemChildPriceList')->name('price-list.settings.create.item-child-price-list.show');
                //Hiển thị danh giao diện chỉnh sửa bảng giá
                Route::post('/price-list/settings/edit/display', 'displayManageAdminSystemPriceListSettingsEdit')->name('price-list.settings.edit.show');
                //Xử lý chỉnh sửa thông tin bảng giá
                Route::post('/price-list/edit/handle', 'handleManageAdminSystemPriceListEdit')->name('price-list.edit.handle');
                //Xử lý xóa bảng giá
                Route::post('/price-list/settings/delete/handle', 'handleManageAdminSystemPriceListSettingsDelete')->name('price-list.settings.delete.handle');
                //Hiển thị danh giao diện chỉnh sửa bảng giá
                Route::post('/price-list/settings/edit/item-child-price-list/display', 'displayManageAdminSystemPriceListSettingsEditItemChildPriceList')->name('price-list.settings.edit.item-child-price-list.show');
                //Import excel bảng giá
                Route::post('/price-list/settings/edit/item-child-price-list/excel', 'displayManageAdminSystemPriceListSettingsImportExcelChildPriceList')->name('price-list.settings.import.item-child-price-list.handle');

                Route::prefix('/wait-users')->name('wait-users.')->group(function () { // manages/admin/system/wait-users
                    //Hiển thị danh giao diện danh sách user chờ xét duyệt
                    Route::post('/display', 'displayListWaitUsers')->name('show');
                    Route::post('/display/pagination', 'displayListWaitUsers')->name('pagination.show');
                    Route::post('/delete', 'deleteWaitUser')->name('delete');
                });

                // Hiển thi giao diện báo cáo sale
                Route::prefix('/report-sale')->name('report-sale.')->group(function () { // manages/admin/system/report-sale
                    Route::post('/display', 'displayReportSale')->name('show');
                    Route::post('/display/pagination', 'displayReportSalePaginate')->name('pagination');
                });

                Route::prefix('/payment-cash')->name('payment-cash.')->group(function () { // manages/admin/system/payment-cash
                    Route::post('/display', 'displayManagePayCash')->name('show');
                    Route::post('/display/pagination', 'paginateManagePayCash')->name('pagination');
                    Route::post('/check-all', 'onCheckAllPayCash')->name('check-all');
                    Route::post('/confirm', 'onConfirmPayCash')->name('confirm');
                    Route::post('/confirm-one', 'onCheckConfirmOnePayment')->name('confirm-one');
                    Route::post('/refund-checked', 'onRefundCheckedPaymentStatus')->name('refund-checked');
                    Route::post('/remove-checked', 'onRemoveCheckedPayment')->name('remove-checked');
                });

                //Hiển thị giao diện Chỉnh sửa Điều Khoản
                Route::post('/terms-interface/display', 'displayManageAdminSystemTermsInterface')->name('terms-interface.show');
                //Xử lý chỉnh sửa Điều Khoản
                Route::post('/terms-interface/handle', 'handleManageAdminSystemTermsInterface')->name('terms-interface.handle');
                // Cập nhật key Vnpay
                Route::post('/infomation-vnpay/action', 'updateInfoVnpay')->name('infomation-vnpay.handle');


                //Hiển thị giao diện chi phí vận hành công ty
                Route::post('/operating-cost/display', 'displayManageAdminSystemOperatingCost')->name('operating-costs.show');
                //Xử lý chỉnh sửa chi phí vận hành công ty
                Route::post('/operating-cost/handle', 'handleManageAdminSystemOperatingCost')->name('operating-costs.update.handle');

                //Hiển thị giao diện liên kết api vận chuyển với dịch vụ
                Route::post('/associate-with-service/display', 'displayManageAdminSystemAssociateWithService')->name('associate-with-service.show');
                //Lấy dữ liệu liên kết api vận chuyển với dịch vụ
                Route::post('/associate-with-service/display/pagination', 'getDataAssociateWithService')->name('associate-with-service.pagination.show');
                //Xử lý dữ liệu liên kết api vận chuyển với dịch vụ
                Route::post('/associate-with-service/update', 'updateDataAssociateWithService')->name('associate-with-service.update.handle');
                //Xoá dữ liệu upload quy đổi cân nặng
                Route::post('/weight-conversion/upload', 'uploadWeightConversion')->name('weight-conversion.upload');
                // Tải file quy đổi cân nặng theo dịch vụ
                Route::post('/weight-conversion/download', 'downloadWeightConversion')->name('weight-conversion.download');

                //Hiển thị giao diện quản lý hình ảnh liên quan
                Route::post('/images-of-web', 'displayImagesOfWeb')->name('images-of-web.show');
                Route::post('/images-of-web/handle', 'handleImagesOfWeb')->name('images-of-web.handle');

                //Hiển thị giao diện cài đặt import excel bảng giá
                Route::post('/price-list/setting-import-excel/display', 'displayManageAdminSystemPriceListSettingImportExcel')->name('price-list.setting-import-excel.show');
                //Lấy dữ liệu cài đặt import excel bảng giá
                Route::post('/price-list/setting-import-excel/display/pagination', 'getDataPriceListSettingImportExcel')->name('price-list.setting-import-excel.pagination.show');
                // Hiển thị giao diện thêm cài đặt import excel bảng giá
                Route::post('/price-list/setting-import-excel/create/display', 'displayManageAdminSystemPriceListSettingImportExcelCreate')->name('price-list.setting-import-excel.create.show');
                // Xử lý thêm cài đặt import excel bảng giá
                Route::post('/price-list/setting-import-excel/create/handle', 'handleManageAdminSystemPriceListSettingImportExcelCreate')->name('price-list.setting-import-excel.create.handle');
                // Hiển thị giao diện chỉnh sửa cài đặt import excel bảng giá
                Route::post('/price-list/setting-import-excel/edit/display', 'displayManageAdminSystemPriceListSettingImportExcelEdit')->name('price-list.setting-import-excel.edit.show');
                // Xử lý chỉnh sửa cài đặt import excel bảng giá
                Route::post('/price-list/setting-import-excel/edit/handle', 'handleManageAdminSystemPriceListSettingImportExcelEdit')->name('price-list.setting-import-excel.edit.handle');
                // Xoá dữ liệu cài đặt import excel bảng giá
                Route::post('/price-list/setting-import-excel/delete', 'handleManageAdminSystemPriceListSettingImportExcelDelete')->name('price-list.setting-import-excel.delete.handle');

                //Hiển thị giao diện danh sách remote
                Route::post('/remote/display', 'displayManageAdminSystemRemote')->name('remote.show');
                //Lấy dữ liệu danh sách remote
                Route::post('/remote/display/pagination', 'getDataRemote')->name('remote.pagination.show');
                //Lấy dữ liệu chi tiết của một remote
                Route::post('/remote/detail', 'getDataRemoteDetail')->name('remote.detail.show');
                //Xử lý dữ liệu remote
                Route::post('/remote/update', 'handleUpdateDataRemote')->name('remote.update.handle');
                //Xoá dữ liệu remote
                Route::post('/remote/delete', 'handleDeleteDataRemote')->name('remote.delete.handle');


                // Chức năng account activity logs
                //Hiển thị giao diện danh sách 
                Route::post('/account-activity-logs/display', 'displayManageAdminSystemActivityLogs')->name('account-activity-logs.show');
                //Lấy dữ liệu danh sách 
                Route::post('/account-activity-logs/display/pagination', 'paginateManageAdminSystemActivityLogs')->name('account-activity-logs.pagination');
                //Lấy dữ dữ liệu chi tiết 
                Route::get('/account-activity-logs/detail/{key}/{password}', 'showDetailAccountActivityLogs')->name('account-activity-logs.pagination.detail');
            });
        });

        Route::prefix('/sale')->name('sale.')->group(function () {
            Route::controller(SaleManagerController::class)->group(function () {
                Route::get('', 'displayIndex')->name('show');
                Route::get('/leader', 'displayLeader')->name('leader');
                Route::post('/leader-list', 'showListSaleLeader')->name('leader.list');
                Route::get('/export-sale-team', 'onExportTeam')->name('leader.team.export');
                Route::post('/leader-users', 'showListUsers')->name('leader.users');
                Route::post('/add-miltiple-leader', 'addMiltipleLeader')->name('leader.add.miltiple');
                Route::post('/add-miltiple-member', 'addMiltipleMember')->name('member.add.miltiple');
                Route::post('/update-member-team', 'updateMemberOnTeam')->name('member.update.team');
                Route::post('/delete-team', 'onDeleteTeam')->name('delete.team');
                Route::post('/transfer-to-team', 'transferToTeam')->name('transfer.member');

                Route::get('/detail', 'displayDetail')->name('detail');
                Route::get('/detail/report', 'getDataShipmentForExcel')->name('detail.report');
                Route::post('/detail/shipments', 'showShipmentsBySale')->name('detail.shipments');

                Route::get('/history-edit', 'displayHistoryEdit')->name('history');
                Route::post('/history-edit/list', 'showListHistoryEdit')->name('history.list');
                Route::post('/update-created_at', 'onUpdateCreatedAtShipment')->name('update-created_at');


                Route::get('/confirm-account', 'displayConfirmAccount')->name('confirm');
                Route::post('/confirm-account', 'showListAction')->name('confirm.show');
                Route::post('/confirm-action', 'handleConfirmAction')->name('confirm.confirm');
                Route::post('/cancel-action', 'handleCancelAction')->name('confirm.cancel');

                Route::get('/fwd', 'displayFwd')->name('fwd.show');
                Route::post('/fwd/list-link', 'showListSaleSuportFwd3')->name('fwd.list-link');
                Route::post('/fwd/list-link2', 'showListSaleSuportFwd2')->name('fwd.list-link2');
                Route::post('/fwd/no-link', 'showListFwdNoLink')->name('fwd.no-link');
                Route::post('/fwd/create-link', 'handleCreateSaleLinkFwd')->name('fwd.create-link');
                Route::post('/fwd/delete-link', 'handleDeleteSaleLinkFwd')->name('fwd.delete-link');

                Route::get('/fwd/add-cost', 'displayFwdAddCost')->name('fwd.add-cost');
                Route::post('/fwd/add-cost/list', 'showListFwdCost')->name('fwd.add-cost.list');
                Route::post('/fwd/add-cost/table-user', 'showListUserFwd')->name('fwd.add-cost.table-user');
                Route::post('/fwd/add-cost/create-miltiple-cost', 'handleMiltipleFwdCostByServiceCreate')->name('fwd.add-cost.create-miltiple-cost');
                Route::post('/fwd/add-cost/delete-cost', 'handleFwdCostByServiceDelete')->name('fwd.add-cost.delete-cost');
                Route::post('/fwd/add-cost/update-cost', 'handleFwdCostByServiceUpdate')->name('fwd.add-cost.update-cost');

                Route::get('/leader-link-cost', 'displayLeaderLinkFwdCost')->name('leader-link-cost');
                Route::post('/leader-link-cost', 'handleLeaderLinkCostFwd')->name('leader-link-cost.handle');
                Route::post('/leader-link-cost/list', 'showListLeaderLinkCost')->name('leader-link-cost.show');
                Route::post('/leader-link-cost/remove', 'handleRemoveLinkLeaderToFwdCost')->name('leader-link-cost.remove');


                Route::get('/fwd/company', 'displayFwdCompany')->name('fwd.company');
                Route::post('/fwd/company/shipments', 'showShipmentsByFwd')->name('fwd.company.shipments');

                Route::get('/all', 'displayAll')->name('all');
                Route::post('/all', 'showAllSale')->name('all.show');

                Route::get('/kpi-manage', 'displayManageKpi')->name('kpi.manage');
                Route::post('/kpi-list', 'showListSaleKpis')->name('kpi.list');
                Route::post('/kpi-detail', 'showDetailKpi')->name('kpi.detail');
                Route::post('/kpi-handle', 'handleCreateOrUpdatekpi')->name('kpi.handle');
                Route::post('/kpi-delete', 'handleDeleteKpi')->name('kpi.delete');
                Route::post('/kpi-users', 'showSaleWithKpi')->name('kpi.users');
                Route::post('/kpi-select', 'selectKpis')->name('kpi.select');
                Route::post('/kpi-connect-sale', 'connectKpiToSale')->name('kpi.connect.sale');
            });
        });
    });

    Route::controller(UtilitiesController::class)->prefix('/util')->name('util.')->group(function () {
        Route::post('/countries-service', 'getCountriesService')->name('countries-service');
    });

    Route::controller(UtilitiesController::class)->group(function () {
        Route::post('/areas', 'getAreas')->name('util.areas');
        Route::post('/services-by-country', 'getServicesByCountry')->name('util.services-by-country');
        Route::post('/receiver-information', 'getReceiverInformation')->name('util.receiver-information');
        Route::post('/states-by-country', 'getStatesByCountry')->name('util.states-by-country');
        Route::post('/cities-by-country-and-state', 'getCitiesByCountryAndState')->name('util.cities-by-country-and-state');
        Route::post('/cities-by-country', 'getCitiesByCountry')->name('util.cities-by-country');
        Route::get('/download/excel/item-sub-price-list', 'downloadExcelItemSubPriceList')->name('util.download.excel.item-sub-price-list');

        Route::post('/content-payment', 'getContentPayment')->name('content-payment');

        Route::post('/upload', 'postUpload');

        Route::get('/util-other', 'displayOtherUtil');
        Route::post('/util-other', 'otherUtil')->name('util.other');

        Route::get('/get-google-maps-key', function () {
            $apiKey = env('GOOGLE_MAPS_API_KEY');
            $response = Http::get("https://maps.googleapis.com/maps/api/js?key={$apiKey}&libraries=places&callback=initAutocomplete");
            return response($response->body())->header('Content-Type', 'application/javascript');
        })->name('google.api');
    });

    Route::controller(TransferController::class)->prefix('transfer')->name('transfer.')->group(function () {
        // Hiển thị trang danh sách khai hàng
        Route::get('/list', 'displayTransferList')->name('list.show');
        // Lấy danh sách khai hàng
        Route::post('/pagination', 'getTransferList')->name('pagination.show');
        // Hiển thị trang thêm mới khai hàng
        Route::post('/create', 'displayTransferCreate')->name('create.show');
        // Hiển thị trang chinh sửa khai hàng
        Route::post('/edit', 'displayTransferEdit')->name('edit.show');
        //Xử lý dữ liệu cập nhật khai hàng
        Route::post('/update', 'handleTransferUpdate')->name('update.handle');
        // Xóa dữ liệu tạo mới khai hàng
        Route::post('/delete', 'handleTransferDelete')->name('delete.handle');
        // Xử lý duyệt khai hàng
        Route::post('/approve', 'handleTransferApprove')->name('approve.handle');
    });
});

Route::controller(UtilitiesController::class)->group(function () {
    Route::post('/areas-in-viet-nam', 'getAreasInVietNam')->name('util.areas-in-viet-nam');
    Route::post('/upload', 'postUpload');
    Route::get('/data-register-account-address', function () {
        $apiKey = env('GOOGLE_MAPS_API_KEY');
        $response = Http::get("https://maps.googleapis.com/maps/api/js?key={$apiKey}&libraries=places&callback=initAutocomplete");
        return response($response->body())->header('Content-Type', 'application/javascript');
    })->name('google.api');

    Route::get('/huong-dan-thanh-toan-vnpay', 'displayIntructVnpay')->name('instruct-vnpay');
    Route::get('/kango-policy', function () {
        return view('template.policy');
    })->name('policy');
    Route::get('/request-remove-account', function () {
        return view('template.request-remove-account');
    });
    Route::post('/request-remove-account', 'onRequestRemoveAccount');
});

Route::fallback(function () {
    return view('template.errors.404');
});
