<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ScanController;
use App\Http\Controllers\DebitController;
use App\Http\Controllers\SepayController;
use App\Http\Controllers\ManageController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\ShipmentController;
use App\Http\Controllers\TransferController;
use App\Http\Controllers\UtilitiesController;
use App\Http\Controllers\AccountantController;
use App\Http\Controllers\ApiDocumnetController;
use App\Http\Controllers\MawbManagerController;
use App\Http\Controllers\OrderPickupController;
use App\Http\Controllers\AuditEpacketController;
use App\Http\Controllers\SaleManagerController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::controller(AuthController::class)->group(function () {
    Route::post('/login', 'handleLogin');
    Route::post('/accuracy', 'handleAccuracy'); // Gửi mã
    Route::post('/register', 'handleRegister');
    Route::post('/forgot-password', 'handleForgotPassword');
    Route::post('/terms-of-use', 'getTermsOfUse');
});

Route::controller(ApiDocumnetController::class)->group(function () {
    Route::get('/get-tracking', 'onGetTracking');
    Route::post('/create-bill', 'onCreateShipment');
});

Route::controller(UtilitiesController::class)->group(function () {
    Route::post('/countries', 'getAreas'); // thông tin khu vực trên TG
    Route::post('/areas-in-viet-nam', 'getAreasInVietNam'); // thông tin khu vực trên VN
    Route::post('/services-by-country', 'getServicesByCountry')->name('util.services-by-country');

    Route::get('/recharge/ipn-vnpay', 'vnpayIpn');
});

Route::middleware(['auth.api', 'auth:sanctum'])->name('api')->group(function () {
    Route::controller(SepayController::class)->prefix('sepay')->name('sepay.')->group(function () {
        Route::get('/recharge/{recharge_id}', 'displaySepayRecharge')->name('recharge.show');
        Route::post('/recharge', 'handleSepayRecharge')->name('recharge.handle');
        Route::post('/check-payment', 'checkSepayPayment')->name('check-payment.show');
    });

    Route::controller(AuthController::class)->group(function () {
        Route::get('/logout', 'handleLogoutApi'); // Đăng xuất
        Route::post('/profile/info', 'getInfo'); // Lấy thông tin user
        Route::post('/profile/edit', 'handleEdit'); // Cập hật thông tin user
        Route::post('/profile/update-password', 'handleNewPassword');  // Cập nhật lại mật khẩu user
        Route::post('/update-user-accountant-key', 'handleUpdateUserAccountantKey');  // Cập nhật lại mã kế toán
        Route::get('/menu-user', 'getMenuForUser'); // Lấy menu theo user
    });

    Route::controller(HomeController::class)->group(function () {
        //Lấy dữ liệu giao diện trang chủ
        Route::post('/dashboard', 'getDataDashboard')->name('dashboard.show');
        //Lay cai dat
        Route::post('/dashboard-setup', 'getDataDashboardSetup')->name('dashboard.setup.show');

        //Hiển thị giao diện danh sách thông báo
        Route::get('/notifications', 'displayNotifications')->name('notifications.show');
        //Lấy dữ liệu danh sách thông báo
        Route::post('/notifications', 'getNotifications')->name('notifications.pagination.show');
        //Hiển thị giao diện thêm thông báo
        Route::get('/notifications/create', 'displayNotificationsCreate')->name('notifications.create.show');
        //Xử lý dữ liệu thêm thông báo
        Route::post('/notifications/create', 'handleNotificationsCreate')->name('notifications.create.handle');
        //Hiển thị giao diện chi tiết thông báo
        Route::get('/notifications/detail/{notification_id}', 'displayNotificationsDetail')->name('notifications.detail.show');
        //Hiển thị giao diện chỉnh sửa thông báo
        Route::get('/notifications/edit/{notification_id}', 'displayNotificationsEdit')->name('notifications.edit.show');
        //Xử lý dữ liệu chỉnh sửa thông báo
        Route::post('/notifications/edit', 'handleNotificationsEdit')->name('notifications.edit.handle');
        //Xử lý xóa thông báo
        Route::post('/notifications/delete', 'handleNotificationsDelete')->name('notifications.delete.handle');
    });

    Route::controller(UtilitiesController::class)->group(function () {
        Route::post('/services-by-country', 'getServicesByCountry');
        Route::post('/system-settings', 'getSettingsManager');

        Route::post('/content-payment', 'getContentPayment');
    });

    Route::controller(OrderPickupController::class)->prefix('order-pickup')->name('pickup.')->group(function () {
        //Lấy dữ liệu order pickup
        Route::post('/pagination', 'getOrderPickup')->name('pagination.show');
        //Cập nhật dữ liệu order pickup
        Route::post('/update', 'handleUpdateOrderPickup')->name('update.handle');
        //Lấy thông tin chi tiết order pickup
        Route::post('/detail', 'getDetailOrderPickup')->name('detail.show');
        //Xóa order pickup
        Route::post('/delete', 'handleDeleteOrderPickup')->name('delete.handle');
        //Lấy thông tin chi tiết khi in order pickup
        Route::post('/inpickup', 'getDetailPrintOrderPickup')->name('inpickup.show');

        //shipper lấy đơn hàng
        Route::post('/shipper-take', 'handleShipperTakePackage');
        //cập nhật vị trí shipper
        Route::post('/shipper-update-location', 'handleUpdateShipper');
        //shipper bắt đầu hành trình
        Route::post('/shipper-start', 'onShipperStartPickup');
        //shipper hoàn thành hành trình
        Route::post('/shipper-finished', 'onfinishedShipper');
        //shipper 
        Route::post('/shipper-list', 'showListHistoryShipper');
        Route::post('/shippers-free', 'showListShipperFree');
        Route::post('/shipper-cancel', 'onCancelShipper');
    });

    Route::controller(ShipmentController::class)->prefix('shipments')->group(function () {
        Route::post('/list', 'getShipments');
        Route::post('/service-type', 'showServiceType');
        Route::post('/create', 'handleShipmentCreate');
        Route::post('/detail', 'getShipmentDetail');
        // Hiển thị giao diện cập nhật chi phí vận hành công ty
        Route::post('/detail/shipment-operating-costs', 'getShipmentDetailOperatingCosts')->name('detail.shipment-operating-costs.show');
        // Xử lý cập nhật chi phí vận hành công ty
        Route::post('/detail/save-shipment-operating-costs', 'handleShipmentDetailOperatingCosts')->name('detail.shipment-operating-costs.handle');
        Route::post('/edit', 'getShipmentEdit');
        Route::post('/edit/handle', 'handleShipmentEdit');
        Route::post('/delete', 'handleShipmentDelete');
        Route::post('/get-receivers', 'getReceivers');
        Route::post('/get-detail-receiver', 'getDetailReceiver');
        Route::post('/get-unit-create-package-and-invoice', 'getUnitCreatePackageAndInvoice');

        // Xử lý cập nhật label
        Route::post('/update-label', 'handleLabelEdit');
        // Xử lý cập nhật label
        Route::post('/create-label-reload', 'onCreateLabelReload');
        // Xử lý cập nhật method
        Route::post('/update-method', 'handleMethodEdit');
        // Xử lý cập nhật freight
        Route::post('/update-freight', 'handleAmountFreight');

        // Hiển thị chi tiết package
        Route::post('/detail/package', 'getDetailPackage');
    });

    Route::controller(UtilitiesController::class)->prefix('utils')->name('utils.')->group(function () {
        //Lấy danh sách chi nhánh công ty
        Route::post('/branchs', 'getBranchs')->name('branchs.show');
    });

    Route::name('supports.')->group(function () {
        Route::controller(TicketController::class)->prefix('tickets')->name('tickets.')->group(function () {
            Route::post('/setup', 'getSetupTicket')->name('setup.show');
            Route::post('/me', 'getTicketsByUser')->name('me.show');
            Route::post('/add', 'handleAddTicket')->name('handle');
            Route::post('/detail', 'getDetailTicket')->name('detail.show');
            Route::post('/add-message', 'handleAddTicketMessage')->name('add-message.handle');
        });
    });

    Route::controller(WalletController::class)->name('wallet.')->group(function () {
        Route::prefix('wallet')->name('wallet.')->group(function () {
            Route::post('/user', 'getWalletByUser')->name('user');
            Route::post('/vnpay', 'getVNPAY')->name('user');
            Route::post('/fluctuation', 'showListWalletFlut')->name('fluctuation.show');
        });
        Route::prefix('recharge')->group(function () {
            //Lấy danh sách yêu cầu nạp tiền
            Route::post('/list', 'showListRecharge');
            Route::post('/detail', 'handleShowDetailRecharge');
            Route::post('/create', 'handleRecharge');

            Route::post('/vnpay', 'handleVNPAY');
            Route::get('/return-vnpay', 'returnVNPAY');
        });
    });

    Route::controller(ScanController::class)->prefix('/scan')->group(function () {

        Route::post('/update-status', 'handleCreateHistory');
        Route::post('/bag-code/check', 'checkBarCode');
        Route::post('/export/modal', 'showDetailPackage');

        // Route::post('/update-status', 'handleCreateHistory');
        Route::post('/list', 'showListHistoryScan');
        Route::post('/cancel-status', 'handleCancelStatus');

        Route::post('/bag-code', 'showListBags')->name('bag-code.list');
        Route::post('/list/surchage-goods', 'showSurchageGoods');
    });

    Route::controller(MawbManagerController::class)->prefix('mawb-manager')->group(function () {

        Route::post('/list-sm-tracktry', 'showListSmTracktry');
        Route::post('/detail-sm-tracktry', 'showDetailSmTracking');
        Route::post('/create-sm-tracktry', 'handleCreateSMTracktry');
        Route::post('/update-sm-tracktry', 'handleUpdateSMTracktry');
        Route::post('/hiden-sm-tracktry', 'hidenSMTracktry');
    });

    Route::controller(ManageController::class)->prefix('/manage')->group(function () {
        Route::post('/users-fwd', 'getFwdByPickup');
        Route::post('/users-sale', 'getListSale');
    });
    Route::controller(AuditEpacketController::class)->prefix('audit-epacket')->name('audit-epacket.')->group(function () {
        // Danh sách dịch vụ Epackage
        Route::get('/epackage-services', 'getEPackageServices')->name('epackage-services');
        // Danh sách dịch vụ PackageManager
        Route::get('/package-manager-services', 'getPackageManagerServices')->name('package-manager-services');
        // Danh sách trạng thái
        Route::get('/shipment-statuses', 'getShipmentStatuses')->name('shipment-statuses');
        // Lấy danh sách shipment
        Route::post('/pagination', 'getShipments')->name('list.pagination.show');
        // Cập nhật ghi chú
        Route::post('/update-note', 'handleUpdateNote')->name('update-note.handle');
    });
    Route::controller(AccountantController::class)->prefix('accountant')->name('accountant.')->group(function () {
        Route::post('/wallet-fluctuations/paginate', 'showListWalletFluctuation')->name('wallet-fluctuations.paginate');
    });
    Route::controller(TransferController::class)->prefix('transfer')->name('transfer.')->group(function () {
        // Lấy danh sách khai hàng
        Route::post('/pagination', 'getTransferList')->name('pagination.show');
        //Xử lý dữ liệu cập nhật khai hàng
        Route::post('/update', 'handleTransferUpdate')->name('update.handle');
        // Xóa dữ liệu tạo mới khai hàng
        Route::post('/delete', 'handleTransferDelete')->name('delete.handle');
        // Xử lý duyệt khai hàng
        Route::post('/approve', 'handleTransferApprove')->name('approve.handle');
    });
    Route::controller(DebitController::class)->prefix('debit')->name('debit.')->group(function () {
        Route::post('/verify', 'verifyToShowDebit')->name('verify');
        Route::get('/manager', 'displayDebitFwd')->name('index.fwd');  // Màn hình debit tài khoản fwd 
        Route::post('/fwd-paginate', 'showDebitsFwd')->name('paginate.fwd');  // Màn hình debit tài khoản fwd 


        Route::get('/list', 'displayListDebit')->name('list.index');  // Đi đến màn hình  
        Route::get('/detail/{debit_code}', 'displayDebitDetail')->name('detail');  // Đi đến màn hình  
        Route::get('/customer-detail/{user_code}', 'displayCustomerDetail')->name('customer');  // Đi đến màn hình  
        Route::get('/edit-subpackage', 'displaySubPackage')->name('subpackage');  // Đi đến màn hình  
        Route::get('/list-import', 'displayListImport')->name('list.import');  // Đi đến màn hình  

        // Danh sách debits
        Route::post('/list', 'showListDebit')->name('list.show');
        Route::post('/payment', 'paymentDebit')->name('payment');
        Route::post('/payment-fwd', 'sendPaymentDebitFwd')->name('payment-fwd');
        Route::post('/advance-fwd', 'advanceDebit')->name('advance-fwd');

        Route::post('/detail-shipment', 'showListShipmentDebit')->name('detail.shipment.show');
        // xác nhận duyệt các đơn shipment trong debit
        Route::post('/accountant-confirm', 'onAcountantConfimInDebit')->name('accountant-confirm');


        // của fwd 
        Route::prefix('/fwd')->name('fwd.')->group(function () {
            Route::get('/list', 'displayListDebitFwd')->name('list.index');  // Đi đến màn hình  Quản lý 
            Route::get('/detail', 'displayDebitDetailFwd')->name('list.detail');  // Đi đến màn hình  chi tiết khi nhấn vào 

            Route::get('/detail-sm-fwd', 'displayDetailCompany')->name('detail.sm-fwd');
            Route::post('/detail-sm-fwd', 'paginateListShipmentFwd')->name('detail.sm-fwd.paginate');

            Route::get('/list-sm-fwd', 'displayListShipmentFwd')->name('list.sm-fwd');  // Đi đến màn hình  Quản lý 
            Route::post('/shipment-fwd', 'showListShipmentFwd')->name('shipment-fwd');

            Route::get('/imported-goods', 'displayImportedGoods')->name('imported-goods'); // Màn hình danh sách hàng nhập
            Route::post('/imported-goods', 'showImportedGoods')->name('imported-goods.index');  // Đổ data danh sách hàng nhập
            Route::get('/imported-goods/detail/{package_code}', 'displayImportedGoodsDetail')->name('imported-goods.detail'); // Chi tiết hàng nhập
            Route::post('/imported-goods/detail/update-internal-surcharge/{package_code}', 'updateInternalSurcharge')->name('imported-goods.detail.update-internal-surcharge'); // Cập nhật phụ thu TRONG hệ thống
            Route::post('/imported-goods/detail/update-external-surcharge/{package_code}', 'updateExternalSurcharge')->name('imported-goods.detail.update-external-surcharge'); // Cập nhật phụ thu NGOÀI hệ thống

            Route::post('/create-debit', 'createDebitFwd')->name('debit.create');
            Route::post('/create-debit2', 'createDebitFwd2')->name('debit.create2');
            Route::post('/cancel-debit', 'onCancelDebit')->name('debit.cancel');

            Route::post('/export-shipment', 'onExportShipmentByDebit')->name('export.shipment');
            Route::get('/export-bill-debit', 'exportBillDebit')->name('export.bill.debit');
        });
    });


    // SALE MANAGER
    Route::controller(SaleManagerController::class)->prefix('/sale')->group(function () {
        Route::get('', 'displayIndex'); // Màn hình 

        Route::get('/leader', 'displayLeader');
        Route::post('/leader-list', 'showListSaleLeader');
        Route::get('/export-sale-team', 'onExportTeam');
        Route::post('/leader-users', 'showListUsers');
        Route::post('/add-miltiple-leader', 'addMiltipleLeader');
        Route::post('/add-miltiple-member', 'addMiltipleMember');
        Route::post('/update-member-team', 'updateMemberOnTeam');
        Route::post('/delete-team', 'onDeleteTeam');
        Route::post('/transfer-to-team', 'transferToTeam');

        Route::get('/detail', 'displayDetail');
        Route::get('/detail/report', 'getDataShipmentForExcel');
        Route::post('/detail/shipments', 'showShipmentsBySale');

        Route::get('/history-edit', 'displayHistoryEdit');
        Route::post('/history-edit/list', 'showListHistoryEdit');
        Route::post('/update-created_at', 'onUpdateCreatedAtShipment');


        Route::get('/confirm-account', 'displayConfirmAccount');
        Route::post('/confirm-account', 'showListAction');
        Route::post('/confirm-action', 'handleConfirmAction');
        Route::post('/cancel-action', 'handleCancelAction');

        Route::get('/fwd', 'displayFwd');
        Route::post('/fwd/list-link', 'showListSaleSuportFwd3');
        Route::post('/fwd/list-link2', 'showListSaleSuportFwd2');
        Route::post('/fwd/no-link', 'showListFwdNoLink');
        Route::post('/fwd/create-link', 'handleCreateSaleLinkFwd');
        Route::post('/fwd/delete-link', 'handleDeleteSaleLinkFwd');

        Route::get('/fwd/add-cost', 'displayFwdAddCost');
        Route::post('/fwd/add-cost/list', 'showListFwdCost');
        Route::post('/fwd/add-cost/table-user', 'showListUserFwd');
        Route::post('/fwd/add-cost/create-miltiple-cost', 'handleMiltipleFwdCostByServiceCreate');
        Route::post('/fwd/add-cost/delete-cost', 'handleFwdCostByServiceDelete');
        Route::post('/fwd/add-cost/update-cost', 'handleFwdCostByServiceUpdate');

        Route::get('/leader-link-cost', 'displayLeaderLinkFwdCost');
        Route::post('/leader-link-cost', 'handleLeaderLinkCostFwd');
        Route::post('/leader-link-cost/list', 'showListLeaderLinkCost');
        Route::post('/leader-link-cost/remove', 'handleRemoveLinkLeaderToFwdCost');


        Route::get('/fwd/company', 'displayFwdCompany');
        Route::post('/fwd/company/shipments', 'showShipmentsByFwd');

        Route::get('/all', 'displayAll');
        Route::post('/all', 'showAllSale');

        Route::get('/kpi-manage', 'displayManageKpi');
        Route::post('/kpi-list', 'showListSaleKpis');
        Route::post('/kpi-detail', 'showDetailKpi');
        Route::post('/kpi-handle', 'handleCreateOrUpdatekpi');
        Route::post('/kpi-delete', 'handleDeleteKpi');
        Route::post('/kpi-users', 'showSaleWithKpi');
        Route::post('/kpi-select', 'selectKpis');
        Route::post('/kpi-connect-sale', 'connectKpiToSale');
    });
});
