<div class="table-responsive">
    <table class="table mb-5">
        <thead class="thead-primary">
            <tr role="row">
                <th rowspan="1" colspan="1">STT</th>
                <th class="sorting fw-bold">
                    Người tạo
                </th>
                <th class="sorting fw-bold">
                    Người nhận
                </th>
                <th class="sorting fw-bold">
                    Địa chỉ
                </th>
                <th class="sorting fw-bold">
                    Số điện thoại
                </th>
                <th class="sorting fw-bold">
                    Mã đơn hàng
                </th>
                <th class="sorting fw-bold">
                    Người duyệt
                </th>
                <th class="sorting fw-bold">
                    Trạng thái
                </th>
                <th class="fw-bold">
                    NGÀY TẠO
                </th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($transfer as $item)
                <tr class="odd">
                    <td>
                        {{ $loop->iteration }}
                    </td>
                    <td>
                        {{ $item['user']['user_contact_name'] }}
                    </td>
                    <td>
                        {{ $item['receiver_name'] }}
                    </td>
                    <td>
                        {{ $item['receiver_address'] }}
                    </td>
                    <td>
                        {{ $item['receiver_phone'] }}
                    </td>
                    <td>
                        @foreach ($item['transfer_shipments'] as $transfer_shipment)
                            <p>
                                <a href="{{ route('shipments.detail.show', ['shipment_code' => $transfer_shipment['shipment_code']])}}" target="_blank">
                                    {{ $transfer_shipment['shipment_code'] }}
                                </a>
                            </p>
                        @endforeach
                    </td>
                    <td>
                        {{ $item['reviewer']['user_contact_name'] ?? '' }}
                    </td>
                    <td>
                        {{ $item['transfer_status_name'] }}
                    </td>
                    <td>
                        {{ formatDate($item['created_at']) }}
                    </td>
                    <td>
                        <button type="button" class="btn btn-info"
                            onclick="showDetailTransfer({{ json_encode($item) }})">
                            <i class="fas fa-eye"></i>
                        </button>
                        <button type="button" class="btn btn-primary btn-edit-transfer"
                            data-transfer_id="{{ $item['transfer_id'] }}">
                            <i class="fas fa-pencil-alt"></i>
                        </button>
                        @if (isGetAllData() && $item['transfer_status'] == INACTIVE)    
                            <button type="button" class="btn btn-success btn-approve-transfer"
                                data-transfer_id="{{ $item['transfer_id'] }}">
                                <i class="fas fa-check"></i>
                            </button>
                        @endif
                        <button type="button" class="btn btn-danger btn-delete-transfer"
                            data-transfer_id="{{ $item['transfer_id'] }}">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center">
    {{ $transfer->links('components.pagination') }}
</div>
