@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contact-body p-2">
                <div class="card card-body">
                    <div class="row">
                        <div class="col-sm-4 mb-3">
                            <label class="form-lable">Từ ngày đến ngày</label>
                            <div class="input-group">
                                <span class="input-affix-wrapper">
                                    <span class="input-prefix">
                                        <span class="feather-icon">
                                            <i data-feather="calendar"></i>
                                        </span>
                                    </span>
                                    <input class="form-control form-wth-icon" name="transfer_daterange">
                                </span>
                            </div>
                        </div>
                        <div class="mb-3 col-sm-8">
                            <label class="form-lable">Tìm kiếm</label>
                            <input type="text" class="form-control" name="transfer_keywords"
                                placeholder="Nhập nội dung bạn muốn tìm kiếm">
                        </div>
                    </div>
                    <div class="text-end">
                        <button id="onCreateTransfer" type="button" class="btn btn-success">
                            Thêm mới khai hàng
                        </button>
                    </div>
                </div>
                <div data-simplebar="init" class="nicescroll-bar">
                    <x-spinner id="loading_show_table_content" />
                    <div id="show_table_content"></div>
                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>

    <div class="modal fade" id="modalTransfer" tabindex="-1" aria-labelledby="modalTransferLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="modalTransferLabel">
                        Thông tin khai hàng
                    </h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <x-spinner id="loading_show_transfer" />
                    <div id="contentModalTransfer"></div>
                </div>
                <div class="modal-footer d-flex justify-content-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Đóng
                    </button>
                    <button id="agreeSaveTransfer" type="button" class="btn btn-primary">
                        Lưu khai hàng
                    </button>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/vendors/ckeditor5/build/ckeditor.js') }}"></script>
        <script src="{{ asset('js/transfer/list.js') }}"></script>
    @endpush
@endsection
