<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>{{ $meta['title'] ?? 'Kango' }}</title>

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="keywords" content="{{ isset($meta['keywords']) ? $meta['keywords'] : '' }}">
    <meta name="description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}">
    <meta property="og:title" content="{{ isset($meta['title']) ? $meta['title'] : '' }}" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="{{ isset($meta['url']) ? $meta['url'] : '' }}" />
    <meta property="og:image" content="{{ isset($meta['image']) ? $meta['image'] : '' }}" />
    <meta property="og:description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}" />
    <meta property="og:site_name" content="{{ isset($meta['site_name']) ? $meta['site_name'] : '' }}" />

    <link href="{{ asset('assets/dist/css/style.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/vendors/sweetalert2/dist/sweetalert2.min.css') }}" rel="stylesheet" type="text/css">

</head>

<body>
    <div class="hk-wrapper hk-pg-auth" data-footer="simple">
        <!-- Main Content -->
        <div class="hk-pg-wrapper pt-0 pb-xl-0 pb-5">
            <div class="hk-pg-body pt-0 pb-xl-0">
                <!-- Container -->
                <div class="container-xxl">
                    <!-- Row -->
                    <div class="row">
                        <div class="col-sm-10 position-relative mx-auto">
                            <div class="auth-content py-8">
                                <form class="w-100" id="form-data">
                                    <div class="row">
                                        <div class="col-lg-5 col-md-7 col-sm-10 mx-auto">
                                            <div class="text-center mb-7">
                                                <img src="{{ asset(LOGO) }}" alt=""
                                                    style="height: 70px; object-fit: cover;">
                                            </div>
                                            <div class="card card-lg card-border">
                                                <div class="card-body">
                                                    <h4 class="mb-4 fw-bold text-primary text-center">Yêu cầu xóa tài
                                                        khoản</h4>
                                                    <div class="row gx-3">
                                                        <div class="form-group col-lg-12">
                                                            <div class="form-label-group">
                                                                <label>Tài khoản</label>
                                                            </div>
                                                            <input class="form-control" id="user_name"
                                                                placeholder="Nhập tài khoản của bạn" value=""
                                                                type="text" required>
                                                            <small class="text-danger" id="user_name_err"></small>
                                                        </div>
                                                        <div class="form-group col-lg-12">
                                                            <div class="form-label-group">
                                                                <label>Mật khẩu</label>
                                                            </div>
                                                            <div class="input-group password-check">
                                                                <span class="input-affix-wrapper">
                                                                    <input class="form-control" id="password"
                                                                        placeholder="Nhập mật khẩu của bạn"
                                                                        value="" type="password" required>
                                                                    <a href="#" class="input-suffix text-muted">
                                                                        <span class="feather-icon"><i class="form-icon"
                                                                                data-feather="eye"></i></span>
                                                                        <span class="feather-icon d-none"><i
                                                                                class="form-icon"
                                                                                data-feather="eye-off"></i></span>
                                                                    </a>
                                                                </span>
                                                                <small class="text-danger" id="password_err"></small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex justify-content-center">
                                                        <div class="form-check form-check-sm mb-3">
                                                            <input type="checkbox" class="form-check-input"
                                                                id="is_confirm" required>
                                                            <label class="form-check-label text-muted fs-7"
                                                                for="logged_in">Tôi chắc chắn muốn xóa tài khoản
                                                                này</label>
                                                        </div>
                                                        <small class="text-danger" id="is_confirm_err"></small>
                                                    </div>
                                                    <button class="btn btn-primary btn-uppercase btn-block">Xác
                                                        nhận</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- /Row -->
                </div>
                <!-- /Container -->
            </div>
            <!-- /Page Body -->

            <!-- Page Footer -->
            <div class="hk-footer border-0">
                <footer class="container-xxl footer">
                    <div class="row">
                        <div class="col-xl-8 text-center">
                            <p class="footer-text pb-0"><span class="copy-text">Kango Express © 2024 All
                                    rights reserved.</p>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
    </div>
    <script src="{{ asset('assets/vendors/jquery/dist/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/bootstrap/dist/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/vendors/sweetalert2/dist/sweetalert2.min.js') }}"></script>

    <script src="{{ asset('js/sweetalert2.js') }}"></script>
    <script src="{{ asset('js/ajax-contants.js') }}"></script>
    <script src="{{ asset('js/other.js') }}"></script>

    <script>
        const formVali = ['user_name_err', 'password', 'is_confirm_err'];
        $(document).ready(function() {
            try {
                $('#form-data').on('submit', async function(e) {
                e.preventDefault(); // Ngăn form gửi đi và chuyển trang

              
                formVali.forEach(item => {
                    $('#' + item).html('');
                });

                // Thực hiện xử lý dữ liệu ở đây
                let url = window.location.origin + '/request-remove-account';
                let data = {
                    user_name: $('#user_name').val(),
                    password: $('#password').val(),
                    is_confirm: $('#is_confirm').is(':checked'),
                }

                let res = await ajaxContants2(url, 'POST', data);

                if (res.status == 200) {

                } else if (res.status == 422) {
                    var errors = res.error;
                    $.each(errors, function(key, value) {
                        $('#' + key + '_err').text(value[0]);
                    });
                }
                showMessage(res.message);
            });
            } catch (error) {
                console.log(error);
                
            }
        });
    </script>
</body>

</html>
