<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>{{ $meta['title'] ?? 'Kango' }}</title>

    <meta name="keywords" content="{{ isset($meta['keywords']) ? $meta['keywords'] : '' }}">
    <meta name="description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}">
    <meta property="og:title" content="{{ isset($meta['title']) ? $meta['title'] : '' }}" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="{{ isset($meta['url']) ? $meta['url'] : '' }}" />
    <meta property="og:image" content="{{ isset($meta['image']) ? $meta['image'] : '' }}" />
    <meta property="og:description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}" />
    <meta property="og:site_name" content="{{ isset($meta['site_name']) ? $meta['site_name'] : '' }}" />

    <link href="{{ asset('assets/dist/css/style.css') }}" rel="stylesheet" type="text/css">

</head>

<body class=" bg-primary-light-5">
    <div class="">
        <div class="auth-content py-8">
            <div class="">
                <div class="flex-column text-center">
                    <div class="mx-auto">
                        <img src="{{ asset(LOGO) }}" alt="" style="height: 70px; object-fit: cover;">
                    </div>
                    <div class="mx-auto">
                        <h2 class="mb-4">Chính sách bảo mật</h2>
                    </div>
                </div>
                <div class="container card">
                    <div class="card-body">
                        <p>Bảo mật thông tin cá nhân của khách hàng là một trong những ưu tiên hàng đầu của <strong>CÔNG
                                TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong>. Vì thế, chúng tôi rất trân trọng và cam kết
                            ưu tiên bảo mật thông tin cá nhân của khách hàng. Cũng như đảm bảo sẽ sử dụng thông tin một
                            cách hợp lý, có cân nhắc và đúng quy định của pháp luật, nhằm nâng cao chất lượng dịch vụ
                            chăm sóc khách hàng.</p>

                        <h4 class="mt-4">1. Mục đích và phạm vi thu thập thông tin</h4>

                        <h5 class="mt-3">1.1. Mục đích</h5>
                        <p>Để thuận tiện trong việc truy cập và sử dụng dịch vụ của chúng tôi, quý khách hàng sẽ có thể
                            được yêu cầu đăng ký tài khoản với một vài thông tin cá nhân. Việc thu thập dữ liệu trên
                            <strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong> bao gồm: họ tên, email, số điện
                            thoại,… Mọi thông tin khai báo cần phải đảm bảo tính chính xác và hợp pháp. <strong>CÔNG TY
                                TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong> không chịu mọi trách nhiệm liên quan đến pháp
                            luật về vấn đề thông tin do khách hàng cung cấp.
                        </p>

                        <h5 class="mt-3">1.2. Phạm vi</h5>
                        <p>Vấn đề thu thập và sử dụng thông tin cá nhân với mục đích phù hợp và hoàn toàn tuân thủ nội
                            dung của chính sách bảo mật. <strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong> sử
                            dụng thông tin khách hàng để thiết lập tài khoản và liên hệ xác nhận khi khách hàng đăng ký
                            sử dụng dịch vụ. Ngoài ra, khi có những vấn đề phát sinh hay những trường hợp cần thiết
                            khác, chúng tôi có thể sử dụng những thông tin này để liên hệ trực tiếp với khách hàng dưới
                            các hình thức: gửi thư ngỏ, thư cảm ơn, sms, thông tin về kỹ thuật và bảo mật,… nhằm đảm bảo
                            quyền lợi cho người tiêu dùng.</p>

                        <h4 class="mt-4">2. Thời gian lưu trữ thông tin</h4>
                        <p><strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong> sẽ lưu giữ thông tin của khách hàng
                            cho đến khi tài khoản ngừng hoạt động. Tức là, dữ liệu sẽ được lưu trữ cho đến khi có yêu
                            cầu hủy bỏ hoặc tự khách hàng đăng nhập và hủy bỏ tài khoản. Khách hàng có thể xóa hoặc vô
                            hiệu hóa tài khoản bất kỳ lúc nào bằng cách liên hệ với chúng tôi.</p>
                        <p>Thời gian còn lại trong mọi trường hợp, thông tin cá nhân của khách hàng sẽ được bảo mật trên
                            máy chủ của <strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong>.</p>

                        <h4 class="mt-4">3. Cam kết bảo mật thông tin khách hàng</h4>
                        <p>Thông tin cá nhân của thành viên trên <strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN
                                KANGO</strong> được cam kết bảo mật tuyệt đối theo chính sách bảo vệ thông tin cá nhân
                            của <strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong>. Việc thu thập và sử dụng thông
                            tin cá nhân của mỗi thành viên chỉ được thực hiện khi có sự đồng ý của khách hàng đó trừ
                            những trường hợp pháp luật có quy định khác.</p>

                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">Không tạo điều kiện và/hoặc cho phép bất kỳ người thứ ba ngoài
                                bạn sử dụng hoặc/và cùng sử dụng tài khoản học tập cho bất kỳ mục đích nào.</li>
                            <li class="list-group-item">Không cung cấp, rao bán, chuyển nhượng, tiết lộ thông tin tài
                                khoản, mật khẩu cho bất kỳ cá nhân hay tổ chức nào khác khi không có sự cho phép trước
                                văn bản bằng giấy tờ, ngoại trừ đại diện của <strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN
                                    KANGO</strong> khi cần phối hợp.</li>
                            <li class="list-group-item">Để tránh tình trạng lừa đảo, lợi dụng lòng tin, bạn không nhận
                                thông tin tư vấn từ các cá nhân, tổ chức nào khác không phải đại diện chính thức từ
                                <strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong>.
                            </li>
                        </ul>

                        <p class="mt-3">Trong trường hợp máy chủ lưu trữ thông tin bị hacker tấn công dẫn đến mất mát
                            dữ liệu cá nhân thành viên, <strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong> sẽ có
                            trách nhiệm thông báo vụ việc cho cơ quan chức năng điều tra xử lý kịp thời và thông báo cho
                            thành viên được biết.</p>

                        <h4 class="mt-4">4. Đơn vị cung cấp dịch vụ và thu thập, quản lý thông tin khách hàng</h4>
                        <address class="border p-3 bg-light">
                            <strong>CÔNG TY TNHH GIAO NHẬN VẬN CHUYỂN KANGO</strong><br>
                            Địa chỉ: 26 đường số 7, KDC Cityland Parkhills, phường 10, Gò Vấp, TPHCM<br>
                            Hotline: <a href="tel:19009475">1900 9475</a><br>
                            Email: <a href="info@kangoexp.vn">info@kangoexp.vn</a>
                        </address>

                        <p>Nếu có bất kì câu hỏi nào về chính sách hoặc bất kỳ thắc mắc về công ty, quý khách vui lòng
                            liên hệ với chúng tôi theo thông tin trên để được hỗ trợ kịp thời.</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center">
            <p class="mx-auto p-xs credit-text opacity-55 mb-3">Kango Express © 2024 All
                rights reserved.</p>
        </div>
    </div>
</body>

</html>
