<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>{{ $meta['title'] ?? 'Kango' }}</title>

    <meta name="keywords" content="{{ isset($meta['keywords']) ? $meta['keywords'] : '' }}">
    <meta name="description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}">
    <meta property="og:title" content="{{ isset($meta['title']) ? $meta['title'] : '' }}" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="{{ isset($meta['url']) ? $meta['url'] : '' }}" />
    <meta property="og:image" content="{{ isset($meta['image']) ? $meta['image'] : '' }}" />
    <meta property="og:description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}" />
    <meta property="og:site_name" content="{{ isset($meta['site_name']) ? $meta['site_name'] : '' }}" />

    <link href="{{ asset('assets/dist/css/style.css') }}" rel="stylesheet" type="text/css">
  
</head>

<body>
    <div class="container py-6">
        <h3 class="leading-7 [&amp;:not(:first-child)]:mt-4"><strong>HƯỚNG DẪN THANH TOÁN VNPAY TRÊN WEBSITE</strong></h3>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Cổng thanh toán VNPAY là giải pháp thanh toán do Công ty Cổ
            phần
            Giải pháp Thanh toán Việt Nam (VNPAY) phát triển. Khách hàng sử dụng thẻ/tài khoản ngân hàng, tính năng QR
            Pay/VNPAY-QR được tích hợp sẵn trên ứng dụng Mobile Banking của các ngân hàng hoặc Ví điện tử liên kết để
            thanh
            toán các giao dịch và nhập mã giảm giá (nếu có)</p>
        <div align="center">
            <p class="leading-7 [&amp;:not(:first-child)]:mt-4"><img class="rounded-md"
                    alt="Screenshot 2023-11-08 160333.png"
                    src="https://cdn.dev.nexbus.net/nexbus/e4/Screenshot_2023_11_08_160333_afaaed37a5.png"></p>
            <p class="leading-7 [&amp;:not(:first-child)]:mt-4"><img class="rounded-md"
                    alt="Screenshot 2023-11-08 160345.png"
                    src="https://cdn.dev.nexbus.net/nexbus/9b/Screenshot_2023_11_08_160345_5365085f74.png"></p>
            <p class="leading-7 [&amp;:not(:first-child)]:mt-4"><img class="rounded-md"
                    alt="Screenshot 2023-11-08 160353.png"
                    src="https://cdn.dev.nexbus.net/nexbus/3a/Screenshot_2023_11_08_160353_c5f1179cb9.png"></p>
            <p class="leading-7 [&amp;:not(:first-child)]:mt-4"><img class="rounded-md"
                    alt="Screenshot 2023-11-08 160405.png"
                    src="https://cdn.dev.nexbus.net/nexbus/e8/Screenshot_2023_11_08_160405_68077cb449.png"></p>
        </div>
        <h5 class="leading-7 [&amp;:not(:first-child)]:mt-4"><strong>1. Phương thức thanh toán qua “Ứng dụng thanh toán
                hỗ
                trợ VNPAY-QR”</strong></h5>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Bước 1: Quý khách lựa chọn sản phẩm, dịch vụ và chọn Thanh
            toán
            ngay hoặc Đặt hàng
            Tại trang thanh toán, vui lòng kiểm tra lại sản phẩm đã đặt, điền đầy đủ thông tin người nhận hàng, chọn
            phương
            thức thanh toán VNPAY và nhấn nút “Đặt hàng ngay”.</p>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Bước 2: Màn hình thanh toán chuyển sang giao diện cổng thanh
            toán VNPAY. Chọn phương thức “Ứng dụng thanh toán hỗ trợ VNPAY-QR”</p>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Bước 3: Hệ thống hiển thị mã QR cùng với số tiền cần thanh
            toán,
            Quý khách kiểm tra lại số tiền này. Sử dụng ứng dụng ngân hàng (theo danh sách liệt kê), chọn “Quét Mã” và
            tiến
            hành quét mã QR trên màn hình thanh toán website
            *Lưu ý: Mã QR có hiệu lực trong 15 phút
            Để quá trình thanh toán thành công, khách hàng vui lòng tham khảo trước các điều kiện và thao tác quét mã
            trên
            điện thoại để sẵn sàng, tránh sự cố hết thời gian ảnh hưởng đến thanh toán và mã khuyến mại của quý khách.
        </p>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Bước 4: Kiểm tra thông tin, nhập mã giảm giá (nếu có) và
            hoàn
            tất thanh toán
            Khi thực hiện thanh toán hoàn tất Quý khách sẽ nhận được thông báo xác nhận đơn hàng đặt hàng thành công tại
            website</p>
        <div align="center">
            <p class="leading-7 [&amp;:not(:first-child)]:mt-4"><img class="rounded-md"
                    alt="Screenshot 2023-11-08 160417.png"
                    src="https://cdn.dev.nexbus.net/nexbus/91/Screenshot_2023_11_08_160417_568a37e887.png"></p>
        </div>
        <h5 class="leading-7 [&amp;:not(:first-child)]:mt-4"><strong>2. Phương thức thanh toán qua “Thẻ nội địa và tài
                khoản
                ngân hàng”</strong></h5>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Bước 1: Quý khách lựa chọn sản phẩm, dịch vụ và chọn Thanh
            toán
            ngay hoặc Đặt hàng
            Tại trang thanh toán, vui lòng kiểm tra lại sản phẩm đã đặt, điền đầy đủ thông tin người nhận hàng, chọn
            phương
            thức thanh toán VNPAY và nhấn nút “Đặt hàng ngay”.</p>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Bước 2: Màn hình thanh toán chuyển sang giao diện cổng thanh
            toán VNPAY. Chọn phương thức “Thẻ nội địa và tài khoản ngân hàng” và chọn ngân hàng muốn thanh toán thẻ
            trong
            danh sách</p>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Bước 3: Quý khách vui lòng thực hiện nhập các thông tin
            thẻ/tài
            khoản theo yêu cầu và chọn “Tiếp tục”. Mã OTP sẽ được gửi về điện thoại đăng ký, nhập mã OTP để hoàn tất
            giao
            dịch
            *Lưu ý: Giao dịch sẽ hết hạn sau 15 phút</p>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Bước 4: Khi thực hiện thanh toán hoàn tất Quý khách sẽ nhận
            được
            thông báo xác nhận đơn hàng đặt hàng thành công tại website</p>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4"><img class="rounded-md"
                alt="Screenshot 2023-11-08 160432.png"
                src="https://cdn.dev.nexbus.net/nexbus/be/Screenshot_2023_11_08_160432_4469867d6a.png"></p>
        <h5 class="leading-7 [&amp;:not(:first-child)]:mt-4"><strong>3. Phương thức thanh toán qua “Thẻ thanh toán quốc
                tế
                (Visa, MasterCard, JCB, UnionPay)”</strong></h5>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Tương tự như phương thức thanh toán “Thẻ nội địa và tài
            khoản
            ngân hàng”</p>
        <h5 class="leading-7 [&amp;:not(:first-child)]:mt-4"><strong>4. Phương thức thanh toán qua “Ví điện tử
                VNPAY”</strong></h5>
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">Tương tự như phương thức thanh toán “Ứng dụng thanh toán hỗ
            trợ
            VNPAY-QR”</p>
        <hr class="my-4 md:my-8">
        <p class="leading-7 [&amp;:not(:first-child)]:mt-4">KÊNH HỖ TRỢ</p>
        <ul class="my-6 ml-6 list-disc">
            <li class="mt-2">Tổng đài: *3388 hoặc 1900 55 55 77</li>
            <li class="mt-2">Zalo OA: zalo.me/4134983655549474109</li>
            <li class="mt-2">Email: hotro@vnpay.vn</li>
            <li class="mt-2">Fanpage: facebook.com/VNPAYQR.vn</li>
        </ul>
    </div>

    <script src="{{ asset('assets/vendors/bootstrap/dist/js/bootstrap.bundle.min.js') }}"></script>

</body>

</html>
