<style>
    /* CSS để tạo kiểu cho bản đồ */
    #map {
        height: 400px;
        width: 100%;
    }
</style>
<div class="text-center mb-3">
    <h3>Chọn một địa điểm trên bản đồ:</h3>
    <div id="map"></div>

    <p class="d-none">Kinh độ: <span id="latitude"></span></p>
    <p class="d-none">Vĩ độ: <span id="longitude"></span></p>
    <p class="d-none">Địa chỉ: <span id="address"></span></p>
</div>
@push('scripts')
    <script async defer
        src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAPS_API_KEY') }}&callback=initMap&libraries=places">
    </script>
    <script>
        let map, marker;
        let pub_latitude_map = null;
        let pub_longitude_map = null;
        let pub_address_map = null;

        function initMap() {
            // Tạo bản đồ với vị trí mặc định
            map = new google.maps.Map(document.getElementById('map'), {
                center: {
                    lat: 10.762622,
                    lng: 106.660172
                }, // Tọa độ trung tâm, có thể thay đổi
                zoom: 13
            });

            // Thêm một marker ban đầu vào trung tâm bản đồ
            marker = new google.maps.Marker({
                position: {
                    lat: 10.762622,
                    lng: 106.660172
                },
                map: map,
                draggable: true
            });

            // Lấy thông tin tọa độ khi di chuyển marker
            google.maps.event.addListener(marker, 'dragend', function() {
                let lat = marker.getPosition().lat();
                let lng = marker.getPosition().lng();

                document.getElementById('latitude').innerText = lat;
                document.getElementById('longitude').innerText = lng;

                // Gọi hàm để lấy địa chỉ
                getAddress(lat, lng);
            });

            // Lấy thông tin tọa độ khi click lên bản đồ
            google.maps.event.addListener(map, 'click', function(event) {
                let lat = event.latLng.lat();
                let lng = event.latLng.lng();

                marker.setPosition(event.latLng);

                pub_latitude_map = lat;
                pub_longitude_map = lng;

                document.getElementById('latitude').innerText = lat;
                document.getElementById('longitude').innerText = lng;

                // Gọi hàm để lấy địa chỉ
                getAddress(lat, lng);
            });
        }

        function updateMapApiGg(lat, lng) {

            let newPosition = new google.maps.LatLng(lat, lng);
            map.setCenter(newPosition);
            marker.setPosition(newPosition);

            document.getElementById('latitude').innerText = lat;
            document.getElementById('longitude').innerText = lng;

            pub_latitude_map = lat;
            pub_longitude_map = lng;

            getAddress(lat, lng);
        }

        function getAddress(lat, lng) {
            let geocoder = new google.maps.Geocoder();
            let latlng = new google.maps.LatLng(lat, lng);

            geocoder.geocode({
                'location': latlng
            }, function(results, status) {
                if (status === 'OK') {
                    if (results[0]) {
                        pub_address_map = results[0].formatted_address;
                    } else {
                        pub_address_map = 'Không tìm thấy địa chỉ';
                    }
                } else {
                    pub_address_map = 'Geocoder failed due to: ' + status;
                }
                document.getElementById('address').innerText = pub_address_map;

                if (document.getElementById('address_map_google')) {
                    document.getElementById('address_map_google').value = pub_address_map;
                }
            });
        }
    </script>
@endpush
