<style>
    /* CSS để tạo kiểu cho bản đồ */
    #map {
        height: 400px;
        width: 100%;
    }
</style>
<div class="text-center mb-3">
    <h3>Nhập địa chỉ để nhận gợi ý:</h3>
    <input class="form-control" id="autocomplete" placeholder="Nhập địa chỉ" type="text">

    <div id="map"></div>
    <p class="d-none">Kinh độ: <span id="latitude"></span></p>
    <p class="d-none">Vĩ độ: <span id="longitude"></span></p>
    <p class="d-none">Địa chỉ: <span id="address"></span></p>
</div>
@push('scripts')
    <script async defer
        src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAPS_API_KEY') }}&libraries=places&callback=initAutocomplete">
    </script>
    <script>
        let map, marker, autocomplete;
        let pub_latitude_map = null;
        let pub_longitude_map = null;
        let pub_address_map = null;

        function initAutocomplete() {
            // Tạo bản đồ mặc định
            map = new google.maps.Map(document.getElementById('map'), {
                center: {
                    lat: 10.762622,
                    lng: 106.660172
                },
                zoom: 13
            });

            marker = new google.maps.Marker({
                map: map
            });

            // Khởi tạo autocomplete và gắn vào input
            autocomplete = new google.maps.places.Autocomplete(document.getElementById('autocomplete'));
            autocomplete.setFields(['geometry', 'formatted_address']);
            autocomplete.addListener('place_changed', onPlaceChanged);
        }

        function onPlaceChanged() {
            let place = autocomplete.getPlace();

            if (!place.geometry) {
                alert("Không tìm thấy địa chỉ này. Vui lòng thử lại.");
                return;
            }

            let lat = place.geometry.location.lat();
            let lng = place.geometry.location.lng();

            map.setCenter(place.geometry.location);
            marker.setPosition(place.geometry.location);

            document.getElementById('latitude').innerText = lat;
            document.getElementById('longitude').innerText = lng;
        }

        function updateMapWithLatLng() {
            let lat = parseFloat(document.getElementById('lat').value);
            let lng = parseFloat(document.getElementById('lng').value);

            pub_latitude_map = lat;
            pub_longitude_map = lng;

            let newPosition = new google.maps.LatLng(lat, lng);
            map.setCenter(newPosition);
            marker.setPosition(newPosition);

            document.getElementById('latitude').innerText = lat;
            document.getElementById('longitude').innerText = lng;

            // Có thể gọi hàm getAddress để lấy địa chỉ từ tọa độ nếu cần
            getAddress(lat, lng);
        }

        function getAddress(lat, lng) {
            let geocoder = new google.maps.Geocoder();
            let latlng = new google.maps.LatLng(lat, lng);

            geocoder.geocode({
                'location': latlng
            }, function(results, status) {
                if (status === 'OK') {
                    if (results[0]) {
                        document.getElementById('autocomplete').value = results[0].formatted_address;
                    } else {
                        alert("Không tìm thấy địa chỉ");
                    }
                } else {
                    alert("Geocoder failed due to: " + status);
                }
            });
        }
    </script>
@endpush
