@push('scripts')
    <script src="{{ url('/get-google-maps-key') }}" async defer></script>

    <script>
        let map, marker, autocomplete;
        let pub_latitude_map = null;
        let pub_longitude_map = null;
        let pub_address_map = null;

        async function initAutocomplete() {
            // Tạo bản đồ mặc định
            if (!document.getElementById('map')) {
                return
            }

            map = new google.maps.Map(document.getElementById('map'), {
                center: {
                    lat: 10.762622,
                    lng: 106.660172
                },
                zoom: 13
            });

            marker = new google.maps.Marker({
                map: map,
                draggable: true
            });

            // Khởi tạo autocomplete và gắn vào input
            autocomplete = new google.maps.places.Autocomplete(document.getElementById('autocomplete'));
            autocomplete.setFields(['geometry', 'formatted_address']);
            autocomplete.addListener('place_changed', onPlaceChanged);

            // Cập nhật vị trí khi kéo thả marker
            google.maps.event.addListener(marker, 'dragend', function() {
                let lat = marker.getPosition().lat();
                let lng = marker.getPosition().lng();

                pub_latitude_map = lat;
                pub_longitude_map = lng;

                // Cập nhật input kinh độ, vĩ độ
                document.getElementById('lat').value = lat;
                document.getElementById('lng').value = lng;

                // Cập nhật địa chỉ trong trường nhập
                getAddress(lat, lng);
            });

            // Cập nhật vị trí khi nhấp vào bản đồ
            google.maps.event.addListener(map, 'click', function(event) {
                let lat = event.latLng.lat();
                let lng = event.latLng.lng();

                marker.setPosition(event.latLng);

                pub_latitude_map = lat;
                pub_longitude_map = lng;

                document.getElementById('lat').value = lat;
                document.getElementById('lng').value = lng;

                getAddress(lat, lng);
            });
        }

        async function onPlaceChanged() {
            let place = autocomplete.getPlace();

            if (!place.geometry) {
                alert("Không tìm thấy địa chỉ này. Vui lòng thử lại.");
                return;
            }

            let lat = place.geometry.location.lat();
            let lng = place.geometry.location.lng();

            map.setCenter(place.geometry.location);
            marker.setPosition(place.geometry.location);

            pub_latitude_map = lat;
            pub_longitude_map = lng;

            document.getElementById('lat').value = lat;
            document.getElementById('lng').value = lng;
        }

        async function updateMapWithLatLng(_lat = null, _lng = null) {
            if (_lat && _lng) {
                document.getElementById('lat').value = _lat;
                document.getElementById('lng').value = _lng;
            }
            let lat = _lat ? _lat : parseFloat(document.getElementById('lat').value);
            let lng = _lng ? _lng : parseFloat(document.getElementById('lng').value);

            let newPosition = new google.maps.LatLng(lat, lng);
            map.setCenter(newPosition);
            marker.setPosition(newPosition);

            pub_latitude_map = lat;
            pub_longitude_map = lng;


            // Cập nhật địa chỉ trong trường nhập
            getAddress(lat, lng);
        }

        async function getAddress(lat, lng) {
            let geocoder = new google.maps.Geocoder();
            let latlng = new google.maps.LatLng(lat, lng);

            geocoder.geocode({
                'location': latlng
            }, function(results, status) {
                if (status === 'OK') {
                    if (results[0]) {
                        pub_address_map = results[0].formatted_address;
                        document.getElementById('autocomplete').value = results[0].formatted_address;
                    } else {
                        alert("Không tìm thấy địa chỉ");
                    }
                } else {
                    alert("Geocoder failed due to: " + status);
                }
            });
        }
    </script>
@endpush
