<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #000;
            /* Đường viền cho ô */
            padding: 8px;
            /* Khoảng cách giữa nội dung và viền */
            text-align: left;
            /* Canh trái cho nội dung */
        }

        th {
            background-color: #007D88;
            /* Màu nền cho header */
            color: #fff;
            /* Màu chữ cho header */
            font-weight: bold;
            /* In đậm cho header */
        }
    </style>
</head>

<body>
    <table>
        <thead>
            <tr>
                <th style="font-weight: bold; background-color: #00bbff;">STT</th>
                <th style="font-weight: bold; background-color: #00bbff;">Date</th>
                <th style="font-weight: bold; background-color: #00bbff;">Account number</th>
                <th style="font-weight: bold; background-color: #00bbff;">Người gửi</th>
                <th style="font-weight: bold; background-color: #00bbff;">Dịch vụ</th>
                <th style="font-weight: bold; background-color: #00bbff;">AWB</th>
                <th style="font-weight: bold; background-color: #00bbff;">HAWB</th>
                <th style="font-weight: bold; background-color: #00bbff;">Tracking number</th>
                <th style="font-weight: bold; background-color: #00bbff;">Người nhận</th>
                <th style="font-weight: bold; background-color: #00bbff;">Country</th>
                <th style="font-weight: bold; background-color: #00bbff;">Dest</th>
                <th style="font-weight: bold; background-color: #00bbff;">Tổng Package</th>
                <th style="font-weight: bold; background-color: #00bbff;">Charge Weight</th>
                <th style="font-weight: bold; background-color: #00bbff;">Giá trị</th>
                <th style="font-weight: bold; background-color: #00bbff;">Phụ thu</th>
                <th style="font-weight: bold; background-color: #00bbff;">Vat</th>
                <th style="font-weight: bold; background-color: #00bbff;">Tổng tiền</th>
                <th style="font-weight: bold; background-color: #00bbff;">Hàng hóa phụ thu</th>
                <th style="font-weight: bold; background-color: #00bbff;">Gross Weight</th>
                <th style="font-weight: bold; background-color: #00bbff;">Debit no</th>
                <th style="font-weight: bold; background-color: #00bbff;">Công nợ</th>
                <th style="font-weight: bold; background-color: #00bbff;">Trạng thái</th>
                <th style="font-weight: bold; background-color: #00bbff;">MAWB</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data_excel as $key => $row)
                @php
                    $packages_des = getDescriptionPackageByShipment($row['shipment_id'], 'hawb');
                    $package_tracking = getDescriptionPackageByShipment($row['shipment_id'], 'tracking');
                    $package_sgs = getDescriptionGoodsByShipment($row['shipment_id']);
                    
                    $mawbs = getMawbByShipment($row['shipment_id']);
                    $awb_codes = [];
                    $dests = [];
                    if (!empty($mawbs)) {
                        $awb_codes = collect($mawbs)->pluck('awb_code');
                        $dests = collect($mawbs)->pluck('dest');
                    }

                @endphp
                <tr>
                    <td>{{ $key + 1 }}</td>
                    <td>{{ formatFullDate($row['created_at']) }}</td>
                    <td>{{ $row['user_code'] }}</td>
                    <td>{{ $row['sender_contact_name'] }}</td>
                    <td>{{ $row['service_name'] }}</td>

                    <td>{{ $row['shipment_code'] }}</td>
                    <td>
                        @foreach ($packages_des as $hawb)
                            <p>{{ $hawb }}</p>
                        @endforeach
                    </td>
                    <td>
                        @foreach ($package_tracking as $tracking)
                            <p>{{ $tracking }}</p>
                        @endforeach
                    </td>

                    <td>{{ $row['receiver_contact_name'] }}</td>
                    <td>{{ $row['country_name'] }}</td>
                    <td>
                        @foreach ($dests as $dest)
                            <p>{{ $dest }}</p>
                        @endforeach
                    </td>

                    <td>{{ $row['package_count'] }}</td>
                    <td>{{ $row['charged_weight'] }}</td>
                    <td>{{ $row['total_value'] }}</td>

                    <td>
                        @php
                            $total_pg_sgs = 0;
                            foreach ($package_sgs as $key => $sgs1) {
                                $total_pg_sgs += $sgs1['price'] * $sgs1['count'];
                            }
                            $total_pg_sgs += $row['shipment_amount_fsc'];
                        @endphp
                        {{ $total_pg_sgs }}
                    </td>

                    <td>{{ $row['shipment_amount_vat'] }}</td>
                    <td>{{ $row['shipment_final_amount'] + $row['shipment_amount_fsc'] }}</td>

                    <td>
                        @foreach ($package_sgs as $sgs)
                            {{ $sgs['surcharge_goods_name'] ?? $sgs['external_surcharge_name'] }}/{{ formatNumber($sgs['price']) }}
                            [{{ $sgs['count'] }}],
                            <br>
                        @endforeach

                        @if ($row['shipment_amount_fsc'] > 0)
                            phí fcs [{{ $row['shipment_amount_fsc'] }}]
                        @endif
                    </td>
                    <td>{{ $row['gross_weight'] }}</td>
                    <td>{{ $row['debit_no'] }}</td>
                    <td>{{ $row['debit_type_label'] }}</td>
                    <td>{{ $row['shipment_payment_status_label'] }}</td>
                    {{-- <td>{{ $row['shipment_status_name'] }}</td> --}}

                    <td>
                        @foreach ($awb_codes as $awb_code)
                            <p>{{ $awb_code }}</p>
                        @endforeach
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
