<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>{{ $meta['title'] ?? 'Kango' }}</title>

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="keywords" content="{{ isset($meta['keywords']) ? $meta['keywords'] : '' }}">
    <meta name="description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}">
    <meta property="og:title" content="{{ isset($meta['title']) ? $meta['title'] : '' }}" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="{{ isset($meta['url']) ? $meta['url'] : '' }}" />
    <meta property="og:image" content="{{ isset($meta['image']) ? $meta['image'] : '' }}" />
    <meta property="og:description" content="{{ isset($meta['description']) ? $meta['description'] : '' }}" />
    <meta property="og:site_name" content="{{ isset($meta['site_name']) ? $meta['site_name'] : '' }}" />

    <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
    <link rel="icon" href="{{ asset('assets/images/favicon.ico') }}" type="image/x-icon">
    <link href="{{ asset('assets/boxicons/css/boxicons.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/vendors/daterangepicker/daterangepicker.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/dist/css/style.css') }}" rel="stylesheet" type="text/css">

</head>

<body>

    <div class="hk-wrapper" data-layout="vertical" data-layout-style="default" data-menu="light" data-footer="simple">
        <div class="hk-pg-wrapper">
            <div class="container-xxl">
                <!-- Page Body -->
                <div class="hk-pg-body">
                    <div class="row">
                        <div class="col-xl-7 col-lg-6 d-lg-block d-none">
                            <div class="auth-content py-md-0 py-8">
                                <div class="row">
                                    <div class="col-xl-12 text-center">
                                        <img src="{{ asset('assets/dist/img/macaroni-fatal-error.png') }}"
                                            class="img-fluid w-sm-80 w-50" alt="login" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-6 col-md-7 col-sm-10">
                            <div class="auth-content py-md-0 py-8">
                                <div class="w-100">
                                    <div class="row">
                                        <div class="col-xxl-9 col-xl-8 col-lg-11">
                                            <h1 class="display-4 fw-bold mb-2" style="font-size: 70px">
                                                {{ $status }}</h1>
                                            <p class="p-lg">{{ $message }}</p>
                                            <a href="{{ url()->previous() }}" class="btn btn-primary mt-4">Trở về</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Page Body -->
            </div>

        </div>

    </div>

    <script src="{{ asset('assets/vendors/bootstrap/dist/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/dist/js/feather.min.js') }}"></script>
    <script src="{{ asset('assets/dist/js/dropdown-bootstrap-extended.js') }}"></script>
    <script src="{{ asset('assets/vendors/simplebar/dist/simplebar.min.js') }}"></script>
</body>

</html>
