@foreach ($tickets as $ticket)
    <li class="list-group-item">
        <div id="active_ticket_{{ $ticket['ticket_id'] }}" class="media">
            <div class="media-head" onclick="selectedTicket('{{ $ticket['ticket_id'] }}')">
                <div class="avatar avatar-sm avatar-primary position-relative avatar-rounded">
                    <span class="initial-wrap">{{ customTextAvatar($ticket['user']['user_contact_name']) }}</span>
                </div>
            </div>
            <div class="media-body">
                <div onclick="selectedTicket('{{ $ticket['ticket_id'] }}')">
                    <div class="user-name">{{ $ticket['ticket_title'] }}</div>
                    <div id="user_last_chat_{{ $ticket['ticket_id'] }}" class="user-last-chat">
                        {{ isset($ticket['ticketMessage']['answer_id']) ? 'Tôi:' : '' }}
                        {{ $ticket['ticketMessage']['ticket_message_content'] }}
                    </div>
                </div>
                <div>
                    <div class="btn-group dropdown">
                        <button type="button" class="btn btn-icon btn-flush-dark btn-rounded dropdown-toggle no-caret"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span style="z-index: 999">...</span>
                        </button>
                        <div class="dropdown-menu w-210p">
                            @foreach ($arr_status as $key_status => $status)
                                @if ($ticket['ticket_status'] != $key_status)
                                    <div class="dropdown-item">
                                        <button type="button" class="btn btn-sm btn-soft-primary btn-wth-icon btn-block"
                                            onclick="onChangeTicketStatus('{{ $ticket['ticket_id'] }}', '{{ $key_status }}', '{{ $ticket['ticket_status'] }}')">
                                            <span>
                                                <span class="icon">
                                                    <span class="feather-icon">
                                                        <i data-feather="circle"></i>
                                                    </span>
                                                </span>
                                                <span class="btn-text">
                                                    {{ $status }}
                                                </span>
                                            </span>
                                        </button>
                                    </div>
                                @endif
                            @endforeach
                            @if ($ticket['ticket_status'] == TICKET_STATUS_DONE)    
                                <div class="dropdown-item">
                                    <button type="button" class="btn btn-sm btn-soft-primary btn-wth-icon btn-block btn-add-note-ticket"
                                        data-ticket_id="{{ $ticket['ticket_id'] }}" data-ticket_note="{{ $ticket['ticket_note'] }}">
                                        <span>
                                            <span class="icon">
                                                <span class="feather-icon">
                                                    <i data-feather="edit-3"></i>
                                                </span>
                                            </span>
                                            <span class="btn-text">
                                                Cập nhật ghi chú
                                            </span>
                                        </span>
                                    </button>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </li>
@endforeach