@foreach ($tickets as $ticket)
    <div class="card mb-3" onclick="onGetTicketDetail('{{ $ticket['ticket_id'] }}')" style="cursor: pointer">
        <div class="card-body p-2">
            <div class="d-flex justify-content-start align-items-center">
                <div class="me-2">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="-0.5 -0.5 16 16" id="Ticket-Coupon--Streamline-Atlas"
                        height="25" width="25">
                        <desc>Ticket Coupon Streamline Icon: https://streamlinehq.com</desc>
                        <defs></defs>
                        <g id="coupon">
                            <path
                                d="M14.0625 2.725v9.549999999999999h-13.125v-2.9875000000000003a1.7874999999999999 1.7874999999999999 0 0 0 0 -3.5749999999999997V2.725Z"
                                stroke-linecap="square" fill="none" stroke="#000000" stroke-miterlimit="10"
                                stroke-width="1"></path>
                            <path d="M12.275 5.1125Z" fill="none" stroke="#000000" stroke-miterlimit="10"
                                stroke-width="1"></path>
                            <path d="M12.275 7.5Z" fill="none" stroke="#000000" stroke-miterlimit="10"
                                stroke-width="1"></path>
                            <path d="m5.1125 5.1125 1.1937499999999999 0" fill="none" stroke="#000000"
                                stroke-miterlimit="10" stroke-width="1"></path>
                            <path d="m5.1125 7.5 1.1937499999999999 0" fill="none" stroke="#000000"
                                stroke-miterlimit="10" stroke-width="1"></path>
                            <path d="m5.1125 9.8875 1.1937499999999999 0" fill="none" stroke="#000000"
                                stroke-miterlimit="10" stroke-width="1"></path>
                        </g>
                    </svg>
                </div>
                <div class="">
                    <div class="fw-bold">{{ Str::limit($ticket['ticket_title'], 50, '...') }}</div>
                    <div>{{ formatFullDate($ticket['created_at']) }}</div>
                    @if ($ticket['ticket_status'] == TICKET_STATUS_DONE)    
                        <div>
                            Note: {{ Str::limit($ticket['ticket_note'], 50, '...') }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endforeach
