<li class="media">
    <div class="media-body">
        <h5>{!! $ticket['ticket_title'] !!}</h5>
        <div>Mã kiểm tra</div>
        <div>{{ isset($ticket['ticket_transaction_code']) ? $ticket['ticket_transaction_code'] : '---' }}</div>
        @if ($ticket['ticket_status'] == TICKET_STATUS_DONE)    
            <div>
                Note: {{ isset($ticket['ticket_note']) ? $ticket['ticket_note'] : '---' }}
            </div>
        @endif
    </div>
</li>
<li class="day-sep">
    <span>Nội dung</span>
</li>
@foreach ($ticket['ticketMessages'] as $message)
    @if (isset($message['sender_id']) && $message['ticket_type'] == TICKET_TYPE_TEXT)
        <li class="media sent">
            <div class="media-body">
                <div class="msg-box">
                    <div>
                        <p>{!! $message['ticket_message_content'] !!}</p>
                        <span class="chat-time">{{ formatFullDate($message['created_at']) }}</span>
                    </div>
                </div>
            </div>
        </li>
    @elseif (isset($message['sender_id']) && $message['ticket_type'] == TICKET_TYPE_FILE)
        @php
            $file = checkFileInfo($message['ticket_message_content']);
        @endphp
        @if (isset($file))
            <li class="media media-attachment sent">
                <div class="media-body {{ $file['is_image'] ? 'msg-imgs' : 'msg-docs' }}">
                    <div class="msg-box">
                        <div>
                            @if ($file['is_image'])
                                <img class="d-block img-fluid" src="{{ asset($message['ticket_message_content']) }}"
                                    alt="{{ $file['extension'] }}">
                            @else
                                <div class="media">
                                    <div class="avatar avatar-icon avatar-sm avatar-blue">
                                        <span class="initial-wrap fs-3">
                                            <i class="{{ $file['icon'] }}"></i>
                                        </span>
                                    </div>
                                    <div class="media-body">
                                        <p class="file-name">{{ $file['name'] }}</p>
                                        <p class="file-size">{{ formatNumber($file['size']) }} KB</p>
                                    </div>
                                </div>
                            @endif
                            <div class="file-overlay">
                                <a href="{{ asset($message['ticket_message_content']) }}" download
                                    class="btn btn-sm btn-icon btn-rounded btn-secondary">
                                    <span class="icon">
                                        <span class="feather-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-arrow-down">
                                                <line x1="12" y1="5" x2="12" y2="19"></line>
                                                <polyline points="19 12 12 19 5 12"></polyline>
                                            </svg>
                                        </span>
                                    </span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </li>
        @endif
    @elseif (isset($message['answer_id']) && $message['ticket_type'] == TICKET_TYPE_TEXT)
        <li class="media received">
            <div class="avatar avatar-xs avatar-rounded">
                <div class="avatar-img">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 48 48"
                        id="Customer-Support-7--Streamline-Plump" height="30" width="30">
                        <desc>Customer Support 7 Streamline Icon: https://streamlinehq.com</desc>
                        <g id="customer-support-7--customer-headphones-help-microphone-person-profile-support">
                            <path id="Union" fill="#8fbffa"
                                d="M38.975 20.553C38.483 11.328 30.847 4 21.5 4 11.835 4 4 11.835 4 21.5c0 5.725 2.75 10.809 7 14.001v7.866c0 0.828 0.669 1.5 1.497 1.5h18.005c0.828 0 1.498 -0.672 1.498 -1.5v-3.692l2.668 0.45a3 3 0 0 0 3.488 -2.707l0.574 -6.812c1.85 -0.415 3.18 -1.084 4.043 -1.642 0.774 -0.5 0.864 -1.51 0.348 -2.274l-4.146 -6.137Z"
                                stroke-width="3"></path>
                            <path id="Union_2" fill="#ffffff"
                                d="M17.023 14.057a8 8 0 1 0 7.954 0C24.99 13.177 25 12.16 25 11c0 -2.551 -0.044 -4.405 -0.09 -5.645 -0.043 -1.2 -0.854 -2.187 -2.05 -2.285A23.72 23.72 0 0 0 21 3c-0.732 0 -1.35 0.029 -1.86 0.07 -1.196 0.098 -2.007 1.085 -2.05 2.285C17.043 6.595 17 8.449 17 11c0 1.16 0.009 2.177 0.023 3.057Z"
                                stroke-width="3"></path>
                            <path id="Union_3" stroke="#2859c5" stroke-linecap="round" stroke-linejoin="round"
                                d="M30.24 6.212c0.258 0.142 0.511 0.29 0.76 0.444 4.937 3.058 8.238 8.46 8.313 14.63l3.747 5.223c0.563 0.785 0.465 1.846 -0.363 2.344 -0.83 0.5 -2.063 1.084 -3.734 1.488l-0.566 6.718a3 3 0 0 1 -3.358 2.725l-2.8 -0.346V43a2 2 0 0 1 -1.998 2H13.014a2 2 0 0 1 -1.999 -2v-7.5c-4.295 -3.192 -7.075 -8.275 -7.075 -14 0 -6.26 3.321 -11.75 8.315 -14.844"
                                stroke-width="3"></path>
                            <path id="Union_4" stroke="#2859c5" stroke-linecap="round" stroke-linejoin="round"
                                d="M17.023 14.057a8 8 0 1 0 7.954 0C24.99 13.177 25 12.16 25 11c0 -2.551 -0.044 -4.405 -0.09 -5.645 -0.043 -1.2 -0.854 -2.187 -2.05 -2.285A23.72 23.72 0 0 0 21 3c-0.732 0 -1.35 0.029 -1.86 0.07 -1.196 0.098 -2.007 1.085 -2.05 2.285C17.043 6.595 17 8.449 17 11c0 1.16 0.009 2.177 0.023 3.057Z"
                                stroke-width="3"></path>
                            <path id="Vector 1494" stroke="#2859c5" stroke-linecap="round" stroke-linejoin="round"
                                d="M21 29c3 3 7.6 5 12 5" stroke-width="3"></path>
                        </g>
                    </svg>
                </div>
            </div>
            <div class="media-body">
                <div class="msg-box">
                    <div>
                        <p>{!! $message['ticket_message_content'] !!}</p>
                        <span class="chat-time">{{ formatFullDate($message['created_at']) }}</span>
                    </div>
                </div>
            </div>
        </li>
    @endif
@endforeach
