@extends('layouts.app')
@section('content')
    <!-- Main Content -->
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="chatapp-wrap chatapp-info-active border-top">
                <div class="chatapp-content">
                    <div class="chatapp-aside">
                        <div data-simplebar class="aside-body">
                            <form class="aside-search" role="search">
                                <ul class="nav nav-light nav-pills mt-3 mb-3 fs-8" role="tablist">
                                    <li class="nav-item" role="presentation"
                                        onclick="getTickets('{{ TICKET_STATUS_PENDING }}')">
                                        <a class="nav-link border position-relative active" data-bs-toggle="tab"
                                            href="#tab_ticket_no_process" aria-selected="false" tabindex="-1"
                                            role="tab">
                                            <span class="nav-link-text">
                                                Chưa xử lý
                                            </span>
                                            @if ($total_tickets_pending > 0)
                                                <span id="total_tickets_pending"
                                                    class="badge badge-danger badge-sm badge-pill position-top-end-overflow">
                                                    {{ $total_tickets_pending > 9 ? '9+' : $total_tickets_pending }}
                                                </span>
                                            @endif
                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation"
                                        onclick="getTickets('{{ TICKET_STATUS_PROCESSING }}')">
                                        <a class="nav-link border position-relative" data-bs-toggle="tab"
                                            href="#tab_ticket_waiting" aria-selected="true" role="tab">
                                            <span class="nav-link-text">Đang xử lý</span>
                                            @if ($total_tickets_processing > 0)
                                                <span id="total_tickets_processing"
                                                    class="badge badge-danger badge-sm badge-pill position-top-end-overflow">
                                                    {{ $total_tickets_processing > 9 ? '9+' : $total_tickets_processing }}
                                                </span>
                                            @endif
                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation"
                                        onclick="getTickets('{{ TICKET_STATUS_DONE }}')">
                                        <a class="nav-link border" data-bs-toggle="tab" href="#tab_ticket_processed"
                                            aria-selected="false" tabindex="-1" role="tab">
                                            <span class="nav-link-text">Đã xong</span>
                                        </a>
                                    </li>
                                </ul>
                            </form>
                            <ul class="chat-contacts-list list-group list-group-flush" id="form_tickets_list"></ul>
                        </div>
                    </div>
                    <div class="chatapp-single-chat">
                        <div class="vh-100 d-flex justify-content-center align-items-center">
                            <h5>Chưa có ticket được chọn</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    <!-- /Main Content -->

    <!-- Modal Add Note Ticket -->
    <div class="modal fade" id="modalAddNoteTicket" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="modalAddNoteTicketLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="modalAddNoteTicketLabel">
                        Cập nhật ghi chú ticket
                    </h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="ticket_note" class="form-label">Ghi chú *</label>
                        <textarea class="form-control" id="ticket_note" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Đóng
                    </button>
                    <button type="button" class="btn btn-primary" id="save_ticket_note">
                        Lưu ghi chú
                    </button>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('js/supports/tickets/main.js') }}"></script>
    @endpush
@endsection
