<div class="">
    <!-- Modal -->
    <div class="modal fade" id="cityWorldModal" tabindex="-1" aria-labelledby="cityWorldModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h1 class="modal-title fs-5 text-white" id="cityWorldModalLabel">Khu vực (state)</h1>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="input-group mb-3">
                        <input type="text" class="form-control" placeholder="Nhấn enter để tìm kiếm"
                            id="keywords_city_world">
                        <button class="btn btn-info" type="button" onclick="fetchDataCitiesWorld()"><i
                                class="fas fa-search"></i></button>
                    </div>
                    <div class="" id="bodyCityWorldModal"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <script>
        let pub_city_world_page = 1;
        let pub_city_world_limit = 10;
        let pub_state_id_for_modal = null;

        $(document).on('click', '#paginate-state .pagination a', function(event) {
            event.preventDefault();
            pub_state_page = $(this).attr('href').split('page=')[1];
            fetchDataCitiesWorld();
        });

        $('#keywords_city_world').on('keypress', function(e) {
            if (e.which === 13) { // 13 là mã ASCII của phím Enter
                pub_state_page = 1
                fetchDataCitiesWorld();
            }
        })

        function fetchDataCitiesWorld() {
            const url = window.location.origin + '/states-by-country';
            const data = {
                is_html: true,
                paginate: {
                    page: pub_state_page,
                    limit: pub_state_limit,
                },
                keywords: $('#keywords_city_world').val(),
                country_id: pub_country_id_for_modal,
                state_id: pub_state_id_for_modal,
            }
            ajaxPostHTML(url, data, 'bodyCityWorldModal');
        }
    </script>
@endpush
