@extends('layouts.app')
@section('content')
    <!-- Main Content -->
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <nav class="contactapp-sidebar">
                    <div data-simplebar class="nicescroll-bar">
                        <div class="menu-content-wrap">
                            <h3 class="mb-3">Gửi SMS CSKH Chúc Mừng Ngày Lễ</h3>
                            <div class="card-body">
                                Mẫu tin :
                                <p style="">
                                    KIKI CO.LTD xin tran trong cam on Quy khach da tin tuong san
                                    pham va dich vu cua chung toi. Nhan dip
                                    <u class="text-info">{Tên ngày lễ tối đa 20 ký tự} </u>,
                                    KIKI CO.LTD kinh chuc
                                    <u class="text-info">{Lời chúc tối đa 80 ký tự}</u>
                                </p>
                                <div class="form-group mt-3">
                                    <label class="fw-bold">Tên ngày lễ
                                        <span class="text-danger fw-normal" style="font-size: 12px">
                                            ( Tối đa 20 ký tự ghi thường không dấu)
                                        </span>
                                    </label>
                                    <input type="text" name="holiday_name" class="form-control"
                                        placeholder="Nhập tên ngày lễ">
                                </div>
                                <div class="form-group mt-3">
                                    <label class="fw-bold">Lời chúc
                                        <span class="text-danger fw-normal" style="font-size: 12px">
                                            (Tối đa 80 ký tự ghi thường không dấu)
                                        </span>
                                    </label>
                                    <input type="text" name="congratulation" class="form-control"
                                        placeholder="Nhập lời chúc">
                                </div>

                                <div class="form-group mt-3">
                                    <label class="form-label">Số điện thoại test tin nhắn </label>
                                    <input type="number" name="phone_test" class="form-control">
                                </div>
                                <div class="form-group mt-3">
                                    <button type="button" class="btn btn-info btn-sm w-100" id="send-sms-holiday-test">
                                        Gửi tin nhắn test
                                    </button>
                                    <span class="fst-italic text-danger fs-8">
                                        *Nên sử dụng test tin nhắn trước khi chọn gửi toàn bộ khách hàng
                                    </span>
                                </div>
                            </div>
                            <p class="fst-italic text-danger fs-8">*Tất khách hàng được chọn sẽ nhận được tin nhắn</p>
                            <div class="text-center">
                                <button id="send-sms-holiday" type="button" class="btn btn-primary btn-rounded w-100">
                                    Gửi tin nhắn
                                </button>
                            </div>
                        </div>
                    </div>
                </nav>
                <div class="contactapp-content">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="my-3 ">
                                    <a class="contactapp-title link-dark">
                                        <h1 class="me-1">Danh sách đã gửi thành công</h1>
                                    </a>
                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                <div class="v-separator d-lg-block d-none"></div>
                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                            <div class="hk-sidebar-togglable"></div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="contact-list-view">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="form-label">Số lượng</label>
                                                <select class="form-control" id="limit-send-sms-holiday">
                                                    <option value="10">10</option>
                                                    <option value="20" selected>20</option>
                                                    <option value="50">50</option>
                                                    <option value="100">100</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="form-label">Tìm kiếm</label>
                                                <input type="text" class="form-control" id="search-send-sms-holiday"
                                                    placeholder="Nhập nội dung bạn muốn tìm kiếm">
                                            </div>
                                        </div>
                                    </div>
                                    <div id="table-users-send-sms-holiday" class="table-responsive"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')
        <script src="{{ asset('js/sms/send-sms.js') }}"></script>
    @endpush
@endsection
