@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="hk-pg-header pg-header-wth-tab">
                <div class="d-flex align-items-center justify-content-between">
                    <div class="dropdown">
                        <a class="contactapp-title link-dark">
                            <h1>Sms manager</h1>
                        </a>
                    </div>
                    <div class="integrations-options-wrap justify-content-end flex-1 d-md-flex d-none">
                        <a href="{{ route('sms-manager.send-sms') }}" class="btn btn-primary btn-sm">
                            <span>
                                <span class="icon"><i class="fas fa-comment-alt"></i></span>
                                <span>Gửi tin nhắn CSKH</span>
                            </span>
                        </a>
                        <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover hk-navbar-togglable"
                            href="#" data-bs-toggle="tooltip" data-bs-placement="top" title=""
                            data-bs-original-title="">
                            <span class="icon">
                                <span class="feather-icon"><svg xmlns="http://www.w3.org/2000/svg" width="24"
                                        height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="feather feather-chevron-up">
                                        <polyline points="18 15 12 9 6 15"></polyline>
                                    </svg></span>
                                <span class="feather-icon d-none"><svg xmlns="http://www.w3.org/2000/svg" width="24"
                                        height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="feather feather-chevron-down">
                                        <polyline points="6 9 12 15 18 9"></polyline>
                                    </svg></span>
                            </span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="hk-pg-body h-100">
                <div data-simplebar class="nicescroll-bar">
                    <div class="contact-list-view">
                        <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                            <div class="row">
                                <div class="col-7 mb-3">
                                    <div class="contact-toolbar-left">
                                        <ul class="nav nav-line nav-tabs nav-icon nav-light flex-shrink-0 px-2"
                                            role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <a class="d-flex align-items-center h-100 nav-link active"
                                                    onclick="setIsBillCode(false)" data-bs-toggle="tab" href="#history"
                                                    aria-selected="true" role="tab">
                                                    <span class="nav-link-text">LỊCH SỬ GỬI TIN NHẮN</span>
                                                </a>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <a class="d-flex align-items-center h-100 nav-link" data-bs-toggle="tab"
                                                    onclick="setIsBillCode(true)" href="#bill_used" aria-selected="false"
                                                    role="tab" tabindex="-1">
                                                    <span class="nav-link-text">DANH SÁCH BILL SỬ DỤNG</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-5 mb-3">
                                    <div class="contact-toolbar-right justify-content-end">
                                        <div id="" class=""><label><input type="search"
                                                    class="form-control form-control" id="keywords"
                                                    placeholder="Search"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="history">
                                    <div class="" id="content_history">

                                    </div>
                                </div>
                                <div class="tab-pane fade" id="bill_used">
                                    <div class="" id="content_bill_used">

                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>
            </div>

        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')
        <script>
            // Hàm mở modal
            function openModal() {
                $('#rulesModal').modal('show');
            }
            $(".select2").select2();


            function onDelete() {
                Swal.fire({
                    title: "Bạn có chắc chắn?",
                    text: "Bạn có muốn ẩn đối tượng này không",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Có",
                    cancelButtonText: "Không"
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: "Deleted!",
                            text: "Your file has been deleted.",
                            icon: "success"
                        });
                    }
                });
            }
        </script>

        <script src="{{ asset('js/sms/index.js') }}"></script>
    @endpush
@endsection
