<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>ID Bill </th>
                <th>Ngày</th>
                <th>Chi nhánh</th>
                <th>Dịch vụ</th>
                <th>Người nhận</th>
                <th>Trạng thái</th>
            </tr>
        </thead>
        <tbody>
            @php
                $colors = ['secondary', 'info', 'success', 'danger', 'danger'];
            @endphp
            @foreach ($shipments as $key => $shipment)
                @php
                    $checked = onCheckAcctionShipment($shipment, auth()->user());
                @endphp
                <tr class="odd">
                    <td>
                        <button id="btn_shipment_{{ $key }}" onclick="showShipmentDetail('{{ $key }}')"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#shipment_{{ $key }}"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="{{ route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']]) }}">
                            {{ $shipment['shipment_code'] }}
                        </a>
                        @if (isGetAllData() && isset($shipment['created_lable_at']))
                            <button class="btn btn-icon btn-soft-info btn-animated btn-sm ms-3"><span class="icon">
                                    <i class="fas fa-exclamation"></i></span></button>
                        @endif
                    </td>
                    <td>{{ formatFullDate($shipment['created_at']) }}</td>
                    <td class="align-items-center">
                        {{ $shipment['branch']['branch_name'] }}
                    </td>
                    <td>
                        {{ $shipment['service']['service_name'] }}
                    </td>
                    <td>{{ $shipment['receiver_contact_name'] }}</td>
                    <td>
                        <small class="badge badge-{{ $colors[$shipment['shipment_status']] }}">
                            {{ $shipment['shipment_status_name'] }}
                        </small>
                    </td>
                </tr>
                <tr class="child collapse" id="shipment_{{ $key }}">
                    <td class="child" colspan="7">
                        <ul>
                            <li class="mb-3">
                                <span class="dtr-title">Addresss: </span>
                                <span class="dtr-data">
                                    [ <a href="{{ getUrlTracking($shipment['shipment_code']) }}" target="_blank">
                                        <i class="fas fa-map-marker-alt"></i></a>
                                    <b> {{ $shipment['country']['country_name'] }}</b>]
                                    - {{ $shipment['receiver_address_1'] }}
                                </span>
                            </li>
                            @if (!onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id']))
                                <li class="mb-3">
                                    <span class="dtr-title">TK tạo: </span>
                                    <span class="dtr-data">
                                        @include('components.badges-position-name', [
                                            'position_id' => $shipment['user']['position_id'],
                                        ])
                                        {{ $shipment['user']['user_contact_name'] }}
                                    </span>
                                </li>
                            @endif
                            <li class="mb-3">
                                <span class="dtr-title">Ref Code: </span>
                                <span class="dtr-data">{{ $shipment['shipment_reference_code'] }}</span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Status: </span>
                                <span class="dtr-data">
                                    <small class="badge badge-{{ $colors[$shipment['shipment_status']] }}">
                                        {{ $shipment['shipment_status_name'] }}
                                    </small>
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Thanh toán: </span>
                                <span
                                    class="dtr-data fw-bold text-{{ $shipment['shipment_payment_status'] == 0 ? 'danger' : 'success' }}">
                                    {{ $shipment['shipment_payment_status'] == 0 ? 'Chưa thanh toán' : 'Đã thanh toán' }}
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Duyệt xuất: </span>
                                @if ($shipment['accountant_status'] == 0)
                                    <span class="dtr-data fw-bold text-secondary">
                                        Đang chờ xác nhận
                                    </span>
                                @elseif($shipment['accountant_status'] == 1)
                                    <span class="dtr-data fw-bold text-success">
                                        Đã xác nhận
                                    </span>
                                @else
                                    <span class="dtr-data fw-bold text-danger">
                                        Đã hủy đơn
                                    </span>
                                    <p><strong>Nguyên nhân hủy: </strong>{{ $shipment['accountant_cancel_note'] }}</p>
                                @endif
                            </li>
                            @if (!onCheckIsEpacket($shipment['shipment_service_id']) && isGetAllData())
                                <li class="mb-3">
                                    <span class="dtr-title">Admin duyệt: </span>
                                    <span
                                        class="dtr-data fw-bold text-{{ $shipment['checked_payment_status'] == 0 ? 'warning' : 'success' }}">
                                        {{ $shipment['checked_payment_status'] == 0 ? 'Chưa duyệt' : 'Đã duyệt' }}
                                    </span>
                                    @if (!isset($shipment['checked_payment']['checked']) && $shipment['checked_payment_status'] == 1)
                                        <span>
                                            <i title="Đơn duyệt thông qua Debit/Statement"
                                                class="fas fa-exclamation-circle text-warning"></i>
                                        </span>
                                    @endif
                                </li>
                            @endif
                            <li>
                                <span class="dtr-title"></span>
                                <span class="dtr-data">
                                    <form action="" method="POST">
                                        <a href="{{ route('shipments.print.bill.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                            class="btn btn-primary  btn-sm" target="_blank"><i class="fa fa-print"></i>
                                            B
                                        </a>
                                        <a href="{{ route('shipments.print.label.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                            class="btn btn-primary btn-sm" target="_blank"><i class="fa fa-print"></i>
                                            L
                                        </a>
                                        @if (isGetAllData() || onCheckDocumentAccount(SETTING_OPS_LEADER_ACCOUNT))
                                            <a href="{{ route('shipments.print.label-v2.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                                class="btn btn-primary btn-sm" target="_blank"><i
                                                    class="fa fa-print"></i>
                                                L2
                                            </a>
                                        @endif
                                        @if (isGetAllData() ||
                                                isUserIdsShipment() ||
                                                onCheckDocumentAccount(SETTING_OPS_LEADER_ACCOUNT) ||
                                                onCheckDocumentAccount() ||
                                                $have_show_label_LF2)
                                            <a href="{{ route('shipments.print.label-v2-f.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                                class="btn btn-primary btn-sm" target="_blank"><i
                                                    class="fa fa-print"></i>
                                                L2F
                                            </a>
                                        @endif
                                        @if (isset($shipment['label']) && !onCheckPositionAccount(SETTING_ALL_ACCOUNT, auth()->user()['position_id']))
                                            @php
                                                $label = $shipment['label'];
                                                $check_file = checkFileInfo($label['link']);
                                            @endphp
                                            @if (isset($check_file) && $check_file['extension'] == 'txt')
                                                <a href="javascript:void(0)" class="btn btn-primary btn-sm"
                                                    onclick="onPrintFile('{{ $label['link'] }}')">
                                                    <i class="fas fa-file-pdf"></i> label
                                                </a>
                                            @else
                                                <a href="{{ $label['in_directory'] == IN_DIRECTORY ? asset($label['link']) : $label['link'] }}"
                                                    target="_blank" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-download"></i> label
                                                </a>
                                            @endif
                                        @endif
                                        <a href="{{ route('shipments.print.invoice.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                            class="btn btn-primary btn-sm" target="_blank"><i class="fa fa-print"></i>
                                            INV
                                        </a>
                                        @if ($checked['is_edit'])
                                            <a href="{{ route('shipments.edit.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                                type="button" class="btn btn-warning btn-sm"><i
                                                    class="far fa-edit"></i></a>
                                        @endif
                                        @if (isGetAllData())
                                            <button type="button"
                                                onclick="onDeleteShipment('{{ $shipment['shipment_code'] }}')"
                                                class="btn btn-sm btn-danger"><i class="fas fa-trash-alt"></i></button>
                                        @endif
                                    </form>
                                </span>
                            </li>
                        </ul>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $shipments->links('components.pagination') }}
</div>
