<label class="form-label">Charge Weight:
    <strong>{{ formatNumber(collect($shipment['packages'])->sum('package_charged_weight')) }} kg</strong>
</label>
@foreach ($operating_costs as $key_operating_cost => $operating_cost)
    <h5 class="card-title mb-3">{{ $key_operating_cost + 1 }}/ {{ $operating_cost['operating_cost_name'] }}</h5>
    @if ($operating_cost['operating_cost_type'] == OPERATING_COST_TYPE_NORMAL)
        @foreach ($operating_cost['childOperatingCost'] as $key_child_operating_cost => $child_operating_cost)
            <div class="row row-cols-3 align-items-center">
                <div class="col">
                    <div class="form-check">
                        <input class="form-check-input" type="radio"
                            name="operating_costs.{{ $key_operating_cost }}.shipment_operating_cost.operating_cost_id"
                            id="operating-costs_{{ $key_operating_cost }}_shipment-operating-cost_{{ $key_child_operating_cost }}_operating-cost-id"
                            value="{{ $child_operating_cost['operating_cost_id'] }}"
                            {{ isset($child_operating_cost['shipment_operating_cost_id']) ? 'checked' : '' }}>
                        <label class="form-check-label"
                            for="operating-costs_{{ $key_operating_cost }}_shipment-operating-cost_{{ $key_child_operating_cost }}_operating-cost-id">
                            {{ $child_operating_cost['operating_cost_name'] }}
                        </label>
                    </div>
                </div>
                <div class="col">
                    <div class="input-group mb-3">
                        <input type="number" class="form-control"
                            name="operating_costs.{{ $key_operating_cost }}.shipment_operating_cost.{{ $key_child_operating_cost }}.operating_cost_amount"
                            id="operating-costs_{{ $key_operating_cost }}_shipment-operating-cost_{{ $key_child_operating_cost }}_operating-cost-amount"
                            value="{{ isset($child_operating_cost['shipment_operating_cost_id']) ? $child_operating_cost['shipment_operating_cost_amount'] : $child_operating_cost['operating_cost_amount'] }}">
                        <span class="input-group-text bg-gray-light-4">VND/Đơn vị</span>
                    </div>
                </div>
                <div class="col">
                    <div class="input-group mb-3">
                        <input type="number" class="form-control"
                            name="operating_costs.{{ $key_operating_cost }}.shipment_operating_cost.{{ $key_child_operating_cost }}.shipment_operating_cost_quantity"
                            id="operating-costs_{{ $key_operating_cost }}_shipment-operating-cost_{{ $key_child_operating_cost }}_shipment-operating-cost-quantity"
                            value="{{ isset($child_operating_cost['shipment_operating_cost_quantity']) ? $child_operating_cost['shipment_operating_cost_quantity'] : 1 }}">
                        <span class="input-group-text bg-gray-light-4">Số lượng</span>
                    </div>
                </div>
            </div>
        @endforeach
    @elseif ($operating_cost['operating_cost_type'] == OPERATING_COST_TYPE_MULTIPLE)
        <div class="">
            <label class="form-label">Tổng kiện hàng nhỏ:
                <strong>{{ formatNumber(collect($shipment['packages'])->count()) }} kiện</strong>
            </label>
            @foreach ($operating_cost['childOperatingCost'] as $key_child_operating_cost => $child_operating_cost)
                <div class="row row-cols-3 align-items-center">
                    <div class="col">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox"
                                name="operating_costs.{{ $key_operating_cost }}.shipment_operating_cost.{{ $key_child_operating_cost }}.operating_cost_id"
                                id="operating-costs_{{ $key_operating_cost }}_shipment-operating-cost_{{ $key_child_operating_cost }}_operating-cost-id"
                                value="{{ $child_operating_cost['operating_cost_id'] }}"
                                {{ isset($child_operating_cost['shipment_operating_cost_id']) ? 'checked' : '' }}>
                            <label class="form-check-label"
                                for="operating-costs_{{ $key_operating_cost }}_shipment-operating-cost_{{ $key_child_operating_cost }}_operating-cost-id">
                                {{ $child_operating_cost['operating_cost_name'] }}
                            </label>
                        </div>
                    </div>
                    <div class="col">
                        <div class="input-group mb-3">
                            <input type="number" class="form-control"
                                name="operating_costs.{{ $key_operating_cost }}.shipment_operating_cost.{{ $key_child_operating_cost }}.operating_cost_amount"
                                id="operating-costs_{{ $key_operating_cost }}_shipment-operating-cost_{{ $key_child_operating_cost }}_operating-cost-amount"
                                value="{{ isset($child_operating_cost['shipment_operating_cost_id']) ? $child_operating_cost['shipment_operating_cost_amount'] : $child_operating_cost['operating_cost_amount'] }}">
                            <span class="input-group-text bg-gray-light-4">VND/Đơn vị</span>
                        </div>
                    </div>
                    <div class="col">
                        <div class="input-group mb-3">
                            <input type="number" class="form-control"
                                name="operating_costs.{{ $key_operating_cost }}.shipment_operating_cost.{{ $key_child_operating_cost }}.shipment_operating_cost_quantity"
                                id="operating-costs_{{ $key_operating_cost }}_shipment-operating-cost_{{ $key_child_operating_cost }}_shipment-operating-cost-quantity"
                                value="{{ isset($child_operating_cost['shipment_operating_cost_quantity']) ? $child_operating_cost['shipment_operating_cost_quantity'] : 1 }}">
                            <span class="input-group-text bg-gray-light-4">Số lượng</span>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif
    <p class="fst-itali mb-3">{{ $operating_cost['operating_cost_description'] }}</p>
@endforeach
<div class="mb-3">
    <label class="form-label text-danger">
        Tên khách hàng nhận SMS ( ghi IN tiếng việt không dấu)
    </label>
    <input type="text" class="form-control" value="{{ Str::upper(Str::ascii($shipment['receiver_contact_name'])) }}"
        name="operating_costs.receiver_sms_name" id="operating-costs_receiver-sms-name">
</div>
<div class="mb-3">
    <label class="form-label text-danger">
        SĐT người nhận tin(Nhập không khoảng trắng vd: 0948857150)
    </label>
    <input type="number" class="form-control" value="{{ $shipment['receiver_sms_phone'] }}"
        name="operating_costs.receiver_sms_phone" id="operating-costs_receiver-sms-phone">
</div>
