<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>PRINT LABEL KANGO {{ $shipment['shipment_code'] }}</title>
    <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
    <link rel="icon" href="{{ asset('assets/images/favicon.ico') }}" type="image/x-icon">
    <!-- CSS -->
    <link href="{{ asset('assets/dist/css/style.css') }}" rel="stylesheet" type="text/css">
    <style>
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }

        .form-print-bill {
            min-width: 500px;
            max-width: 500px;
            min-height: 700px;
        }

        .container-print-bill {
            transform: scale(0.8);
            transform-origin: 0 0 0;
        }

        @media print {
            @page {
                margin-left: 0in;
                margin-right: 0in;
                margin-top: 0in;
                margin-bottom: 0;
            }

            .pt-5 {
                padding-top: 1.3rem !important;
            }

            .container-print-bill {
                width: 100% !important;
                transform: scale(1) !important;
                height: 100vh !important;
            }

            .form-print-bill {
                min-width: 100%;
                max-width: 100%;
                min-height: 100%;
                max-height: 100%;
            }
        }
    </style>
</head>

<body>
    @foreach ($shipment['packages'] as $key_package => $package)
        <div class="p-5 pt-5 fs-4 d-flex justify-content-center container-print-bill">
            <div class="form-print-bill">
                <div class="row row-cols-1 border border-dark">
                    <div class="col border-dark">
                        <div class="text-danger p-3 text-center fw-bold fs-2">
                            LABELS
                        </div>
                    </div>
                </div>
                <div class="row row-cols-1 border border-top-0 border-dark">
                    <div class="col text-dark">
                        <div class="col-12 text-dark fw-bold mt-3">SHIP TO RECIPIENT:</div>
                        <div class="col-12 text-dark">{{ $shipment['receiver_contact_name'] }}</div>
                        <div class="col-12 text-dark">{{ $shipment['receiver_address_1'] }}</div>
                        <div class="col-12 text-dark">
                            {{ $shipment['city']['city_name'] ?? '' }}
                            {{ $shipment['state']['state_code'] ?? $shipment['receiver_state_name'] }}
                            {{ $shipment['receiver_postal_code'] }}
                        </div>
                        <div class="col-12 text-dark">{{ $shipment['country']['country_name'] }}</div>
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark">
                    <div class="col-4 p-1 text-dark text-center fw-bold border-end border-dark">
                        SERVICE
                    </div>
                    <div class="col-8 p-1 text-uppercase text-center fw-bold text-dark">
                        {{ $shipment['service']['service_name'] }}
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark">
                    <div class="col-4 p-1 text-dark text-center fw-bold border-end border-dark">
                        HAWB
                    </div>
                    <div class="col-8 p-1 text-uppercase text-center fw-bold text-dark">
                        {{ $package['package_code'] }}
                    </div>
                </div>
                <div class="row row-cols-1 border border-top-0 border-dark">
                    <div class="col p-2">
                        <div class="d-flex justify-content-center align-items-center">
                            {!! createBarCode($package['package_code']) !!}
                        </div>
                    </div>
                </div>
                <div class="row row-cols-1 border border-top-0 border-dark">
                    <div class="col p-1 text-start">
                        Reference No: {{ $shipment['shipment_reference_code'] }}
                    </div>
                </div>
                <div class="row row-cols-2 border border-top-0 border-dark fs-6 text-dark fw-bold">
                    <div class="col p-3 text-center border-end border-dark">
                        Total Pcs: {{ count($shipment['packages']) }}
                    </div>
                    <div class="col p-3 text-center">
                        SPX
                    </div>
                </div>
                <div class="row row-cols-1 border border-top-0 border-dark">
                    <div class="col p-2 text-center fw-bold text-dark fs-5">
                        {{ $key_package + 1 }} / {{ count($shipment['packages']) }}
                    </div>
                </div>
            </div>
        </div>
    @endforeach
    <script>
        var is_printed = false;
        window.onload = async function() {
            await window.scrollTo(0, 0);
            if (window.scrollY == 0 && !is_printed) {
                is_printed = true;
                window.print();
            }
            window.addEventListener('scroll', function() {
                if (window.scrollY == 0 && !is_printed) {
                    is_printed = true;
                    window.print();
                }
            });
        }
    </script>
</body>

</html>
