@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <div class="p-3">
            <section class="row">
                <div class="col-sm-3 mt-4">
                    <div class="card mb-4">
                        <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                            <span>
                                <span class="feather-icon"><i data-feather="info"></i></span>
                                Thông tin người gửi
                            </span>
                        </div>
                        <div class="card-body mt-2">
                            <p class="card-text">
                                - Công ty:
                                <strong>{{ $shipment['user']['user_company_name'] }}</strong>
                            </p>
                            <p class="card-text">
                                - Tên người gửi:
                                <strong>{{ $shipment['user']['user_contact_name'] }}</strong>
                            </p>
                            <p class="card-text">
                                - Số Điện Thoại:
                                <strong>{{ $shipment['user']['user_phone'] }}</strong>
                            </p>
                        </div>
                    </div>
                    <div class="card mb-4">
                        <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                            <span>
                                <span class="feather-icon"><i data-feather="info"></i></span>
                                Thông tin dịch vụ
                            </span>
                        </div>
                        <div class="card-body mt-2">
                            <p class="card-text">
                                - Dịch vụ:
                                <strong>{{ $shipment['service']['service_name'] }}</strong>
                            <p class="card-text">
                                - Loại dịch vụ:
                                <strong>{{ isset($service_kind_label[$shipment['service']['promotion_flg']]) ? $service_kind_label[$shipment['service']['promotion_flg']] : 'Khác' }}</strong>
                            </p>
                            @if ($shipment['service']['promotion_flg'] == IS_EPACKET && collect($shipment['packages'])->where('package_approve', '!=', PACKAGE_APPROVE_WAITING)->count() > 0)
                                <div class="d-flex justify-content-between card-text">
                                    <div class="">
                                        <p class="card-text ">
                                            - Khởi tạo label: <strong
                                                class="{{ $shipment['shipment_check_create_label'] == 0 ? 'text-warning' : 'text-success' }}">
                                                {{ $shipment['shipment_check_create_label'] == 0 ? 'Thất bại' : 'Thành công' }}
                                            </strong>
                                        </p>
                                    </div>
                                    @if ($shipment['shipment_check_create_label'] == 0)
                                        <div class="">
                                            <button class="btn btn-icon btn-soft-success btn-sm"
                                                onclick="onCreateLabelReload({{ $shipment['shipment_id'] }})"
                                                id="btn_create_label_reload">
                                                <span class="icon"><i class="fas fa-file-download"></i></span></button>
                                        </div>
                                    @endif
                                </div>
                            @endif
                            <p class="card-text">
                                - Brand:
                                <strong>{{ $shipment['branch']['branch_name'] ?? '' }}</strong>
                            </p>
                            <p class="card-text">
                                - Dịch vụ chữ ký người nhận:
                                <strong>{{ $shipment['shipment_signature_name'] }}</strong>
                            </p>
                        </div>
                    </div>
                    <div class="card">
                        <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                            <span>
                                <span class="feather-icon"><i data-feather="info"></i></span>
                                Thông tin người nhận
                            </span>
                        </div>
                        <div class="card-body mt-2">
                            <p class="card-text">
                                - Công ty:
                                <strong>{{ $shipment['receiver_company_name'] }}</strong>
                            </p>
                            <p class="card-text">
                                - Tên người nhận:
                                <strong>{{ $shipment['receiver_contact_name'] }}</strong>
                            </p>
                            <p class="card-text">
                                - Số Điện Thoại:
                                <strong>{{ $shipment['receiver_telephone'] }}</strong>
                            </p>
                            <p class="card-text">
                                - Địa chỉ:
                                <strong>{{ $shipment['receiver_address_1'] }}</strong>
                            </p>
                            <p class="card-text">
                                - Thành Phố:
                                <strong>{{ $shipment['city']['city_name'] ?? '' }}</strong>
                            </p>
                            <p class="card-text">
                                - Quốc Gia:
                                <strong>{{ $shipment['country']['country_name'] }}</strong>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-sm-9 mt-4">
                    <div class="card">
                        <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                            <span>
                                <span class="feather-icon"><i data-feather="info"></i></span>
                                Chỉnh sửa thông tin in Label 2
                            </span>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <label class="form-label">
                                        Name
                                    </label>
                                    <input type="text" class="form-control"
                                        value="{{ $shipment['receiver_contact_name'] }}" name="receiver_contact_name">
                                </div>
                                <div class="col-12 mb-3">
                                    <label class="form-label">
                                        Address
                                    </label>
                                    <input type="text" class="form-control"
                                        value="{{ $shipment['receiver_address_1'] }}" name="receiver_address_1">
                                </div>
                                <div class="col-12 mb-3">
                                    <label class="form-label">
                                        City , State, Post Code
                                    </label>
                                    <input type="text" class="form-control"
                                        value="{{ $shipment['city']['city_name'] ?? '' }}, {{ $shipment['state']['state_code'] ?? $shipment['receiver_state_name'] }}, {{ $shipment['receiver_postal_code'] }}"
                                        name="receiver_city_state_post_code">
                                </div>
                                <div class="col-12 mb-3">
                                    <label class="form-label">
                                        Quốc gia (Country) *
                                    </label>
                                    <select id="select_country" class="select2">
                                        @foreach ($countries as $key => $country)
                                            <option value="{{ $country['country_name'] }}"
                                                {{ $shipment['receiver_country_id'] == $country['country_id'] ? 'selected' : '' }}>
                                                {{ $country['country_name'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <button type="button" class="mt-3 btn btn-warning" id="edit_print_label">
                                Edit & Print
                            </button>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    @push('scripts')
        <script>
            var shipment_code = @json($shipment['shipment_code']);
            $('.select2').each(function() {
                $(this).select2({
                    dropdownParent: $(this).parent(),
                });
            });
        </script>
        <script src="{{ asset('js/shipment/prints/label-v2-f.js') }}"></script>
    @endpush
@endsection
