<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>PRINT INVOICE KANGO {{ $shipment['shipment_code'] }}</title>
    <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
    <link rel="icon" href="{{ asset('assets/images/favicon.ico') }}" type="image/x-icon">
    <!-- CSS -->
    <link href="{{ asset('assets/dist/css/style.css') }}" rel="stylesheet" type="text/css">
    <style>
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }

        @media print {
            @page {
                margin-left: 0in;
                margin-right: 0in;
                margin-top: 0in;
                margin-bottom: 0;
            }

            .pt-5 {
                padding-top: 1.3rem !important;
            }

            .form-print-bill {
                width: 100%;
                height: 100vh;
            }

            .fs-5 {
                font-size: 0.7rem !important;
            }

            .fs-6 {
                font-size: 0.7rem !important;
            }

            .fs-7 {
                font-size: 0.6rem !important;
            }

            .fs-8 {
                font-size: 0.5rem !important;
            }

            .mt-3 {
                margin-top: 0.3rem !important;
            }

            .mt-4 {
                margin-top: 0.4rem !important;
            }

            .mb-3 {
                margin-bottom: 0.3rem !important;
            }

            .mb-4 {
                margin-bottom: 0.4rem !important;
            }

            .mb-5 {
                margin-bottom: 0.5rem !important;
            }

            .container {
                max-width: 100% !important;
            }

            .p-2 {
                padding: 0.2rem !important;
            }
        }
    </style>
</head>

<body>
    <div class="p-5 pt-5 fs-7 text-dark d-flex justify-content-center form-print-bill container">
        <div style="min-width: 100%">
            <div class="col-12 text-center fw-bold fs-4">INVOICE</div>
            <div class="row row-cols-2">
                <div class="col-7">
                    <div class="row">
                        <div class="col-12 text-decoration-underline fw-bold p-2">
                            SHIPPER
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2 fs-5">Company Name</div>
                        <div class="col-9 border-dark border-bottom fw-bold p-2">
                            {{ $shipment['sender_company_name'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2 fs-5">Address</div>
                        <div class="col-9 border-dark border-bottom p-2 fs-5">
                            {{ $shipment['sender_address'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2 fs-5">Town/ Area Code</div>
                        <div class="col-9 border-dark border-bottom p-2 fs-5">
                            {{ $shipment['sender_ward_name'] }},
                            {{ $shipment['sender_district_name'] }},
                            {{ $shipment['sender_city_name'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2 fs-5">State/ Country</div>
                        <div class="col-9 border-dark border-bottom p-2 fw-bold fs-5">
                            Viet Nam
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2">Contact Name</div>
                        <div class="col-9 border-dark border-bottom p-2">
                            {{ $shipment['sender_contact_name'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2">Phone/Fax No</div>
                        <div class="col-9 border-dark border-bottom p-2">
                            {{ $shipment['sender_telephone'] }}
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-12 text-decoration-underline fw-bold p-2">
                            CONSIGNEE
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2">Company Name</div>
                        <div class="col-9 border-dark border-bottom fw-bold p-2">
                            {{ $shipment['receiver_company_name'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2">Address</div>
                        <div class="col-9 border-dark border-bottom fw-bold p-2">
                            {{ $shipment['receiver_address_1'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2">Postal code</div>
                        <div class="col-9 border-dark border-bottom fw-bold p-2">
                            {{ $shipment['receiver_postal_code'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2">State, Country</div>
                        <div class="col-9 border-dark border-bottom fw-bold p-2">
                            {{ $shipment['state']['state_name'] ?? $shipment['receiver_state_name'] }},
                            {{ $shipment['country']['country_name'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2">Contact Name</div>
                        <div class="col-9 border-dark border-bottom fw-bold p-2">
                            {{ $shipment['receiver_contact_name'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3 text-start p-2">Phone/Fax No</div>
                        <div class="col-9 border-dark border-bottom fw-bold p-2">
                            {{ $shipment['receiver_telephone'] }}
                        </div>
                    </div>
                </div>
                <div class="col-5">
                    <div class="row">
                        <div class="col-6 text-end fw-bold p-2">Date</div>
                        <div class="col-6 border-dark border-bottom p-2">
                            {{ \Carbon\Carbon::now()->format('Y/m/d') }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6 text-end fw-bold p-2">Air waybill No</div>
                        <div class="col-6 border-dark border-bottom fw-bold p-2">
                            {{ $shipment['shipment_code'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6 text-end fw-bold p-2">Service</div>
                        <div class="col-6 border-dark border-bottom fw-bold bg-warning p-2">
                            {{ $shipment['service']['service_name'] }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6 text-end fw-bold p-2">No. of pkgs</div>
                        <div class="col-6 border-dark border-bottom p-2">
                            {{ count($shipment['packages']) }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6 text-end fw-bold p-2">Weight</div>
                        <div class="col-6 border-dark border-bottom p-2">
                            {{ collect($shipment['packages'])->sum('package_weight') }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6 text-end fw-bold p-2">Dimensions</div>
                        <div class="col-6 p-2">
                            @foreach ($to_receiver_packages as $receiver_package)
                                <div class="border-bottom border-dark d-flex justify-content-between">
                                    <div>
                                        {{ collect($receiver_package)->first()['package_length'] }} x
                                        {{ collect($receiver_package)->first()['package_width'] }} x
                                        {{ collect($receiver_package)->first()['package_height'] }}
                                    </div>
                                    <div class="fw-bold">
                                        ({{ count($receiver_package) }})
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <table class="table table-bordered border-dark">
                    <thead>
                        <tr>
                            <th class="text-dark fw-bold fs-7 text-center text-nowrap">
                                Full Description of Goods
                                <p>(Name of goods, composition of material, marks, etc)</p>
                            </th>
                            <th class="text-dark fw-bold fs-7 text-center text-nowrap">No.of Items</th>
                            <th class="text-dark fw-bold fs-7 text-center">Origin</th>
                            <th class="text-dark fw-bold fs-7 text-center">Unit</th>
                            <th class="text-dark fw-bold fs-7 text-center text-nowrap">
                                Unit Price 
                                <p>(in USD)</p>
                            </th>
                            <th class="text-dark fw-bold fs-7 text-center text-nowrap">
                                Subtotal
                                <p>(in USD)</p>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($shipment['invoices'] as $invoice)
                            <tr>
                                <td class="text-dark fw-bold fs-7">{{ $invoice['invoice_goods_details'] }}</td>
                                <td class="text-dark fw-bold fs-7">{{ $invoice['invoice_quantity'] }}</td>
                                <td class="text-dark fw-bold fs-7">VIETNAM</td>
                                <td class="text-dark fw-bold fs-7">{{ $invoice['invoice_unit_name'] }}</td>
                                <td class="text-dark fw-bold fs-7">{{ $invoice['invoice_price'] }} USD</td>
                                <td class="text-dark fw-bold fs-7">{{ $invoice['invoice_total_price'] }} USD</td>
                            </tr>
                        @endforeach
                        <tr>
                            <td class="text-dark fw-bold fs-7 text-center" colspan="5">
                                Total Value (in USD)
                            </td>
                            <td class="text-dark fw-bold fs-7">
                                {{ collect($shipment['invoices'])->sum('invoice_total_price') }} USD
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="row row-cols-2">
                <div class="ps-0 col-2 text-start">Reason for Export</div>
                <div class="col-10 border-dark border-bottom fw-bold">
                    {{ $shipment['sender_company_name'] }}
                </div>
                <div class="ps-0 col-12 mt-4">
                    I declare that the information is true and correct to the best of my knowledge and that the goods are of  <span class="text-danger">Viet Nam</span> origin.
                </div>
                <div class="ps-0 col-2 text-start mt-3">I (name)</div>
                <div class="col-10 border-dark border-bottom mt-3">
                    {{ $shipment['user']['user_contact_name'] }}
                </div>
                <div class="ps-0 col-12 mt-4">
                    quantity of goods specified in this document are goods which are submitted for clearance for export out of <span class="text-danger">Viet Nam</span>.
                </div>
            </div>
            <div class="row row-cols-2 mt-5">
                <div class="col"></div>
                <div class="col text-center">Signature/Title/Stamp</div>
            </div>
        </div>
    </div>
    <script>
        var is_printed = false;
        window.onload = async function() {
            await window.scrollTo(0, 0);
            if (window.scrollY == 0 && !is_printed) {
                is_printed = true;
                window.print();
            }
            window.addEventListener('scroll', function() {
                if (window.scrollY == 0 && !is_printed) {
                    is_printed = true;
                    window.print();
                }
            });
        }
    </script>
</body>

</html>
