<table class="table">
    <thead>
        <tr role="row">
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER COMPANY</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER NAME</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER PHONE</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER EMAIL</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER ADDRESS 1</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER ADDRESS 2</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER CITY</th>
            <th style="font-weight: bold; background-color: #e5ff00">SHIPPER COUNTRY</th>
            <th style="font-weight: bold; background-color: #e5ff00"h>AWB</th>
            <th style="font-weight: bold; background-color: #e5ff00">HAWB</th>
            <th style="font-weight: bold; background-color: #e5ff00">TRACKING NUMBER</th>
            <th style="font-weight: bold; background-color: #e5ff00">SERVICE</th>
            <th style="font-weight: bold; background-color: #e5ff00">DATE</th>
            <th style="font-weight: bold; background-color: #e5ff00">COMPANY</th>
            <th style="font-weight: bold; background-color: #e5ff00">CONTACT</th>
            <th style="font-weight: bold; background-color: #e5ff00">ADDRESS 1</th>
            <th style="font-weight: bold; background-color: #e5ff00">ADDRESS 2 </th>
            <th style="font-weight: bold; background-color: #e5ff00">ADDRESS 3</th>
            <th style="font-weight: bold; background-color: #e5ff00">CITY</th>
            <th style="font-weight: bold; background-color: #e5ff00">STATE/PROVINCE</th>
            <th style="font-weight: bold; background-color: #e5ff00">COUNTRY</th>
            <th style="font-weight: bold; background-color: #e5ff00"h>POSTAL CODE</th>
            <th style="font-weight: bold; background-color: #e5ff00">TELEPHONE</th>
            <th style="font-weight: bold; background-color: #e5ff00">Q TY</th>
            <th style="font-weight: bold; background-color: #e5ff00">G.W</th>
            <th style="font-weight: bold; background-color: #e5ff00">C.W</th>
            <th style="font-weight: bold; background-color: #e5ff00">LENGTH</th>
            <th style="font-weight: bold; background-color: #e5ff00">WIDTH</th>
            <th style="font-weight: bold; background-color: #e5ff00">HEIGHT</th>
            <th style="font-weight: bold; background-color: #e5ff00">TYPE</th>
            <th style="font-weight: bold; background-color: #e5ff00">DESCRIPTION OF GOODS</th>
            <th style="font-weight: bold; background-color: #e5ff00">VALUE</th>
            <th style="font-weight: bold; background-color: #e5ff00">UNIT</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($data_excel as $key => $shipment)
            @php
                $area_vn = getAreaVietName($shipment['sender_city']);
                $packages = $shipment['packages'];
                $package_types = ['Carton', 'Pallet', 'Túi(Phong bì)'];
            @endphp
            <tr>
                <td>{{ $shipment['sender_company_name'] }}</td>
                <td>{{ $shipment['sender_contact_name'] }}</td>
                <td>{{ $shipment['sender_telephone'] }}</td>
                <td>{{ getUser($shipment['user_id'])['user_name'] }}</td>
                <td>{{ $shipment['sender_address'] }}</td>
                <td></td>
                <td>{{ $area_vn['cities'][$shipment['sender_city']] ?? '' }}</td>
                <td>VN</td>
                <td>{{ $shipment['shipment_code'] }}</td>
                <td>
                    @foreach ($packages as $key => $package)
                        <p>{{ $package['package_code'] }}</p>
                    @endforeach
                </td>
                <td>
                    @foreach ($packages as $key => $package)
                        <p>{{ $package['package_tracking_code'] }}</p>
                    @endforeach
                </td>
                <td>{{ $shipment['service']['service_name'] }}</td>
                <td>{{ formatDate($shipment['created_at']) }}</td>
                <td>{{ $shipment['receiver_company_name'] }}</td>
                <td>{{ $shipment['receiver_contact_name'] }}</td>
                <td>{{ $shipment['receiver_address_1'] }}</td>
                <td>{{ $shipment['receiver_address_2'] }}</td>
                <td>{{ $shipment['receiver_address_3'] }}</td>
                <td>{{ $shipment['city']['city_name'] ?? '' }}</td>
                <td>{{ $shipment['state']['state_name'] ?? '' }}</td>
                <td>{{ $shipment['country']['country_name'] ?? '' }}</td>
                <td>{{ $shipment['receiver_postal_code'] }}</td>
                <td>{{ $shipment['receiver_sms_phone'] }}</td>
                <td>{{ count($packages) }}</td>
                <td>
                    @foreach ($packages as $key => $package)
                        <p>{{ $package['package_weight'] }}</p>
                    @endforeach
                </td>
                <td>
                    @foreach ($packages as $key => $package)
                        <p>{{ $package['package_converted_weight'] }}</p>
                    @endforeach
                </td>
                <td>
                    @foreach ($packages as $key => $package)
                        <p>{{ $package['package_length'] }}</p>
                    @endforeach
                </td>
                <td>
                    @foreach ($packages as $key => $package)
                        <p>{{ $package['package_width'] }}</p>
                    @endforeach
                </td>
                <td>
                    @foreach ($packages as $key => $package)
                        <p>{{ $package['package_height'] }}</p>
                    @endforeach
                </td>
                <td>
                    @foreach ($packages as $key => $package)
                        <p>{{ $package_types[$package['package_type']] ?? '' }}</p>
                    @endforeach
                </td>
                <td>
                    @foreach($shipment['invoices'] as $key => $invoice)
                        <p>{{ $invoice['invoice_quantity'] }}. {{ $invoice['invoice_goods_details'] }}: {{ $invoice['invoice_total_price'] }}</p>
                    @endforeach
                </td>
                <td>{{ $shipment['shipment_value'] }}</td>
                <td>USD</td>
            </tr>
        @endforeach
    </tbody>
</table>
