@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <div class="p-3">
            <!-- Page Header -->
            <div class="hk-pg-header pg-header-wth-tab pt-2">
                <div class="card">
                    <div
                        class="hk-ribbon-type-1 ribbon-wth-icon overhead-start {{ $shipment['active_flg'] == ACTIVE ? 'bg-success' : 'bg-danger' }}">
                        <span><span class="feather-icon"><i
                                    data-feather="{{ $shipment['active_flg'] == ACTIVE ? 'check-circle' : 'x-circle' }}"></i></span>
                            {{ $shipment['active_flg'] == ACTIVE ? 'Khởi tạo đơn thành công' : 'Khởi tạo đơn thất bại' }}
                        </span>
                    </div>
                    <div class="card-body d-flex justify-content-between">
                        <div>
                            <h5 class="pg-title">Đơn hàng: {{ $shipment['shipment_code'] }}</h5>
                        </div>
                        <div>
                            <button class="me-1 btn btn-custom btn-primary btn-sm">
                                <a class="text-white"
                                    href="{{ route('shipments.print.bill.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                    target="_blank">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="printer"></i></span>
                                    </span>
                                    <span>Print Bill</span>
                                </a>
                            </button>
                            <button class="me-1 btn btn-custom btn-primary btn-sm">
                                <a class="text-white"
                                    href="{{ route('shipments.print.label.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                    target="_blank">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="printer"></i></span>
                                    </span>
                                    <span>Print Label</span>
                                </a>
                            </button>
                            <button class="me-1 btn btn-custom btn-primary btn-sm">
                                <a class="text-white"
                                    href="{{ route('shipments.print.invoice.show', ['shipment_code' => $shipment['shipment_code']]) }}"
                                    target="_blank">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="printer"></i></span>
                                    </span>
                                    <span>Print Invoice</span>
                                </a>
                            </button>
                        </div>
                    </div>
                </div>
                <ul class="nav nav-tabs nav-icon nav-light">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#tab_shipment_information">
                            <span class="nav-icon-wrap"><span class="feather-icon"><i data-feather="info"></i></span></span>
                            <span class="nav-link-text">Thông tin lô hàng</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#tab_shipment_packages_and_invoices">
                            <span class="nav-icon-wrap"><span class="feather-icon"><i data-feather="box"></i></span></span>
                            <span class="nav-link-text">Thông tin kiện hàng</span>
                        </a>
                    </li>
                </ul>
            </div>
            <!-- /Page Header -->

            <!-- Page Body -->
            <div class="hk-pg-body mb-5">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="tab_shipment_information">
                        <section class="row">
                            <div class="col-sm-3">
                                <div class="card mb-4">
                                    <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                                        <span>
                                            <span class="feather-icon"><i data-feather="info"></i></span>
                                            Logo dịch vụ
                                        </span>
                                    </div>
                                    <div class="card-body mt-2">
                                        <div class="">
                                            <img src="{{ asset(isset($shipment['service']['logoService']) ? $shipment['service']['logoService']['logo'] : LOGO) }}"
                                                style="max-width: 100%; object-fit: cover">
                                        </div>
                                        <p class="card-text text-info">
                                            {{ $shipment['service']['logoService']['title'] ?? '' }}
                                        </p>
                                        <p class="text-danger text-sm fst-italic">
                                            {{ $shipment['service']['logoService']['description'] ?? '' }}
                                        </p>
                                    </div>
                                </div>
                                <div class="card mb-4">
                                    <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                                        <span>
                                            <span class="feather-icon"><i data-feather="info"></i></span>
                                            Thông tin người gửi
                                        </span>
                                    </div>
                                    <div class="card-body mt-2">
                                        <p class="card-text">
                                            - Công ty:
                                            <strong>{{ $shipment['user']['user_company_name'] }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Tên người gửi:
                                            <strong>{{ $shipment['user']['user_contact_name'] }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Số Điện Thoại:
                                            <strong>{{ $shipment['user']['user_phone'] }}</strong>
                                        </p>
                                    </div>
                                </div>
                                <div class="card mb-4">
                                    <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                                        <span>
                                            <span class="feather-icon"><i data-feather="info"></i></span>
                                            Thông tin dịch vụ
                                        </span>
                                    </div>
                                    <div class="card-body mt-2">
                                        <p class="card-text">
                                            - Dịch vụ:
                                            <strong>{{ $shipment['service']['service_name'] }}</strong>
                                        <p class="card-text">
                                            - Loại dịch vụ:
                                            <strong>{{ $service_kind_label[$shipment['service']['promotion_flg']] ?? 'Khác' }}</strong>
                                        </p>
                                        @if (
                                            $shipment['service']['promotion_flg'] == IS_EPACKET &&
                                                collect($shipment['packages'])->where('package_approve', '!=', PACKAGE_APPROVE_WAITING)->count() > 0)
                                            <div class="d-flex justify-content-between card-text">
                                                <div class="">
                                                    <p class="card-text ">
                                                        - Khởi tạo label: <strong
                                                            class="{{ $shipment['shipment_check_create_label'] == 0 ? 'text-warning' : 'text-success' }}">
                                                            {{ $shipment['shipment_check_create_label'] == 0 ? 'Thất bại' : 'Thành công' }}
                                                        </strong>
                                                        @if (isset($label) && !onCheckPositionAccount(SETTING_ALL_ACCOUNT, auth()->user()['position_id']))
                                                            @php
                                                                $check_file = checkFileInfo($label['link']);
                                                            @endphp
                                                            @if (isset($check_file) && $check_file['extension'] == 'txt')
                                                                <a href="javascript:void(0)"
                                                                    onclick="onPrintFile('{{ $label['link'] }}')">
                                                                    <i class="fas fa-file-pdf"></i>
                                                                </a>
                                                            @else
                                                                <a href="{{ $label['in_directory'] == IN_DIRECTORY ? asset($label['link']) : $label['link'] }}"
                                                                    target="_blank" class="">
                                                                    <i class="fas fa-download"></i>
                                                                </a>
                                                            @endif
                                                        @endif
                                                    </p>
                                                </div>
                                                @if ($shipment['shipment_check_create_label'] == 0)
                                                    <div class="">
                                                        <button class="btn btn-icon btn-soft-success btn-sm"
                                                            onclick="onCreateLabelReload({{ $shipment['shipment_id'] }})"
                                                            id="btn_create_label_reload">
                                                            <span class="icon">
                                                                <i class="fas fa-file-download"></i>
                                                            </span>
                                                        </button>
                                                    </div>
                                                @endif
                                            </div>
                                        @endif
                                        <p class="card-text">
                                            - Brand:
                                            <strong>{{ $shipment['branch']['branch_name'] }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Dịch vụ chữ ký người nhận:
                                            <strong>{{ $shipment['shipment_signature_name'] }}</strong>
                                        </p>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                                        <span>
                                            <span class="feather-icon"><i data-feather="info"></i></span>
                                            Thông tin người nhận
                                        </span>
                                    </div>
                                    <div class="card-body mt-2">
                                        <p class="card-text">
                                            - Công ty:
                                            <strong>{{ $shipment['receiver_company_name'] }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Tên người nhận:
                                            <strong>{{ $shipment['receiver_contact_name'] }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Số Điện Thoại:
                                            <strong>{{ $shipment['receiver_telephone'] }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Địa chỉ:
                                            <strong>{{ $shipment['receiver_address_1'] }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Thành Phố:
                                            <strong>{{ $shipment['city']['city_name'] ?? '' }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Post code:
                                            <strong>{{ $shipment['receiver_postal_code'] ?? '' }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Khu vực:
                                            <strong>{{ isset($shipment['receiver_state_name']) ? $shipment['receiver_state_name'] : $shipment['state']['state_name'] }}</strong>
                                        </p>
                                        <p class="card-text">
                                            - Quốc Gia:
                                            <strong>{{ $shipment['country']['country_name'] }}</strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-9">
                                <div class="card">
                                    <div class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                                        <span>
                                            <span class="feather-icon"><i data-feather="info"></i></span>
                                            Thông tin thanh toán
                                        </span>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-2 mt-2">
                                            <p>- Tên hàng: <b>{{ $shipment['shipment_goods_name'] }}</b></p>
                                            <p class="mt-2">- Export as:
                                                <b>{{ $shipment['shipment_export_as_name'] }}</b>
                                            </p>
                                            @if (!onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id']))
                                                @if ($shipment['service']['promotion_flg'] == IS_EPACKET)
                                                    <p class="mt-2">- Đã thanh toán trước:
                                                        <b id="shipment_final_amount">
                                                            {{ formatNumber($shipment['shipment_final_amount']) }}đ
                                                        </b>
                                                        @if (isset(auth()->user()['wallet']['amount']) &&
                                                                auth()->user()['wallet']['amount'] < $shipment['shipment_final_amount'] &&
                                                                $shipment['shipment_payment_status'] == PENDING)
                                                            <button type="button" class="btn btn-sm btn-success"
                                                                data-bs-toggle="modal" data-bs-target="#rechargeInpModal">
                                                                Nạp tiền ngay
                                                            </button>
                                                        @endif
                                                    </p>
                                                @else
                                                    <p class="mt-2">- Tổng cước thu khách:
                                                        <b
                                                            id="content_total_customer">{{ formatNumber($shipment['shipment_amount_total_customer']) }}đ</b>
                                                    </p>
                                                @endif
                                            @endif
                                        </div>
                                        <p class="mt-2">- Trạng thái thanh toán:
                                            <span
                                                class="fw-bold text-{{ $shipment['shipment_payment_status'] == 0 ? 'danger' : 'success' }}">
                                                {{ $shipment['shipment_payment_status'] == 0 ? 'Chưa ' : 'Đã ' }}thanh
                                                toán
                                            </span>
                                            @if ($shipment['shipment_payment_status'] == PENDING && $shipment['service']['promotion_flg'] == IS_EPACKET)
                                                <button type="button" class="btn btn-sm btn-success btn-payment-shipment"
                                                    data-shipment_code="{{ $shipment['shipment_code'] }}">
                                                    Thanh toán ngay
                                                </button>
                                            @endif
                                        </p>
                                        <p class="mt-2">- Phương thức thanh toán:
                                            <span id="shipment_paid_by_name">
                                                @if (!onCheckPositionAccount(SETTING_FWD_ACCOUNT, $shipment['user']['position_id']))
                                                    {{ $shipment['shipment_paid_by'] == SHIPMENT_PAID_BY_REMAINING ? 'Thanh toán nợ' : 'Thanh toán sau' }}
                                                @else
                                                    Thanh toán sau
                                                @endif
                                            </span>
                                            @if (
                                                $shipment['shipment_payment_status'] == 0 &&
                                                    !onCheckPositionAccount(SETTING_FWD_ACCOUNT, $shipment['user']['position_id']))
                                                <span>
                                                    <button data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="Cập nhật lại phương thức thanh toán"
                                                        onclick="onReloadPaidBy()"
                                                        class="btn btn-icon btn-soft-warning"><span class="icon"><i
                                                                class="fas fa-undo"></i></span></button>
                                                </span>
                                            @endif
                                        </p>
                                        @if (in_array($shipment['shipment_status'], [SHIPMENT_STATUS_EXPORED, SHIPMENT_STATUS_HOLD]) && isGetAllData())
                                            <div class="mb-2 mt-2">
                                                <button id="btn_check_hold_shipment"
                                                    data-shipment_code="{{ $shipment['shipment_code'] }}"
                                                    class="btn {{ $shipment['shipment_status'] == SHIPMENT_STATUS_EXPORED ? 'btn-danger' : 'btn-success' }}">
                                                    {!! $shipment['shipment_status'] == SHIPMENT_STATUS_EXPORED
                                                        ? '<i class="fas fa-exclamation-triangle"></i> Check Hold'
                                                        : '<i class="fas fa-check"></i> Cancel Hold' !!}
                                                </button>
                                            </div>
                                        @endif
                                        @if (
                                            !onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id']) &&
                                                $shipment['service']['promotion_flg'] != IS_EPACKET)
                                            <div class="row">
                                                @if (isGetAllData())
                                                    <div class="col-sm-4">
                                                        <div class="card mt-4">
                                                            <div
                                                                class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-center">
                                                                <span><span class="feather-icon"><i
                                                                            data-feather="upload-cloud"></i></span>
                                                                    Label
                                                                </span>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="dropzone" id="fileLabel"></div>
                                                                <div class="invalid-feedback d-block">
                                                                    * Chỉ chấp nhận file PDF
                                                                </div>
                                                            </div>
                                                            <div class="card-footer d-flex justify-content-between"
                                                                id="btn_content_label">
                                                                <button class="btn btn-sm btn-primary" id="save_label">
                                                                    <span>
                                                                        <span class="icon"><i
                                                                                class="fa fa-upload"></i></span>
                                                                        <span>Cập nhật</span>
                                                                    </span>
                                                                </button>

                                                                @if (!empty($shipment['shipment_file_label']))
                                                                    <a href="{{ asset($shipment['shipment_file_label']) }}"
                                                                        target="_blank" class="btn btn-primary btn-sm"
                                                                        id="a_file_label">
                                                                        Hiển thị <i class="far fa-eye"></i>
                                                                    </a>
                                                                @endif

                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                                <div class="col-sm-8">
                                                    <div class="card mt-4">
                                                        <div
                                                            class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-center">
                                                            <span>
                                                                <span class="feather-icon">
                                                                    <i data-feather="upload-cloud"></i>
                                                                </span>
                                                                Bằng chứng thanh toán
                                                            </span>
                                                        </div>
                                                        <div class="card-body">
                                                            <div class="row">
                                                                @if ($shipment['shipment_payment_status'] == 0)
                                                                    @if (!onCheckPositionAccount(SETTING_FWD_ACCOUNT, $shipment['user']['position_id']))
                                                                        @if (!in_array($shipment['shipment_payment_step'], [1, 3]))
                                                                            <div class="col-md-6">
                                                                                <div class="dropzone" id="fileMethod">
                                                                                </div>
                                                                                <div class="invalid-feedback d-block">
                                                                                    * Hình ảnh, file pdf...v.v
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-6">
                                                                                <strong>Phương thức thanh toán</strong>
                                                                                <div class="form-check">
                                                                                    <input class="form-check-input"
                                                                                        type="radio"
                                                                                        name="shipmentPaymentMethod"
                                                                                        value="{{ CASH }}"
                                                                                        id="shipment_payment_method_direct"
                                                                                        {{ $shipment['shipment_payment_method'] == CASH ? 'checked' : '' }}>
                                                                                    <label class="form-check-label"
                                                                                        for="shipment_payment_method_direct">
                                                                                        Tiền mặt
                                                                                    </label>
                                                                                </div>
                                                                                <div class="form-check">
                                                                                    <input class="form-check-input"
                                                                                        type="radio"
                                                                                        name="shipmentPaymentMethod"
                                                                                        value="{{ BANK }}"
                                                                                        id="shipment_payment_method_bank"
                                                                                        {{ $shipment['shipment_payment_method'] == BANK ? 'checked' : '' }}>
                                                                                    <label class="form-check-label"
                                                                                        for="shipment_payment_method_bank">
                                                                                        Ngân hàng
                                                                                    </label>
                                                                                </div>
                                                                                <div class="form-check">
                                                                                    <input class="form-check-input"
                                                                                        type="radio"
                                                                                        name="shipmentPaymentMethod"
                                                                                        value="{{ CASH_AND_BANK }}"
                                                                                        id="shipment_payment_method_cash_bank"
                                                                                        {{ $shipment['shipment_payment_method'] == CASH_AND_BANK ? 'checked' : '' }}>
                                                                                    <label class="form-check-label"
                                                                                        for="shipment_payment_method_cash_bank">
                                                                                        Tiền mặt & Ngân hàng
                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                            <div class="text-center">
                                                                                <button class="btn btn-sm btn-primary"
                                                                                    id="save_method">
                                                                                    <span>
                                                                                        <span class="icon"><i
                                                                                                class="fa fa-upload"></i></span>
                                                                                        <span>Cập nhật</span>
                                                                                    </span>
                                                                                </button>

                                                                            </div>
                                                                        @elseif (in_array($shipment['shipment_payment_step'], [1, 3]))
                                                                            <div class="alert alert-warning"
                                                                                role="alert">
                                                                                <h5 class="alert-heading">Đang chờ duyệt
                                                                                </h5>
                                                                                @foreach (onConvertStrArrImage($shipment['shipment_file_proof_of_payment']) as $item)
                                                                                    @if (!empty($item))
                                                                                        <a class="p-2"
                                                                                            href="{{ asset($item) }}"
                                                                                            target="_blank"><i
                                                                                                class="fas fa-image"></i></a>
                                                                                    @endif
                                                                                @endforeach
                                                                            </div>
                                                                        @endif
                                                                    @endif
                                                                @else
                                                                    <div class="alert alert-primary" role="alert">
                                                                        <h5 class="alert-heading">Đã thanh toán</h5>
                                                                        @foreach (onConvertStrArrImage($shipment['shipment_file_proof_of_payment']) as $item)
                                                                            @if (!empty($item))
                                                                                <a class="p-2"
                                                                                    href="{{ asset($item) }}"
                                                                                    target="_blank"><i
                                                                                        class="fas fa-image"></i></a>
                                                                            @endif
                                                                        @endforeach
                                                                        <p>{{ $shipment['shipment_payment_des'] }}</p>
                                                                    </div>
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <div class="card-footer text-center" id="btn_content_method">

                                                            {{-- @if (!empty($shipment['shipment_file_proof_of_payment']))
                                                                <a href="{{ asset($shipment['shipment_file_proof_of_payment']) }}"
                                                                    target="_blank" class="btn btn-primary btn-sm"
                                                                    id="a_file_method">
                                                                    Hiển thị <i class="far fa-eye"></i>
                                                                </a>
                                                            @endif --}}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if ($is_view_shipment_operating_costs)
                                            <hr>
                                            <div class="row">
                                                <div class="col-sm-4 mb-3">
                                                    <div class="d-flex justify-content-between mb-3">
                                                        <label class="fw-bold fs-6">
                                                            Chi phí phụ thu khách
                                                        </label>
                                                        @if (isGetAllData())
                                                            <button data-bs-toggle="modal"
                                                                data-bs-target="#exampleModalShipmentFee"
                                                                class="btn btn-primary btn-sm">
                                                                <span>
                                                                    <span class="icon"><i
                                                                            class="fas fa-edit"></i></span>
                                                                    <span>Sửa chi phí</span>
                                                                </span>
                                                            </button>
                                                        @endif
                                                    </div>
                                                    <div id="content_table_freight">
                                                        <table class="table">
                                                            <thead class="thead-primary">
                                                                <tr>
                                                                    <th scope="col">Nội dung</th>
                                                                    <th scope="col">Số tiền</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <td>Cước nội địa</td>
                                                                    <td>{{ formatNumber($shipment['shipment_domestic_charges']) }}đ
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Cước phụ thu</td>
                                                                    <td>{{ formatNumber($shipment['shipment_amount_surcharge']) }}đ
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Cước thu hộ</td>
                                                                    <td>{{ formatNumber($shipment['shipment_collection_fee']) }}đ
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Cước phí bảo hiểm</td>
                                                                    <td>{{ formatNumber($shipment['shipment_amount_insurance']) }}đ
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Giá cước VAT</td>
                                                                    <td>{{ formatNumber($shipment['shipment_amount_vat']) }}đ
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Cước gốc</td>
                                                                    <td>
                                                                        {{ formatNumber($shipment['shipment_amount_original']) }}đ
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="col-sm-8 mb-3">
                                                    <div class="d-flex justify-content-between mb-3">
                                                        <label class="fw-bold fs-6">
                                                            Chi phí vận hành công ty
                                                        </label>
                                                        @if (isGetAllData())
                                                            <button data-bs-toggle="modal"
                                                                data-bs-target="#exampleModalShipmentOperatingCosts"
                                                                class="btn btn-primary btn-sm">
                                                                <span>
                                                                    <span class="icon"><i
                                                                            class="fas fa-edit"></i></span>
                                                                    <span>Sửa chi phí</span>
                                                                </span>
                                                            </button>
                                                        @endif
                                                    </div>
                                                    <table class="table">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th scope="col">Nội dung</th>
                                                                <th scope="col">Giá/đơn vị</th>
                                                                <th scope="col">Số lượng</th>
                                                                <th scope="col">Tổng tiền</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="table_tbody_shipment_operating_costs">
                                                            @foreach ($shipment['shipmentOperatingCosts'] as $shipment_operating_cost)
                                                                <tr>
                                                                    <td>{{ $shipment_operating_cost['operating_cost_name'] }}
                                                                    </td>
                                                                    <td>{{ formatNumber($shipment_operating_cost['shipment_operating_cost_amount']) }}đ
                                                                    </td>
                                                                    <td>{{ $shipment_operating_cost['shipment_operating_cost_quantity'] }}
                                                                    </td>
                                                                    <td>{{ formatNumber($shipment_operating_cost['shipment_operating_cost_total_amount']) }}
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <p>- Giá trị bảo hiểm:
                                                {{ formatNumber($shipment['shipment_amount_insurance_value']) }}đ
                                            </p>
                                            <div class="{{ $shipment['service']['promotion_flg'] == IS_EPACKET ? 'd-none' : '' }}"
                                                id="content_profit">
                                                <p
                                                    class="{{ $shipment['shipment_amount_profit'] >= 0 ? 'text-success' : 'text-danger' }} fw-bold">
                                                    - Lợi nhuận thực tế:
                                                    {{ formatNumber($shipment['shipment_amount_profit']) }}đ
                                                </p>
                                            </div>
                                        @endif

                                    </div>
                                </div>
                            </div>
                        </section>





                    </div>
                    <div class="tab-pane fade" id="tab_shipment_packages_and_invoices">
                        <div class="text-start mb-3">
                            <a class="btn btn-warning"
                                href="{{ route('shipments.edit.show', ['shipment_code' => $shipment['shipment_code']]) }}">
                                <span>
                                    <span class="icon"><i class="fa fa-edit"></i></span>
                                    <span>Cập nhật lại thông tin Package Info & Invoice</span>
                                </span>
                            </a>
                        </div>
                        <div class="mb-5" id="table-packages">

                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered" style="text-align:center" width="100%">
                                <thead class="thead-dark">
                                    <tr>
                                        <th style="width: 10px">STT</th>
                                        <th>Tên mặt hàng</th>
                                        <th style="width:10%">Unit Type</th>
                                        <th style="width:10%">Unit</th>
                                        <th style="width:10%">Unit Price</th>
                                        <th style="width:10%">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($shipment['invoices'] as $invoice)
                                        <tr class="table-secondary">
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $invoice['invoice_goods_details'] }}</td>
                                            <td>{{ $invoice['invoice_unit_name'] }}</td>
                                            <td>{{ formatNumber($invoice['invoice_quantity']) }}</td>
                                            <td>{{ formatNumber($invoice['invoice_price']) }}</td>
                                            <td>{{ formatNumber($invoice['invoice_total_price']) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Page Body -->
        </div>
        <!-- Page Footer -->
        @include('layouts.footer')
        <!-- / Page Footer -->
    </div>
    @if ($is_view_shipment_operating_costs)
        <div class="modal fade" id="exampleModalShipmentOperatingCosts" tabindex="-1"
            aria-labelledby="exampleModalShipmentOperatingCostsLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable modal-lg">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h1 class="modal-title fs-5 text-white" id="exampleModalShipmentOperatingCostsLabel">
                            Cập nhật chi phí vận hành
                        </h1>
                    </div>
                    <div class="modal-body">
                        <form id="exampleModalShipmentOperatingCostsBody"></form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                        @if (isGetAllData())
                            <button type="button" id="on_save_operating_costs" class="btn btn-primary">Cập nhật chi
                                phí</button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif




    <div class="modal fade" id="exampleModalShipmentFee" tabindex="-1" aria-labelledby="exampleModalShipmentFeeLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h1 class="modal-title fs-5 text-white" id="exampleModalShipmentFeeLabel">
                        1/Chi phí phụ thu khách
                    </h1>
                </div>
                <div class="modal-body">
                    <h5 class="card-title mb-3">Giá cước</h5>
                    <div class=" mb-3">
                        <label for="form-label">Cước nội địa</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="shipment_domestic_charges"
                                value="{{ $shipment['shipment_domestic_charges'] }}">
                            <span class="input-group-text bg-gray-light-4">Giá tiền</span>
                        </div>
                        <small class="text-danger" id="shipment_domestic_charges_err"></small>
                    </div>
                    <div class=" mb-3">
                        <label for="form-label">Cước phụ thu</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="shipment_amount_surcharge"
                                value="{{ $shipment['shipment_amount_surcharge'] }}">
                            <span class="input-group-text bg-gray-light-4">Giá tiền</span>
                        </div>
                        <small class="text-danger" id="shipment_amount_surcharge_err"></small>
                    </div>
                    @php
                        $surcharge = hasSurchargeFeeService(null, $shipment);
                    @endphp
                    <div class="ms-3 {{ $surcharge ? '' : 'd-none' }}">
                        <small class="text-danger">Chi phí phụ thu theo dịch vụ</small>
                        <div class="mb-3">
                            <label for="form-label">Phí dân cư</label>
                            <div class="input-group">
                                <input type="number" class="form-control" id="shipment_amount_residential"
                                    value="{{ $shipment['shipment_amount_residential'] }}"
                                    {{ $shipment['service']['promotion_flg'] == IS_EPACKET ? 'readonly' : '' }}>
                                <span class="input-group-text bg-gray-light-4">Giá tiền</span>
                            </div>
                            <small class="text-danger" id="shipment_amount_residential_err"></small>
                        </div>
                        <div class="mb-3">
                            <label for="form-label">Phí cao điểm</label>
                            <div class="input-group">
                                <input type="number" class="form-control" id="shipment_amount_peak"
                                    value="{{ $shipment['shipment_amount_peak'] }}"
                                    {{ $shipment['service']['promotion_flg'] == IS_EPACKET ? 'readonly' : '' }}>
                                <span class="input-group-text bg-gray-light-4">Giá tiền</span>
                            </div>
                            <small class="text-danger" id="shipment_amount_peak_err"></small>
                        </div>
                    </div>
                    <div class=" mb-3">
                        <label for="form-label">Cước thu hộ</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="shipment_collection_fee"
                                value="{{ $shipment['shipment_collection_fee'] }}">
                            <span class="input-group-text bg-gray-light-4">Giá tiền</span>
                        </div>
                        <small class="text-danger" id="shipment_collection_fee_err"></small>
                    </div>
                    <div class=" mb-3">
                        <label for="form-label">Cước phí bảo hiểm</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="shipment_amount_insurance"
                                value="{{ $shipment['shipment_amount_insurance'] }}">
                            <span class="input-group-text bg-gray-light-4">Giá tiền</span>
                        </div>
                        <small class="text-danger" id="shipment_amount_insurance_err"></small>
                    </div>
                    <div class=" mb-3">
                        <label for="form-label">Giá cước VAT</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="shipment_amount_vat"
                                value="{{ $shipment['shipment_amount_vat'] }}">
                            <span class="input-group-text bg-gray-light-4">Giá tiền</span>
                        </div>
                        <small class="text-danger" id="shipment_amount_vat_err"></small>
                    </div>
                    <div class=" mb-3">
                        <label for="form-label">Cước gốc</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="shipment_amount_original"
                                value="{{ $shipment['shipment_amount_original'] }}"
                                {{ $shipment['service']['promotion_flg'] == IS_EPACKET ? 'readonly' : '' }}>
                            <span class="input-group-text bg-gray-light-4">Giá tiền</span>
                        </div>
                        <small class="text-danger" id="shipment_amount_original_err"></small>
                    </div>

                    <h5 class="card-title mb-3 {{ $shipment['service']['promotion_flg'] == IS_EPACKET ? 'd-none' : '' }}">
                        2/Thu tiền khách
                    </h5>
                    <div class="mb-3 {{ $shipment['service']['promotion_flg'] == IS_EPACKET ? 'd-none' : '' }}">
                        <label for="form-label"></label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="shipment_amount_total_customer"
                                value="{{ $shipment['shipment_amount_total_customer'] }}">
                            <span class="input-group-text bg-gray-light-4">Giá tiền</span>
                        </div>
                        <small class="text-danger" id="shipment_amount_total_customer_err"></small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                    @if (isGetAllData())
                        <button type="button" id="on_save_shipment_fee" class="btn btn-primary">Cập nhật chi
                            phí</button>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="importModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="importModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="importModalLabel">Modal title</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                        <span>Thông tin package</span>
                    </div>
                    <div class="">
                        <div class="col row">
                            <div class="col-sm-4 mb-3">
                                <label for="form-label">Length</label>
                                <input type="text" class="form-control" value="" id="package_length" readonly>
                            </div>
                            <div class="col-sm-4 mb-3">
                                <label for="form-label">Width</label>
                                <input type="text" class="form-control" value="" id="package_width" readonly>
                            </div>
                            <div class="col-sm-4 mb-3">
                                <label for="form-label">Height</label>
                                <input type="text" class="form-control" value="" id="package_height" readonly>
                            </div>
                        </div>
                    </div>
                    <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                        <span>Phí phụ thu mặt hàng</span>
                    </div>
                    <div class="" id="content-modal">

                    </div>
                    <div class="text-end">
                        <button class="btn btn-primary" onclick="addSurchageGood()">Thêm mặt hàng</button>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy bỏ</button>
                    <button type="button" class="btn btn-primary" id="btn_update_package">Xác nhận</button>
                </div>
            </div>
        </div>
    </div>
    @push('scripts')
        <script lang="javascript" src="{{ asset('assets/vendors/xlsx/dist/xlsx.full.min.js') }}"></script>
        <script>
            var shipment_code = @json($shipment['shipment_code']);
            var shipment_id = @json($shipment['shipment_id']);
        </script>
        <script src="{{ asset('js/shipment/detail.js') }}"></script>
    @endpush
@endsection
