@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content px-1">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>Create Shipment</h1>
                                    </a>
                                </div>
                                <div class="dropdown ms-3">

                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                <button class="btn btn-primary " onclick="onUpdateShipment()">
                                    <i class="fas fa-file-invoice me-1"></i> Hoàn thành
                                </button>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="contact-list-view mx-3">
                                    <div class="accordion accordion-flush" id="accordionFlushShipment">
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="flush-sender">
                                                <button class="accordion-button fw-bold" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#flush-collapseSender"
                                                    aria-expanded="true" aria-controls="flush-collapseSender">
                                                    Người gửi (Sender)
                                                </button>
                                            </h2>
                                            <div id="flush-collapseSender" class="accordion-collapse collapse show"
                                                aria-labelledby="flush-sender" data-bs-parent="#accordionFlushShipment">
                                                <div class="accordion-body" style="background-color:#f9f9f9;">
                                                    <form id="form-sender">
                                                        <section class="mt-3 ms-0">
                                                            <div class="row">
                                                                @if (!empty($sales))
                                                                    <div class="col-12">
                                                                        <div class="form-group">
                                                                            <label class="form-label fs-8">Tài khoản Sale
                                                                            </label>
                                                                            <select class="form-control select2"
                                                                                id="sale_id" name="sale_id">
                                                                                <option value="">Chọn Sale</option>
                                                                                @foreach ($sales as $key => $sale)
                                                                                    <option value="{{ $sale['user_id'] }}">
                                                                                        {{ $sale['user_contact_name'] }}
                                                                                        [{{ $sale['user_code'] }}]
                                                                                    </option>
                                                                                @endforeach
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                @endif
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Công ty (Company
                                                                            Name) * </label>
                                                                        <input type="text" name="sender_company_name"
                                                                            class="form-control required"
                                                                            value="{{ $user['user_company_name'] }}"
                                                                            placeholder="Tên người gửi" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Người LH (Contact
                                                                            Name) *
                                                                        </label>
                                                                        <input type="text" name="sender_contact_name"
                                                                            class="form-control required"
                                                                            value="{{ $user['user_contact_name'] }}"
                                                                            placeholder="Tên người gửi" required>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="form-label fs-8">Số Điện thoại (Telephone)
                                                                        *</label>
                                                                    <input type="number" name="sender_telephone"
                                                                        class="form-control required"
                                                                        value="{{ $user['user_phone'] }}"
                                                                        placeholder="Nhập SĐT" required>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="form-label fs-8">Tỉnh/Thành phố *</label>
                                                                    <select class="form-control select2 required"
                                                                        id="sender_city" name="sender_city" required>
                                                                        <option value="">Chọn Tỉnh/Thành phố</option>
                                                                        @foreach ($address['cities'] as $key_city => $city)
                                                                            <option value="{{ $key_city }}"
                                                                                {{ $user['user_address_1'] == $key_city ? 'selected' : '' }}>
                                                                                {{ $city }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="form-label fs-8">Quận/Huyện *</label>
                                                                    <select class="form-control select2 required"
                                                                        id="sender_district" name="sender_district"
                                                                        required>
                                                                        <option value="">Chọn Quận/Huyện</option>
                                                                        @foreach ($address['districts'] as $key_district => $district)
                                                                            <option value="{{ $key_district }}"
                                                                                {{ $user['user_address_2'] == $key_district ? 'selected' : '' }}>
                                                                                {{ $district }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="form-label fs-8">Phường/Xã *</label>
                                                                    <select class="form-control select2 required"
                                                                        id="sender_ward" name="sender_ward" required>
                                                                        <option value="">Phường/Xã</option>
                                                                        @foreach ($address['wards'] as $key_ward => $ward)
                                                                            <option value="{{ $key_ward }}"
                                                                                {{ $user['user_address_3'] == $key_ward ? 'selected' : '' }}>
                                                                                {{ $ward }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="form-label fs-8">Địa chỉ *</label>
                                                                    <input type="text" name="sender_address"
                                                                        class="form-control required" id="sender_address"
                                                                        value="{{ $user['user_address'] }}" placeholder="Nhập địa chỉ" required>
                                                                </div>
                                                                @include(
                                                                    'template.google-map.choose-and-input',
                                                                    [
                                                                        'is_inp' => false,
                                                                        'is_location' => false,
                                                                        'new_inp_id' => 'sender_address',
                                                                    ]
                                                                )
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox"
                                                                        id="isCreatePickup">
                                                                    <label class="form-check-label" for="isCreatePickup">
                                                                        Tạo Order Pickup
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        </section>
                                                        <div class="text-center mt-3">
                                                            <button type="button"
                                                                class="btn btn-custom btn-primary btn-rounded"
                                                                onclick="onNextAccordion('flush-collapseSender', 'flush-collapseReceiver')">
                                                                <span><span>Bước kế</span> <span class="icon"><span
                                                                            class="feather-icon"><i
                                                                                data-feather="arrow-right-circle"></i></span></span>
                                                                </span>
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="flush-receiver">
                                                <button class="accordion-button collapsed fw-bold" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#flush-collapseReceiver"
                                                    aria-expanded="false" aria-controls="flush-collapseReceiver">
                                                    Người nhận (Receiver)
                                                </button>
                                            </h2>
                                            <div id="flush-collapseReceiver" class="accordion-collapse collapse"
                                                aria-labelledby="flush-receiver" data-bs-parent="#accordionFlushShipment">
                                                <div class="accordion-body">
                                                    <form id="form-receiver">
                                                        <section class="mt-3 ms-0">
                                                            <div class="row">
                                                                <div class="form-group">
                                                                    <label class="form-label fs-8">Chọn người nhận
                                                                        cũ</label><br>
                                                                    <select class="form-control select2" id="receiver_id"
                                                                        name="receiver_id">
                                                                        <option value="">Chọn người nhận cũ</option>
                                                                        @foreach ($receivers as $receiver)
                                                                            <option
                                                                                value="{{ $receiver['receiver_id'] }}">
                                                                                {{ $receiver['receiver_contact_name'] }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Công ty (Company
                                                                            Name)</label>
                                                                        <input type="text" name="receiver_company_name"
                                                                            class="form-control" placeholder="Tên công ty"
                                                                            required>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Người Liên hệ
                                                                            (Contact Name)
                                                                            *</label>
                                                                        <input type="text" name="receiver_contact_name"
                                                                            class="form-control required"
                                                                            placeholder="Tên người nhận" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Số Điện thoại
                                                                            (Telephone)
                                                                            *</label>
                                                                        <input type="text" name="receiver_telephone"
                                                                            class="form-control required"
                                                                            placeholder="Số diện thoại người nhận"
                                                                            required>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Quốc gia (Country)
                                                                            *</label>
                                                                        <select class="form-control select2 required"
                                                                            required id="receiver_country_id"
                                                                            name="receiver_country_id">
                                                                            <option value="">Chọn quốc gia</option>
                                                                            @foreach ($countries as $country)
                                                                                <option
                                                                                    value="{{ $country['country_id'] }}">
                                                                                    {{ $country['country_name'] }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <div class="form-label-group">
                                                                            <label>Tỉnh
                                                                                (State/Province) *</label>
                                                                            <a id="openModalLocationState"
                                                                                data-bs-toggle="modal"
                                                                                data-bs-target="#stateModal"
                                                                                href="javascript:void(0)"
                                                                                class="fs-7 fw-medium"
                                                                                onclick="openModalState()">
                                                                                Mở danh sách khu vực
                                                                            </a>
                                                                        </div>
                                                                        <div class="input-group">
                                                                            <input type="text" class="form-control"
                                                                                placeholder="Mở danh sách để chọn khu vực có sẵn"
                                                                                id="receiver_state_name"
                                                                                name="receiver_state_name" required>
                                                                            <input type="number" id="receiver_state_id"
                                                                                name="receiver_state_id" hidden>
                                                                        </div>

                                                                        <div class="text-primary"
                                                                            id="receiver_state_noti"></div>
                                                                    </div>

                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <div class="form-label-group">
                                                                            <label>Thành Phố *</label>
                                                                            <a id="openModalLocationCity"
                                                                                data-bs-toggle="modal"
                                                                                data-bs-target="#cityWorldModal"
                                                                                href="javascript:void(0)"
                                                                                onclick="openModalCityWorld()"
                                                                                class="fs-7 fw-medium">
                                                                                Mở danh sách thành phố
                                                                            </a>
                                                                        </div>
                                                                        <div class="input-group">
                                                                            <input type="text" class="form-control"
                                                                                placeholder="Mở danh sách để chọn thành phố có sẵn"
                                                                                id="receiver_city_name"
                                                                                name="receiver_city_name" required
                                                                                readonly>
                                                                            <input type="number" id="receiver_city_id"
                                                                                name="receiver_city_id" hidden>
                                                                        </div>
                                                                        <div class="text-primary" id="receiver_city_noti">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Mã Bưu chính (Postal
                                                                            code)
                                                                            *</label>
                                                                        <input type="text" name="receiver_postal_code"
                                                                            class="form-control required" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Địa chỉ (address) 1
                                                                            *</label>
                                                                        <input type="text" name="receiver_address_1"
                                                                            class="form-control required"
                                                                            placeholder="Nhập địa chỉ người nhận" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Địa chỉ (address)
                                                                            2</label>
                                                                        <input type="text" name="receiver_address_2"
                                                                            class="form-control">
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-6">
                                                                    <div class="form-group">
                                                                        <label class="form-label fs-8">Địa chỉ (address)
                                                                            3</label>
                                                                        <input type="text" name="receiver_address_3"
                                                                            class="form-control">
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-12">
                                                                    <div class="form-check form-check-lg">
                                                                        <input type="checkbox" class="form-check-input"
                                                                            name="save_receiver_flg"
                                                                            id="save_receiver_flg">
                                                                        <label class="form-check-label"
                                                                            for="save_receiver_flg">
                                                                            Lưu thông tin người nhận
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </section>
                                                        <div class="text-center mt-3">
                                                            <button type="button"
                                                                class="btn btn-custom btn-primary btn-rounded"
                                                                onclick="onNextAccordion('flush-collapseReceiver', 'flush-collapseService')">
                                                                <span><span>Bước kế</span> <span class="icon"><span
                                                                            class="feather-icon"><i
                                                                                data-feather="arrow-right-circle"></i></span></span>
                                                                </span>
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="flush-service">
                                                <button class="accordion-button collapsed fw-bold" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#flush-collapseService"
                                                    aria-expanded="false" aria-controls="flush-collapseService">
                                                    Thông tin đơn hàng
                                                </button>
                                            </h2>
                                            <div id="flush-collapseService" class="accordion-collapse collapse"
                                                aria-labelledby="flush-service" data-bs-parent="#accordionFlushShipment">
                                                <div class="accordion-body">
                                                    <form id="form-service">
                                                        <section class="row mt-3 ms-0">
                                                            <div class="">
                                                                <div class="row">
                                                                    {{-- @if (!onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id']))
                                                                    @endif --}}
                                                                    <div class="col-sm-4">
                                                                        <label class="form-label fs-8">Loại dịch
                                                                            vụ</label>
                                                                        <select class="form-control"
                                                                            id="shipment_service_promotion_id"
                                                                            name="shipment_service_promotion_id">
                                                                            <option value="0">Chuyên tuyến
                                                                            </option>
                                                                            <option value="2">Epacket</option>
                                                                        </select>
                                                                    </div>
                                                                    <div class="col">
                                                                        <label class="form-label fs-8">Dịch vụ vận chuyển
                                                                            (Services)
                                                                            *</label>
                                                                        <select class="form-control select2 required"
                                                                            required id="shipment_service_id"
                                                                            name="shipment_service_id">
                                                                            <option value="">Chọn dịch vụ vận chuyển
                                                                            </option>
                                                                        </select>
                                                                    </div>

                                                                </div>

                                                                <div class="form-group mt-3">
                                                                    <div class="form-check form-check-lg">
                                                                        <input type="checkbox" id="shipment_signature_flg"
                                                                            name="shipment_signature_flg"
                                                                            class="form-check-input">
                                                                        <label for="shipment_signature_flg"
                                                                            class="form-check-label">
                                                                            Dịch vụ chữ ký người nhận
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="form-label fs-8">Chọn chi nhánh</label>
                                                                    <select class="form-control" name="shipment_branch_id"
                                                                        required>
                                                                        @foreach ($branchs as $branch)
                                                                            <option value="{{ $branch['branch_id'] }}">
                                                                                {{ $branch['branch_name'] }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="form-label fs-8">Reference Code</label>
                                                                    <input type="text" name="shipment_reference_code"
                                                                        class="form-control">
                                                                </div>
                                                                <div class="form-group">
                                                                    <div class="form-check form-check-lg">
                                                                        <input type="checkbox"
                                                                            name="agree_terms_use_service"
                                                                            class="form-check-input required" required
                                                                            id="agree_terms_use_service">
                                                                        <label class="form-check-label"
                                                                            for="agree_terms_use_service">
                                                                            Tuân Thủ
                                                                            <a href="javascript:void(0)"
                                                                                data-bs-toggle="modal"
                                                                                data-bs-target="#viewTermsUseService">
                                                                                Điều Khoản Sử Dụng Dịch Vụ của KANGO
                                                                                EXPRESS!
                                                                            </a>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </section>
                                                        <div class="text-center mt-3">
                                                            <button type="button"
                                                                class="btn btn-custom btn-primary btn-rounded"
                                                                onclick="onNextAccordion('flush-collapseService', 'flush-collapseInfo')">
                                                                <span><span>Bước kế</span> <span class="icon"><span
                                                                            class="feather-icon"><i
                                                                                data-feather="arrow-right-circle"></i></span></span>
                                                                </span>
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="flush-headingInfo">
                                                <button class="accordion-button collapsed fw-bold" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#flush-collapseInfo"
                                                    aria-expanded="false" aria-controls="flush-collapseInfo">
                                                    Thông tin Lô Hàng
                                                </button>
                                            </h2>
                                            <div id="flush-collapseInfo" class="accordion-collapse collapse"
                                                aria-labelledby="flush-headingInfo"
                                                data-bs-parent="#accordionFlushShipment">
                                                <div class="accordion-body">
                                                    <form id="form-info">
                                                        <section class="row mt-3 ms-0">
                                                            <div class="col-sm-3" id="information_shipment">
                                                                <div class="card mb-4">
                                                                    <div
                                                                        class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                                                                        <span>
                                                                            <span class="feather-icon"><i
                                                                                    data-feather="info"></i></span>
                                                                            Thông tin người gửi
                                                                        </span>
                                                                    </div>
                                                                    <div class="card-body mt-2">
                                                                        <p class="card-text">
                                                                            - Công ty:
                                                                            <strong id="info_sender_company">
                                                                                {{ $user['user_company_name'] }}
                                                                            </strong>
                                                                        </p>
                                                                        <p class="card-text">
                                                                            - Tên người gửi:
                                                                            <strong id="info_sender_contact_name">
                                                                                {{ $user['user_contact_name'] }}
                                                                            </strong>
                                                                        </p>
                                                                        <p class="card-text">
                                                                            - Số Điện Thoại:
                                                                            <strong id="info_sender_phone">
                                                                                {{ $user['user_phone'] }}
                                                                            </strong>
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                                <div class="card mb-4">
                                                                    <div
                                                                        class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag  overhead-start">
                                                                        <span>
                                                                            <span class="feather-icon"><i
                                                                                    data-feather="info"></i></span>
                                                                            Thông tin dịch vụ
                                                                        </span>
                                                                    </div>
                                                                    <div class="card-body mt-2">
                                                                        <p class="card-text">
                                                                            - Dịch vụ: <strong
                                                                                id="info_shipment_service"></strong>
                                                                        </p>
                                                                        <p class="card-text">
                                                                            - Brand: <strong
                                                                                id="info_shipment_branch">HCM</strong>
                                                                        </p>
                                                                        <p class="card-text">
                                                                            - Dịch vụ chữ ký người nhận: <strong
                                                                                id="info_shipment_signature">Không</strong>
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                                <div class="card">
                                                                    <div
                                                                        class="hk-ribbon-type-1 ribbon-wth-icon ribbon-wth-flag overhead-start">
                                                                        <span>
                                                                            <span class="feather-icon"><i
                                                                                    data-feather="info"></i></span>
                                                                            Thông tin người nhận
                                                                        </span>
                                                                    </div>
                                                                    <div class="card-body mt-2">
                                                                        <p class="card-text">
                                                                            - Công ty: <strong
                                                                                id="info_receiver_company"></strong>
                                                                        </p>
                                                                        <p class="card-text">
                                                                            - Tên người nhận: <strong
                                                                                id="info_receiver_contact_name"></strong>
                                                                        </p>
                                                                        <p class="card-text">
                                                                            - Số Điện Thoại: <strong
                                                                                id="info_receiver_phone"></strong>
                                                                        </p>
                                                                        <p class="card-text">
                                                                            - Địa chỉ: <strong
                                                                                id="info_receiver_address"></strong>
                                                                        </p>
                                                                        <p class="card-text">
                                                                            - Thành Phố: <strong
                                                                                id="info_receiver_city"></strong>
                                                                        </p>
                                                                        <p class="card-text">
                                                                            - Quốc Gia: <strong
                                                                                id="info_receiver_country"></strong>
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-9">
                                                                <div class="card mb-5">
                                                                    <div
                                                                        class="hk-ribbon-type-1 ribbon-wth-icon start-touch">
                                                                        <span>
                                                                            <span class="feather-icon"><i
                                                                                    data-feather="archive"></i></span>
                                                                            Thông tin kiện hàng
                                                                        </span>
                                                                    </div>
                                                                    <div class="card-body mt-4">
                                                                        <div class="row">
                                                                            <div class="col-sm-6">
                                                                                <div class="form-group">
                                                                                    <label class="form-label">Tên hàng hóa
                                                                                        *</label>
                                                                                    <input type="text"
                                                                                        name="shipment_goods_name"
                                                                                        class="form-control required"
                                                                                        required
                                                                                        placeholder="Nhập tên hàng hóa">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-sm-6">
                                                                                <div class="form-group">
                                                                                    <label class="form-label">Invoice Value
                                                                                        *</label>
                                                                                    <input type="number"
                                                                                        name="shipment_value"
                                                                                        class="form-control required"
                                                                                        required
                                                                                        placeholder="Nhập giá trị kiện hàng">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="table-responsive"
                                                                            style="overflow-y: hidden">
                                                                            <table class="table table-bordered mb-0">
                                                                                <thead>
                                                                                    <tr>
                                                                                        <th scope="col">Số kiện</th>
                                                                                        <th scope="col">Type</th>
                                                                                        <th scope="col">Length(Cm)</th>
                                                                                        <th scope="col">Width(Cm)</th>
                                                                                        <th scope="col">Heigth(Cm)</th>
                                                                                        <th scope="col">Weight(Kg)</th>
                                                                                        <th scope="col"></th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody id="table_tbody_packages"></tbody>
                                                                            </table>
                                                                        </div>
                                                                        <button type="button" id="btn_add_package"
                                                                            class="btn btn-sm btn-warning mt-2 d-flex flex-row align-items-center">
                                                                            <i class="fa fa-plus"></i>
                                                                            <span class="ms-2">Thêm kiện hàng</span>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                                <div class="card">
                                                                    <div
                                                                        class="hk-ribbon-type-1 ribbon-wth-icon start-touch">
                                                                        <span>
                                                                            <span class="feather-icon"><i
                                                                                    data-feather="archive"></i></span>
                                                                            Thông tin khai Invoice
                                                                        </span>
                                                                    </div>
                                                                    <div class="card-body mt-4">
                                                                        <div class="row">
                                                                            <div class="col-sm-6">
                                                                                <div class="form-group">
                                                                                    <label class="form-label">Export as
                                                                                        *</label>
                                                                                    <select class="form-select"
                                                                                        name="shipment_export_as">
                                                                                        @foreach ($invoice_exports_as as $key => $export_as)
                                                                                            <option
                                                                                                value="{{ $key }}">
                                                                                                {{ $export_as }}
                                                                                            </option>
                                                                                        @endforeach
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="table-responsive"
                                                                            style="overflow-y: hidden">
                                                                            <table class="table table-bordered mb-0">
                                                                                <thead>
                                                                                    <tr>
                                                                                        <th scope="col">GOODS DETAILS
                                                                                            (PRODUCT
                                                                                            NAMES, MATERIALS,
                                                                                            STAMPS,
                                                                                            ...)</th>
                                                                                        <th scope="col">QUANTITY</th>
                                                                                        <th scope="col">UNIT</th>
                                                                                        <th scope="col">PRICE</th>
                                                                                        <th scope="col">Total Value</th>
                                                                                        <th scope="col"></th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody id="table_tbody_invoices"></tbody>
                                                                            </table>
                                                                        </div>
                                                                        <button type="button" id="btn_add_invoice"
                                                                            class="btn btn-sm btn-warning mt-2 d-flex flex-row align-items-center">
                                                                            <i class="fa fa-plus"></i>
                                                                            <span class="ms-2">Thêm sản phẩm</span>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </section>
                                                        @if (onCheckPositionAccount(SETTING_SALE_ACCOUNT, auth()->user()['position_id']) ||
                                                                onCheckPositionAccount(SETTING_DOCUMENT_ACCOUNT, auth()->user()['position_id']))
                                                            <div id="form-choose-payment-type">
                                                                <div
                                                                    class="title title-wth-divider text-primary text-uppercase my-4">
                                                                    <span>Thanh toán</span>
                                                                </div>
                                                                <div class="card my-4">
                                                                    <div class="card-body">
                                                                        <div class="form-check">
                                                                            <input class="form-check-input" type="radio"
                                                                                value="{{ SHIPMENT_PAID_BY_REMAINING }}"
                                                                                name="shipment_paid_by"
                                                                                id="shipment_paid_by_remaining">
                                                                            <label class="form-check-label"
                                                                                for="shipment_paid_by_remaining">
                                                                                THANH TOÁN NỢ ( Dùng hạn mức )
                                                                            </label>
                                                                        </div>
                                                                        <div class="form-check">
                                                                            <input class="form-check-input" type="radio"
                                                                                value="{{ SHIPMENT_PAID_BY_WALLET }}"
                                                                                name="shipment_paid_by"
                                                                                id="shipment_paid_by_wallet" checked>
                                                                            <label class="form-check-label"
                                                                                for="shipment_paid_by_wallet">
                                                                                THANH TOÁN SAU
                                                                            </label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div
                                                                class="title title-wth-divider text-primary text-uppercase my-4">
                                                                <span>Chi phí phụ thu khách</span>
                                                            </div>
                                                            <div class="card my-4">
                                                                <div class="card-body mt-2">
                                                                    <h5 class="card-title text-primary mb-3">1/Giá cước
                                                                    </h5>
                                                                    <div class="row">
                                                                        <div class="col-md-6 mb-3">
                                                                            <label for="form-label">Cước nội địa</label>
                                                                            <div class="input-group">
                                                                                <input type="number" class="form-control"
                                                                                    id="shipment_domestic_charges"
                                                                                    value="0">
                                                                                <span
                                                                                    class="input-group-text bg-gray-light-4">Giá
                                                                                    tiền</span>
                                                                            </div>
                                                                            <small class="text-danger"
                                                                                id="shipment_domestic_charges_err"></small>
                                                                        </div>
                                                                        <div class="col-md-6 mb-3">
                                                                            <label for="form-label">Cước phụ thu</label>
                                                                            <div class="input-group">
                                                                                <input type="number" class="form-control"
                                                                                    id="shipment_amount_surcharge"
                                                                                    value="0">
                                                                                <span
                                                                                    class="input-group-text bg-gray-light-4">Giá
                                                                                    tiền</span>
                                                                            </div>
                                                                            <small class="text-danger"
                                                                                id="shipment_amount_surcharge_err"></small>
                                                                        </div>
                                                                        <div class="col-md-6 mb-3">
                                                                            <label for="form-label">Cước thu hộ</label>
                                                                            <div class="input-group">
                                                                                <input type="number" class="form-control"
                                                                                    id="shipment_collection_fee"
                                                                                    value="0">
                                                                                <span
                                                                                    class="input-group-text bg-gray-light-4">Giá
                                                                                    tiền</span>
                                                                            </div>
                                                                            <small class="text-danger"
                                                                                id="shipment_collection_fee_err"></small>
                                                                        </div>
                                                                        <div class="col-md-6 mb-3">
                                                                            <label for="form-label">Cước phí bảo
                                                                                hiểm</label>
                                                                            <div class="input-group">
                                                                                <input type="number" class="form-control"
                                                                                    id="shipment_amount_insurance"
                                                                                    value="0">
                                                                                <span
                                                                                    class="input-group-text bg-gray-light-4">Giá
                                                                                    tiền</span>
                                                                            </div>
                                                                            <small class="text-danger"
                                                                                id="shipment_amount_insurance_err"></small>
                                                                        </div>
                                                                        <div class="col-md-6 mb-3">
                                                                            <label for="form-label">Giá cước VAT</label>
                                                                            <div class="input-group">
                                                                                <input type="number" class="form-control"
                                                                                    id="shipment_amount_vat"
                                                                                    value="0">
                                                                                <span
                                                                                    class="input-group-text bg-gray-light-4">Giá
                                                                                    tiền</span>
                                                                            </div>
                                                                            <small class="text-danger"
                                                                                id="shipment_amount_vat_err"></small>
                                                                        </div>
                                                                        <div class="col-md-6 mb-3">
                                                                            <label for="form-label">Cước gốc</label>
                                                                            <div class="input-group">
                                                                                <input type="number" class="form-control"
                                                                                    id="shipment_amount_original"
                                                                                    value="0">
                                                                                <span
                                                                                    class="input-group-text bg-gray-light-4">Giá
                                                                                    tiền</span>
                                                                            </div>
                                                                            <small class="text-danger"
                                                                                id="shipment_amount_original_err"></small>
                                                                        </div>
                                                                    </div>
                                                                    <h5 class="card-title text-primary mb-3">2/Thu tiền
                                                                        khách
                                                                    </h5>
                                                                    <div class="row">
                                                                        <div class="col-md-12 mb-3">
                                                                            <label for="form-label">Thu khách</label>
                                                                            <div class="input-group">
                                                                                <input type="number" class="form-control"
                                                                                    id="shipment_amount_total_customer"
                                                                                    value="0">
                                                                                <span
                                                                                    class="input-group-text bg-gray-light-4">Giá
                                                                                    tiền</span>
                                                                            </div>
                                                                            <small class="text-danger"
                                                                                id="shipment_amount_total_customer_err"></small>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endif

                                                        <div class="text-center">
                                                            <button type="submit" class="btn btn-primary"
                                                                onclick="onUpdateShipment()">
                                                                <i class="fas fa-file-invoice me-1"></i> Hoàn thành
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @include('supports.areas.modals-area')

            <!-- Modal hiển thị điều khoản -->
            <div class="modal fade" id="viewTermsUseService" tabindex="-1" role="dialog"
                aria-labelledby="viewTermsUseServiceTitle" aria-hidden="true">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            @php
                                $path = 'public/config/terms-interface.json';
                                $content = Illuminate\Support\Facades\Storage::get($path);
                                $content = isset($content) ? $content : '';
                            @endphp
                            {!! $content !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')
        <script src="{{ asset('assets/vendors/jquery-steps/build/jquery.steps.min.js') }}"></script>
        <script>
            var package_types = @json($package_types);
            var invoice_units = @json($invoice_units);
        </script>
        <script src="{{ asset('js/shipment/sm-select-areas.js') }}"></script>
        <script src="{{ asset('js/shipment/create.js') }}"></script>
    @endpush
@endsection
