<div class="table-responsive">
    <table class="table nowrap w-100 mb-5 dataTable no-footer">
        <thead class="thead-dark">
            <tr role="row">
                <th rowspan="1" colspan="1"></th>
                <th class="sorting fw-bold">
                    MÃ HAWB
                </th>
                <th class="sorting fw-bold">
                    TYPE
                </th>
                <th class="sorting fw-bold">
                    WEIGHT(KG)
                </th>
                <th class="fw-bold">
                    CONVERTED WEIGHT
                </th>
                <th class="fw-bold">
                    CHARGED WEIGHT
                </th>
                <th class="fw-bold">
                    STATUS
                </th>
                <th class="fw-bold">
                    TRACKING CODE
                </th>
            </tr>
        </thead>
        <tbody>
            @php
                $colors = ['secondary', 'info', 'success', 'danger', 'danger'];
            @endphp
            @foreach ($packages as $key_package => $package)
                @php
                    $is_epacket_imported = false;
                @endphp
                <tr class="odd">
                    <td>
                        <button class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            onclick="onActionBtnShowClick(this)" data-bs-toggle="collapse"
                            data-bs-target="#package_{{ $key_package }}" aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>
                        {{-- <a class="fw-bold text-primary" href="{{ route('shipments.location.show') }}"> --}}
                        <a class="fw-bold text-primary" href="{{ getUrlTracking($package['package_hawb_code']) }}">
                            {{ $package['package_hawb_code'] }}
                            <i class="ms-3 fas fa-map-marker-alt"></i>
                        </a>
                    </td>
                    <td>{{ $package['package_type_name'] }}</td>
                    <td class="fw-bold">{{ $package['package_weight'] }}kg</td>
                    <td>
                        {{ $package['package_length']  }}(<strong>L</strong>)
                        x
                        {{ $package['package_width']  }}(<strong>W</strong>)
                        x
                        {{ $package['package_height']  }}(<strong>H</strong>)
                        /
                        {{ $shipment['service']['service_volumetric_mass'] }}
                        =
                        {{ $package['package_converted_weight']  }}kg
                    </td>
                    <td class="fw-bold">{{ $package['package_charged_weight'] }}kg</td>
                    <td class="fw-bold">
                        <small class="badge badge-{{ $colors[$package['package_status']] }}">
                            <i class="far fa-clock"></i>
                            {{ $package['package_status_name'] }}
                        </small>
                        @foreach (onConvertStrArrImage($package['package_image']) as $item)
                            <a class="p-2" href="{{ asset($item) }}" target="_blank"><i
                                    class="fas fa-image"></i></a>
                        @endforeach
                    </td>
                    <td class="fw-bold">{{ $package['package_tracking_code'] }}</td>
                </tr>
                <tr class="child collapse" id="package_{{ $key_package }}">
                    <td class="child" colspan="8">
                        <ul data-dtr-index="0" class="dtr-details">
                            <li data-dtr-index="8" data-dt-row="0" data-dt-column="8">
                                <span class="dtr-data">Nhân viên xử lý:</span>
                                <span class="dtr-title">
                                    @foreach ($package->history_scans as $key => $history_scan)
                                        <p>{{ $history_scan->user_contact_name }} <span
                                                class="fw-bold">({{ $history_scan->status_label }}sp)</span></p>
                                    @endforeach
                                </span>
                            </li>
                            <li>
                                <span class="dtr-title">Phụ thu mặt hàng</span>
                                @if (
                                    $package['package_status'] != SHIPMENT_STATUS_CREATE &&
                                        !onCheckPositionAccounts([SETTING_FWD_ACCOUNT, SETTING_SALE_ACCOUNT], auth()->user()['position_id']))
                                    <button class="btn btn-icon btn-flush-primary btn-sm"
                                        onclick="getPackageDetail('{{ $package['package_hawb_code'] }}')"><span
                                            class="icon"><i class="fas fa-edit"></i></span></button>
                                @endif
                                <br>
                                @foreach ($package['packages_sg'] as $key => $value)
                                    <p>{{ $value['surcharge_goods_name'] ?? $value['external_surcharge_name'] }} <span
                                            class="fw-bold">({{ $value['count'] }}sp)</span> :
                                        {{ formatNumber($value['count'] * $value['price']) }}</p>
                                @endforeach
                            </li>
                        </ul>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
