<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th>ID Bill</th>
                <th>Địa chỉ</th>
                <th>Ngày</th>
                <th>Dịch vụ</th>
                <th>Người nhận</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($shipments as $key => $shipment)
                <tr class="odd">
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="{{ route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']]) }}">
                            {{ $shipment['shipment_code'] }}
                        </a>
                    </td>
                    <td>
                        [<b>{{ $shipment['country']['country_name'] }}</b>]
                        - {{ $shipment['receiver_address_1'] }}
                    </td>
                    <td>{{ formatFullDate($shipment['created_at']) }}</td>
                    <td>
                        {{ $shipment['service']['service_name'] }}
                    </td>
                    <td>{{ $shipment['receiver_contact_name'] }}</td>
                    <td>
                        <button type="button" class="btn btn-success button-approve-shipment"
                            data-shipment_code="{{ $shipment['shipment_code'] }}">
                            <i class="fa fa-check"></i>
                        </button>
                        <button type="button" class="btn btn-danger button-delete-shipment"
                            data-shipment_code="{{ $shipment['shipment_code'] }}">
                            <i class="fa fa-trash"></i>
                        </button>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $shipments->links('components.pagination') }}
</div>
