@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper">
        <div class="container-xxl">

            <div class="hk-pg-header pg-header-wth-tab pt-7">
                <h3>Scan Nhập Hàng [Mã package: {{ $package['package_code'] }}]</h3>
            </div>
            <input type="text" id="scan_code" value="{{ $package['package_code'] }}" hidden>
            <div class="hk-pg-body ">

                <div class="d-flex justify-content-center align-items-center">
                    <div class="card">
                        <div class="card-body">
                            <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                                <span>Thông tin package</span>
                            </div>
                            <div class="">
                                <div class="col row">
                                    <div class="col-12 mb-3">
                                        Mã Bill: <span class="fw-bold"
                                            id="shipment_code">{{ $shipment['shipment_code'] }}</span>
                                    </div>
                                    <p class="text-danger">Scan: {{ $count_scan }}</p>
                                    <div class="col-sm-6 mb-3">
                                        <label for="form-label">Length</label>
                                        <input type="number" class="form-control" value="{{ $package['package_length'] }}"
                                            id="package_length" step="0.1">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label for="form-label">Width</label>
                                        <input type="number" class="form-control" value="{{ $package['package_width'] }}"
                                            id="package_width" step="0.1">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label for="form-label">Height</label>
                                        <input type="number" class="form-control" value="{{ $package['package_height'] }}"
                                            id="package_height" step="0.1">
                                    </div>
                                    <div class="col-sm-6 mb-3">
                                        <label for="form-label">Weight</label>
                                        <input type="number" class="form-control" value="{{ $package['package_weight'] }}"
                                            id="package_weight" step="0.1">
                                    </div>
                                </div>
                            </div>
                            <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                                <span>Phí phụ thu mặt hàng</span>
                            </div>
                            <div class="" id="content-modal">

                            </div>
                            <div class="text-end">
                                <button class="btn btn-primary" id="add-surchage" onclick="addSurchageGood()" disabled>Thêm
                                    mặt hàng</button>
                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="button" class="btn btn-primary" id="btn_imported">Xác nhận</button>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </div>

    @push('scripts')
        <script>
            let status_scan = `{{ SHIPMENT_STATUS_IMPORTED }}`
        </script>
        <script src="{{ asset('js/scan/imported.js') }}"></script>
    @endpush
@endsection
