@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper">
        <div class="container-xxl">

            <div class="hk-pg-header pg-header-wth-tab pt-7 row">

                <div class="col-md-6">
                    <h3> Scan bag code</h3>
                </div>
                <div class="col-md-6">
                    <div class="input-group mb-3">
                        <input type="text" value="{{ $sm_tracktry_id }}" id="sm_tracktry_id" hidden>
                        <input value="{{ $name_mawb }}" type="text" class="form-control" placeholder="Chọn mã MAWB" id="name_mawb" readonly>
                        <button class="btn btn-primary" type="button" data-bs-toggle="offcanvas" data-bs-target="#listMawb"
                            aria-controls="listMawb" onclick="fetchData()">MAWB <i class="fas fa-plane-departure ms-1"></i></button>
                    </div>
                </div>
            </div>
            <hr>
            <div class="hk-pg-body">

                <x-quagga-scan />
                {{-- <div class="" id="interactive"></div> --}}
                <div class="text-center">
                    <button type="button" class="btn btn-primary" id="btn_scan_barcode">
                        <span>
                            <span>Xác nhận</span>
                            <span class="icon"><i class="fa fa-barcode"></i></span>
                        </span>
                    </button>
                </div>
            </div>
        </div>

    </div>

    <div class="offcanvas offcanvas-start w-sm-50" tabindex="-1" id="listMawb" aria-labelledby="listMawbLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="listMawbLabel">Danh sách các MAWB</h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <div class="input-group mb-3">
                <input type="text" class="form-control" placeholder="Nhập từ khóa" id="keywords">
                <button class="btn btn-primary" type="button" onclick="fetchData()"><i class="fas fa-search"></i></button>
            </div>
            <div id="content">

            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            let status_scan = null
        </script>
        <script src="{{ asset('js/scan/index.js') }}"></script>
    @endpush
@endsection
