@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content ps-3">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>LIST SCAN NHẬP</h1>
                                    </a>
                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                {{-- <div class="" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Tìm kiểm nâng cao">
                                    <a class="btn btn-icon btn-flush-dark btn-rounded 
                                    flush-soft-hover no-caret d-sm-inline-block d-none"
                                        data-bs-toggle="collapse" href="#searchPlus" role="button" aria-expanded="false"
                                        aria-controls="collapseExample">
                                        <span class="icon">
                                            <span class="feather-icon">
                                                <i data-feather="search"></i>
                                            </span>
                                        </span></a>
                                </div> --}}
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="collapse show" id="searchPlus">
                                    <div class="card card-body">
                                        <div class="col-12 row">
                                            <div class="col-md-4">
                                                <label for="" class="form-lable">Từ ngày đến ngày</label>
                                                <div class="input-group">
                                                    <span class="input-affix-wrapper">
                                                        <span class="input-prefix"><span class="feather-icon"><i
                                                                    data-feather="calendar"></i></span></span>
                                                        <input class="form-control form-wth-icon" name="datetimes"
                                                            value="Aug 18,2020 - Aug 19, 2020">
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="mb-3 col-md-4">
                                                <label class="form-lable">Dịch vụ</label>
                                                <select class="form-control select2 select2-multiple"
                                                    id="service_ids" multiple>
                                                    @foreach ($services as $key => $service)
                                                        <option value="{{ $service['service_id'] }}">
                                                            {{ $service['service_name'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="mb-3 col-md-4">
                                                <label for="" class="form-lable">Tìm kiếm</label>
                                                <input type="search" class="form-control" placeholder="Search"
                                                    id="keywords">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="contact-list-view">
                                    <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                       
                                        <div class="" id="content"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')
        <!-- Dropify JS -->
        <script src="{{ asset('assets/vendors/dropify/dist/js/dropify.min.js') }}"></script>
        <script src="{{ asset('assets/dist/js/dropify-data.js') }}"></script>

        <script>
            // Hàm mở modal
            let status_scan = `{{ SHIPMENT_STATUS_IMPORTED }}`
            let over_time = null

            function openModal() {
                $('#rulesModal').modal('show');
            }
            $(".select2").select2();
        </script>
        <script src="{{ asset('js/scan/list/import.js') }}"></script>
    @endpush
@endsection
