<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>PRINT LABEL KANGO BAG CODE</title>
    <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
    <link rel="icon" href="{{ asset('assets/images/favicon.ico') }}" type="image/x-icon">
    <!-- CSS -->
    <link href="{{ asset('assets/dist/css/style.css') }}" rel="stylesheet" type="text/css">
    <style>
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }

        @media print {
            @page {
                margin-left: 0in;
                margin-right: 0in;
                margin-top: 0in;
                margin-bottom: 0;
            }

            .pt-5 {
                padding-top: 1.3rem !important;
            }

            .form-print-bill {
                width: 100%;
                height: 100vh;
            }
            .fs-1 {
                font-size: 1rem !important;
            }
            .fs-5 {
                font-size: 0.7rem !important;
            }

            .fs-6 {
                font-size: 0.7rem !important;
            }

            .fs-7 {
                font-size: 0.6rem !important;
            }

            .fs-8 {
                font-size: 0.5rem !important;
            }

            .mt-3 {
                margin-top: 0.3rem !important;
            }

            .mb-3 {
                margin-bottom: 0.3rem !important;
            }

            .mb-4 {
                margin-bottom: 0.4rem !important;
            }

            .mb-5 {
                margin-bottom: 0.5rem !important;
            }

            .container {
                max-width: 100% !important;
            }

            .a4 {
                width: 210mm;
                height: 297mm;
                border: 1px solid black;
                /* Tùy chọn: chỉ để hiển thị phần khung A4 */
            }
            .dest {
                transform: scale(2);
                margin-bottom: 10px;
                font-weight: bold;
            }

            .code {
                margin-top: 10px;
            }
        }
    </style>
</head>

<body>

    @foreach ($bag_codes as $key_package => $bag)
        <div class="d-flex justify-content-center align-items-center form-print-bill container">
            <div class="p-5 pt-5">
                <div class="text-center fs-3 dest">
                    {{ $bag_code['dest_code'] }}
                </div>
                {!! $bag['barcode'] !!}
                <div class="text-center code mt-1">
                    {{ $bag['item_code'] }}
                </div>
            </div>
        </div>
    @endforeach
    <script>
        var is_printed = false;
        window.onload = async function() {
            await window.scrollTo(0, 0);
            if (window.scrollY == 0 && !is_printed) {
                is_printed = true;
                window.print();
            }
            window.addEventListener('scroll', function() {
                if (window.scrollY == 0 && !is_printed) {
                    is_printed = true;
                    window.print();
                }
            });
        }
    </script>
</body>

</html>
