@extends('layouts.app')
@section('content')
    <style>
        ._failed {
            border-bottom: solid 4px red !important;
        }

        ._failed i {
            color: red !important;
        }

        ._success {
            box-shadow: 0 15px 25px #00000019;
            padding: 45px;
            width: 100%;
            text-align: center;
            margin: 40px auto;
            border-bottom: solid 4px #28a745;
        }

        ._success i {
            font-size: 55px;
            color: #28a745;
        }

        ._success h2 {
            margin-bottom: 12px;
            font-size: 40px;
            font-weight: 500;
            line-height: 1.2;
            margin-top: 10px;
        }

        ._success p {
            margin-bottom: 0px;
            font-size: 18px;
            color: #495057;
            font-weight: 500;
        }
    </style>
    <div class="hk-pg-wrapper">
        <div class="container">
            <div class="container">
                @if ($result['status'])
                    <div class="row justify-content-center">
                        <div class="col-md-5">
                            <div class="message-box _success">
                                <i class="fa fa-check-circle" aria-hidden="true"></i>
                                <h2> Giao dịch thành công </h2>
                                {{-- <p> Tài khoản của bạn đã được cộng tiền </p>
                                <hr class="my-3"> --}}
                                <div class="text-start">
                                    <p> <strong>Mã giao dịch: </strong>{{ $result['data']['vnp_TxnRef'] }}</p>
                                    <p> <strong>Ngân hàng: </strong>{{ $result['data']['vnp_BankCode'] }}</p>
                                    <p> <strong>Số tiền: </strong>{{ number_format($result['data']['vnp_Amount']/100) }}</p>
                                    <p> <strong>Ngày giao dịch: </strong>{{ $result['data']['date'] }}</p>
                                    <p> <strong>Nội dung: </strong>{{ $result['data']['vnp_OrderInfo'] }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="row justify-content-center">
                        <div class="col-md-5">
                            <div class="message-box _success _failed">
                                <i class="fa fa-times-circle" aria-hidden="true"></i>
                                <h2> Giao dịch thất bại </h2>
                                <p> {{ $result['message'] }} </p>

                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
