@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="hk-pg-header pg-header-wth-tab">
                <div class="contactapp-wrap">
                    <div class="contactapp-content p-0">
                        <div class="contactapp-detail-wrap">
                            <header class="contact-header">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>Danh sách yêu cầu nạp</h1>
                                    </a>
                                </div>
                                <div class="integrations-options-wrap justify-content-end flex-1 d-md-flex d-none">
                                    <ul class="nav nav-icon nav-tabs nav-justified nav-segmented-tabs nav-light mt-0 mx-3"
                                        style="min-width: 400px;">
                                        <li class="nav-item">
                                            <a class="nav-link" data-bs-toggle="tab" href="#chart">
                                                <span class="nav-icon-wrap"><span class="feather-icon"><i
                                                            data-feather="bar-chart-2"></i></span></span>
                                                <span class="nav-link-text">Biểu đồ</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link active" data-bs-toggle="tab" href="#list">
                                                <span class="nav-icon-wrap"><span class="feather-icon"><i
                                                            data-feather="file-text"></i></span></span>
                                                <span class="nav-link-text">Danh sách</span>
                                            </a>
                                        </li>
                                    </ul>
                                    <a type="button" class="btn btn-primary btn-sm" data-bs-toggle="offcanvas"
                                        data-bs-target="#offcanvasRight" aria-controls="offcanvasExample">
                                        <span>
                                            <span class="icon"><i class='bx bxs-wallet'></i></span>
                                            <span>Nạp tiền cho TK khác</span>
                                        </span>
                                    </a>
                                    <div class="v-separator d-lg-block d-none"></div>
                                    <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover dropdown-toggle no-caret  d-lg-inline-block d-none  ms-sm-0"
                                        href="#" data-bs-toggle="dropdown"><span class="icon"
                                            data-bs-toggle="tooltip" data-placement="top" title=""
                                            data-bs-original-title="Cài đặt nạp"><span class="feather-icon"><i
                                                    data-feather="settings"></i></span></span></a>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        @foreach ($recharge_settings as $key => $recharge_setting)
                                            <a class="dropdown-item" id="setting-{{ $recharge_setting['key'] }}" 
                                            data-bs-toggle="modal" onclick="onSetContentPayment({{ $recharge_setting['id'] }}, '{{ $recharge_setting['key'] }}')"
                                                data-bs-target="#notePaymentModal">{{ $recharge_setting['title'] }}</a>
                                        @endforeach
                                       
                                    </div>
                                    <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover hk-navbar-togglable"
                                        href="#" data-bs-toggle="tooltip" data-bs-placement="top" title=""
                                        data-bs-original-title="">
                                        <span class="icon">
                                            <span class="feather-icon"><svg xmlns="http://www.w3.org/2000/svg"
                                                    width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                    stroke-linejoin="round" class="feather feather-chevron-up">
                                                    <polyline points="18 15 12 9 6 15"></polyline>
                                                </svg></span>
                                            <span class="feather-icon d-none"><svg xmlns="http://www.w3.org/2000/svg"
                                                    width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                    stroke-linejoin="round" class="feather feather-chevron-down">
                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                </svg></span>
                                        </span>
                                    </a>
                                </div>
                            </header>
                            <div class="contact-body">
                                <div data-simplebar class="nicescroll-bar">

                                    <div class="collapse p-5" id="chart">
                                        <div class="card">
                                            <div class="card-header card-header-action">
                                                <div class="">
                                                    <div class="input-group">
                                                        <select name="" id="kind_chart" class="form-control"
                                                            onchange="getStatiscal()">
                                                            <option value="day">Theo ngày</option>
                                                            <option value="month">Theo tháng</option>
                                                            <option value="year">Theo năm</option>
                                                        </select>
                                                        <select name="" id="status_chart" class="form-control"
                                                            onchange="getStatiscal()">
                                                            <option value="1">Thành công</option>
                                                            <option value="0">Chờ xác nhận</option>
                                                            <option value="2">Thất bại</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <h6>Biểu đồ thống kê tổng số tiền của các đơn yêu cầu nạp tiền</h6>


                                                <div class="card-action-wrap">

                                                    

                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div id="column_chart_1"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse show active" id="list">
                                        <div>
                                            <div class="card card-body mx-3 ">
                                                <div class="row">
                                                    {{-- <div class="col-sm-3 mb-3">
                                                        <label for="" class="form-label">Từ ngày</label>
                                                        <input type="date" class="form-control" id="start_date">
                                                    </div>
                                                    <div class="col-sm-3 mb-3">
                                                        <label for="" class="form-label">Từ ngày</label>
                                                        <input type="date" class="form-control" id="end_date">
                                                    </div> --}}
                                                    <div class="col-sm-3 mb-3">
                                                        <label class="form-label">Trạng thái *</label>
                                                        <select name="" id="status" class="form-select">
                                                            <option value="">Tất cả</option>
                                                            <option value="{{ PENDING }}">Chờ xét duyệt</option>
                                                            <option value="{{ SUCCESS }}">Thành công</option>
                                                            <option value="{{ FAIL }}">Thất bại</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-sm-4 mb-3">
                                                        <label class="form-label">Thời gian</label>
                                                        <div class="form-group">
                                                            <input type="text" name="discount_user_daterange"
                                                                class="form-control">
                                                            <small id="error_discount_user_daterange"
                                                                class="text-danger"></small>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-5 mb-3">
                                                        <label for="" class="form-label">Tìm kiếm theo</label>
                                                        <div class="input-group">
                                                            <select name="" id="key_type" class="form-select">
                                                                <option value="code">Mã</option>
                                                                <option value="email">Email</option>
                                                            </select>
                                                            <input id="keywords" type="text" class="form-control"
                                                                placeholder="">
                                                            <button class="btn btn-primary" onclick="getListRecharge()"
                                                                type="button"><i class="fas fa-search"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="contact-list-view" id="content-recharge">
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>




        </div>
        <!-- /Page Body -->
    </div>

    <div class="offcanvas w-md-50 offcanvas-end" tabindex="-1" id="offcanvasRecharge"
        aria-labelledby="offcanvasTopLabel">
        <div class="offcanvas-header bg-primary">
            <h5 id="offcanvasRechargeLabel" class="text-white">Chi tiết yêu cầu</h5>
            <button type="button" class="btn-close text-reset text-white" data-bs-dismiss="offcanvas"
                aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <div id="content-recharge-detail">

            </div>
        </div>
    </div>

    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasTopLabel">
        <div class="offcanvas-header bg-primary">
            <h5 id="offcanvasRightLabel" class="text-white">Nạp tiền</h5>
            <button type="button" class="btn-close text-reset text-white" data-bs-dismiss="offcanvas"
                aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <div class="mb-3">
                <label for="" class="control-label">Chọn đối tượng nạp</label>
                <select required class="form-control select2" name="recharge-user" id="recharge-user">
                    @foreach ($users as $key => $value)
                        <option value="{{ $value['user_id'] }}">{{ $value['user_name'] }}</option>
                    @endforeach
                </select>
                <div id="recharge-user_err" class="invalid-feedback"></div>
            </div>
            <div class="mb-3">
                <label for="" class="control-label">Số tiền nạp</label>
                <input type="text" class="form-control text-number" id="admin_amount_recharge"
                    placeholder="Nhập số tiền bạn đã chuyển khoản">
                <div id="admin_amount_recharge_err" class="invalid-feedback"></div>
            </div>
            <div class="mb-3">
                <label for="" class="control-label">Ghi chú</label>
                <textarea class="form-control" id="admin_note_recharge" rows="3"></textarea>
                <div id="admin_note_recharge_err" class="invalid-feedback"></div>
            </div>
            <div class="mb-3">
                <label for="" class="control-label">Bằng chứng</label>
                <div class="dropzone" id="adminRechargeDropzone"></div>
                <div id="image_recharge_err" class="invalid-feedback"></div>
                <small class="text-danger">* Ngoại trừ thanh toán trực tuyến các thanh toán còn lại cần phải có bằng chứng chuyển tiền</small>
            </div>
            <div class="mb-3">
                @foreach ($recharge_settings as $key => $recharge_setting)
                    <div class="btn btn-flush-dark btn-animated text-start w-100">
                        <input class="form-check-input" value="{{ $recharge_setting['id'] }}" type="radio"
                            name="admin_pay_kind" id="admin_pay_{{ $recharge_setting['key'] }}" {{ $key == 'vnpay' ? 'checked' : '' }}>
                        <label class="form-check-label" for="admin_pay_{{ $recharge_setting['key'] }}">
                            {{ $recharge_setting['title'] }}
                        </label>
                    </div>
                @endforeach
                {{-- <div class="btn btn-flush-dark btn-animated text-start w-100">
                    <input class="form-check-input" type="radio" name="admin_pay_kind" id="admin_pay_usdt">
                    <label class="form-check-label" for="admin_pay_usdt">
                        Thanh toán bằng USDT
                    </label>
                </div>
                <div class="col btn btn-flush-dark btn-animated text-start w-100">
                    <input class="form-check-input" type="radio" name="admin_pay_kind" id="admin_pay_direct">
                    <label class="form-check-label" for="admin_pay_direct">
                        Nộp tiền trực tiếp
                    </label>
                </div>
                <div class="col btn btn-flush-dark btn-animated text-start w-100">
                    <input class="form-check-input" type="radio" name="admin_pay_kind" id="admin_pay_vnpay" checked>
                    <label class="form-check-label" for="admin_pay_vnpay">
                        Thanh toán qua vnpay
                    </label>
                </div>
                <div class="col btn btn-flush-dark btn-animated text-start w-100">
                    <input class="form-check-input" type="radio" name="admin_pay_kind" id="admin_pay_personal">
                    <label class="form-check-label" for="admin_pay_personal">
                        Tài khoản cá nhân
                    </label>
                </div> --}}
            </div>
            <div class="text-center">
                <button onclick="onCreateRechargeAdmin()"
                    class="btn  btn-custom  btn-primary icon-wthot-bg btn-rounded mb-4">
                    <span>
                        <span>Xác nhận</span>
                        <span class="icon"><i class="fas fa-plus"></i></span>
                    </span>
                </button>
            </div>
        </div>
    </div>


    <div class="modal fade" id="notePaymentModal" tabindex="-1" role="dialog" aria-labelledby="notePaymentModal"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="title-setting-modal">Cài đặt </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="">Thông tin ghi chú cho người nạp</label>
                        <div id="editor"></div>
                        <div id="content-usdt-inp"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    {{-- <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button> --}}
                    <button type="button" class="btn btn-primary" id="save_setting">Cập nhật</button>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/vendors/apexcharts/dist/apexcharts.min.js') }}"></script>
        <script src="{{ asset('assets/vendors/ckeditor5/build/ckeditor.js') }}"></script>
        <script>
            $(".select2").select2({
                dropdownParent: $('#offcanvasRight')
            });

            $('input[name="discount_user_daterange"]').daterangepicker({
                opens: 'left',
                startDate: moment().subtract(3, 'months').startOf('month'),
                endDate: moment().endOf('month'),
                locale: {
                    format: 'DD/MM/YYYY',
                    applyLabel: "Áp dụng",
                    cancelLabel: "Hủy",
                    customRangeLabel: "Tùy chỉnh",
                    daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                    monthNames: [
                        "Tháng 1",
                        "Tháng 2",
                        "Tháng 3",
                        "Tháng 4",
                        "Tháng 5",
                        "Tháng 6",
                        "Tháng 7",
                        "Tháng 8",
                        "Tháng 9",
                        "Tháng 10",
                        "Tháng 11",
                        "Tháng 12",
                    ],
                }
            }, function(start, end, label) {

            });
            
        </script>
        <script src="{{ asset('js/manage/recharge/index.js') }}"></script>
    @endpush
@endsection
