<div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer mx-3">
    <div class="" id="recharge-content">
        <div class="col-sm-12">
            <table id="datable_1" class="table nowrap w-100 mb-5 dataTable no-footer" aria-describedby="datable_1_info"
                role="grid">
                <thead class="thead-primary">
                    <tr role="row">
                        <th class="">Mã</th>
                        <th class="">Tài khoản</th>
                        <th class="">Số tiền</th>
                        <th class="">Trạng thái </th>
                        <th class="">Phương thức</th>
                        <th class="">Người duyệt</th>
                        <th class="">Ngày tạo</th>
                        <th class=""></th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $status = ['warning', 'success', 'danger'];
                        $type_label = [
                            PAY_DIRECT => 'Trực tiếp',
                            PAY_VNPAY => 'Chuyển khoản ngân hàng (QRcode)',
                            PAY_USDT => 'Qua USDT',
                            PAY_PERSONAL => 'TK cá nhân',
                        ];
                    @endphp
                    @foreach ($recharges as $key => $value)
                        <tr class="odd">
                            <td class="fw-bold text-primary">{{ $value['code'] }}</td>
                            <td>{{ $value['user_email'] }}</td>
                            <td>
                                {{ number_format($value['amount']) }}
                                @if ($value['type'] == PAY_USDT)
                                    (USDT: {{ number_format($value['price_other']) }})
                                @endif
                            </td>
                            <td class="d-lfex justify-content-center">
                                <button class="btn btn-{{ $status[$value['status']] }} btn-xs btn-rounded"
                                    data-bs-toggle="offcanvas" data-bs-target="#offcanvasRecharge"
                                    aria-controls="offcanvasExample" onclick="showDetail({{ $value['recharge_id'] }})">
                                    {{ $value['status_label'] }}
                                </button>

                            </td>
                            <td>
                                {{ $type_label[$value['type']] }}
                            </td>
                            <td>{{ $value['admin_contact_name'] }}</td>
                            <td>
                                {{ formatFullDate($value['created_at']) }}

                            </td>
                            <td>
                                <button class="btn" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRecharge"
                                    aria-controls="offcanvasExample"
                                    onclick="showDetail({{ $value['recharge_id'] }})"><i
                                        class='bx bx-info-circle'></i></button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="d-flex justify-content-center mt-5">
    {{ $recharges->links('components.pagination') }}
</div>
