@if ($data['recharge']['status'] == 0 && !$data['hidden'])
    <div class="d-flex flex-row justify-content-end">
        <button class="btn btn-success me-3" onclick="onSuccess({{ $data['recharge']['recharge_id'] }})"><i
                class='bx bx-check-circle'></i>Xác nhận</button>
        <button class="btn btn-danger me-3" onclick="onFail({{ $data['recharge']['recharge_id'] }})"><i
                class='bx bx-x-circle'></i></i>Hủy bỏ</button>
    </div>
@endif
<div class="">
    @php
        $status = ['warning', 'success', 'danger'];
    @endphp
    <div class="title title-xs title-wth-divider text-primary text-uppercase mb-3">
        <span>Tài khoản yêu cầu</span>
    </div>
    <div class="media align-items-center mb-3">
        <div class="media-head me-2">
            @include('template.avatar', ['data' => $data['user']])
        </div>
        <div class="media-body">
            <div class="fw-bold text-dark">{{ $data['user']['user_contact_name'] }}</div>
            <div class="fs-7">{{ $data['user']['user_code'] }}</div>
        </div>
    </div>
    <div class="row mb-3">
        <div class="col-sm-3 fw-medium">Email: </div>
        <div class="col">{{ $data['user']['user_name'] }}</div>
    </div>
    <div class="row mb-3">
        <div class="col-sm-3 fw-medium">Công ty: </div>
        <div class="col">{{ $data['user']['user_company_name'] }}</div>
    </div>
    <div class="title title-xs title-wth-divider text-primary text-uppercase my-3">
        <span>Nội dung yêu cầu</span>
    </div>
    <div class="row mb-3">
        <div class="col-sm-3 fw-medium">Ngày tạo: </div>
        <span class="col">{{ formatFullDate($data['recharge']['created_at']) }}</span>
    </div>
    <div class="row mb-3">
        <div class="col-sm-3 fw-medium">Số tiền: </div>
        <span class="col">{{ number_format($data['recharge']['amount']) }}</span>
    </div>
    <div class="row mb-3">
        <div class="col-sm-3 fw-medium">Trạng thái: </div>
        <span class="badge badge-{{ $status[$data['recharge']['status']] }} badge-pill w-auto">
            {{ $data['recharge']['status_label'] }}
        </span>
    </div>
    <div class="row mb-3">
        <div class="col-sm-3 fw-medium">Ghi chú: </div>
        <span class="col">{{ $data['recharge']['note'] }}</span>
    </div>
    <div class="row">
        <div class="col-sm-3 fw-medium">Hình ảnh: </div>
        <div class="col">
            <img src="{{ $data['recharge']['image'] }}" alt="" style="height: 150px; object-fit: cover;">
        </div>
    </div>
    @if ($data['recharge']['status'] != 0 && !empty($data['admin']))
        <div class="title title-xs title-wth-divider text-primary text-uppercase my-3">
            <span>Admin xác nhận</span>
        </div>
        <div class="media align-items-center mb-3">
            <div class="media-head me-2">
                @include('template.avatar', ['data' => $data['admin']])
            </div>
            <div class="media-body">
                <div class="fw-bold text-dark">{{ $data['admin']['user_contact_name'] }}</div>
                <div class="fs-7">{{ $data['admin']['user_code'] }}</div>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-sm-3 fw-medium">Email: </div>
            <div class="col">{{ $data['admin']['user_name'] }}</div>
        </div>
        <div class="row mb-3">
            <div class="col-sm-3 fw-medium">Ngày cập nhật: </div>
            <div class="col">{{ formatFullDate($data['recharge']['updated_at']) }}</div>
        </div>
        <div class="row mb-3">
            <div class="col-sm-3 fw-medium">Ghi chú: </div>
            <span class="col">{{ $data['recharge']['admin_note'] }}</span>
        </div>
    @endif
</div>
