<div class="table-responsive">
    <table class="table table-striped mb-0">
        <thead>
            <tr>
                <th class="fw-bold" scope="col">Mã</th>
                <th class="fw-bold" scope="col">Trạng thái</th>
                <th class="fw-bold" scope="col">Số tiền</th>
                <th class="fw-bold" scope="col">Số dư</th>
                <th class="fw-bold" scope="col">Note</th>
                <th class="fw-bold" scope="col">Ngày tạo</th>
                {{-- <th scope="col"></th> --}}
            </tr>
        </thead>
        <tbody>
            @php
                $status = ['success', 'danger']
            @endphp
            @foreach ($wallet_fluts as $item)
                <tr>
                    <td class="fw-bold">{{ $item['secure_hash'] }}</td>
                    <td class="d-lfex justify-content-center">
                        <span class="badge badge-{{ $status[$item['kind']] }} badge-pill">{{ $item['kind_label'] }}</span>
                    </td>
                    <td class="table-{{ $status[$item['kind']] }}">{{ number_format($item['amount']) }}</td>
                    <td class="">
                        {{ number_format($item['wallet_amount']) }}
                    </td>
                    <td>{{ $item['content'] }}</td>
                    <td>
                       {{ formatFullDate($item['updated_at']) }}
                    </td>
                    {{-- <td>
                        <a  data-bs-toggle="offcanvas" data-bs-target="#offcanvasRecharge" aria-controls="offcanvasExample"
                        onclick="showDetail({{ $item['recharge_id'] }})"><i class="fas fa-eye"></i></a>
                    </td> --}}
                </tr>
            @endforeach
            @if (empty($wallet_fluts))
                <tr>
                    <td colspan="6" class="text-center">Không có dữ liệu</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $wallet_fluts->links('components.pagination') }}
</div>