<div class="table-responsive">
    <table class="table table-striped mb-0">
        <thead>
            <tr>
                <th class="fw-bold" scope="col">Mã</th>
                <th class="fw-bold" scope="col">Số tiền nạp</th>
                <th class="fw-bold" scope="col">Trạng thái</th>
                <th class="fw-bold" scope="col">Note</th>
                <th class="fw-bold" scope="col">Ngày tạo</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @php
                $status = ['warning', 'success', 'danger']
            @endphp
            @foreach ($recharges as $item)
                <tr>
                    <td class="fw-bold">{{ $item['code'] }}</td>
                    <td>{{ number_format($item['amount']) }}</td>
                    <td class="d-lfex justify-content-center">
                        <span class="badge badge-{{ $status[$item['status']] }} badge-pill">{{ $item['status_label'] }}</span>
                    </td>
                    <td>{{ $item['note'] }}</td>
                    <td>
                       {{ formatFullDate($item['created_at']) }}
                    </td>
                    <td>
                        <a  data-bs-toggle="offcanvas" data-bs-target="#offcanvasRecharge" aria-controls="offcanvasExample"
                        onclick="showDetail({{ $item['recharge_id'] }})"><i class="fas fa-eye"></i></a>
                    </td>
                </tr>
            @endforeach
            @if (empty($recharges))
                <tr>
                    <td colspan="6" class="text-center">Không có dữ liệu</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $recharges->links('components.pagination') }}
</div>