@extends('layouts.app')
@section('content')
    @php
        $time_expired = \Carbon\Carbon::parse($recharge['created_at'])
            ->setTimezone('Asia/Ho_Chi_Minh')
            ->addMinutes(TIME_EXPIRED_PAYMENT);
    @endphp
    <div class="hk-pg-wrapper">
        <div class="p-2">
            <div class="row">
                @if ($time_expired->isPast() && $recharge['status'] == 0)
                    <div class="col-sm-12">
                        <div class="alert alert-danger" role="alert">
                            <h4 class="alert-heading mb-2">Đơn thanh toán trực tuyến này đã hết hạn!</h4>
                            <p>Vui lòng tạo đơn mới để được thanh toán.</p>
                            <hr class="hr-soft-success">
                            <p>
                                Hết hạn lúc:
                                {{ $time_expired->format('H:i:s d/m/Y') }}
                            </p>
                        </div>
                    </div>
                @elseif($time_expired->isFuture() && $recharge['status'] == 0)
                    <div class="col-sm-12">
                        <div class="alert alert-success" role="alert">
                            <h4 class="alert-heading mb-2">Bạn đang thanh toán trực tuyến!</h4>
                            <p>Vui lòng giữ nguyên nội dung chuyển khoản {{ $code }} để hệ thống tự
                                động
                                xác
                                nhận
                                thanh toán
                            </p>
                            <hr class="hr-soft-success">
                            <p>Hệ thống sẽ tự động ghi nhận đơn thanh toán của bạn.</p>
                        </div>
                    </div>

                    <div class="col-md-6 border text-center p-2">
                        <div class="alert alert-primary alert-wth-icon alert-dismissible fade show" role="alert">
                            <span class="alert-icon-wrap">
                                <span class="feather-icon">
                                    <i data-feather="rss"></i>
                                </span>
                            </span>
                            Cách 1: Mở app ngân hàng và quét mã QR
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <div class="my-2">
                            <img src="https://qr.sepay.vn/img?bank={{ $bank_account_detail['bank_short_name'] }}&amp;acc={{ $bank_account_detail['account_number'] }}&amp;template=compact&amp;amount={{ $recharge['amount'] }}&amp;des={{ $code }}"
                                class="img-fluid">
                            <div class="text-center">
                                <a class="btn btn-outline-primary btn-sm"
                                    href="https://qr.sepay.vn/img?bank={{ $bank_account_detail['bank_short_name'] }}&amp;acc={{ $bank_account_detail['account_number'] }}&amp;template=compact&amp;amount={{ $recharge['amount'] }}&amp;des={{ $code }}&amp;download=true">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                        fill="currentColor" class="bi bi-download" viewBox="0 0 16 16">
                                        <path
                                            d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5">
                                        </path>
                                        <path
                                            d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708z">
                                        </path>
                                    </svg>
                                    Tải ảnh QR
                                </a>
                            </div>
                            <div class="mt-4" style="background: #ebfcf5">
                                <div class="countdown p-3">
                                    <div class="mb-2">
                                        Hết hạn lúc:
                                        {{ $time_expired->format('H:i:s d/m/Y') }}
                                    </div>
                                    <span>
                                        <div id="minutes" class="fs-5 fw-bold">00</div>
                                        <div>phút</div>
                                    </span>
                                    <span>
                                        <div id="seconds" class="fs-5 fw-bold">00</div>
                                        <div>giây</div>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 border p-2">
                        <div class="alert alert-primary alert-wth-icon alert-dismissible fade show text-center"
                            role="alert">
                            <span class="alert-icon-wrap">
                                <span class="feather-icon">
                                    <i data-feather="rss"></i>
                                </span>
                            </span>
                            Cách 2: Chuyển khoản thủ công theo thông tin
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <div class="text-center">
                            <img src="https://qr.sepay.vn/assets/img/banklogo/{{ $bank_account_detail['bank_code'] }}.png"
                                class="img-fluid" style="max-height:50px">
                            <p class="fw-bold">{{ $bank_account_detail['bank_short_name'] }}</p>
                        </div>

                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Chủ tài khoản: </td>
                                    <td>
                                        <div class="input-group">
                                            <input id="clip_account_holder_name" type="text"
                                                class="form-control font-weight-500"
                                                value="{{ $bank_account_detail['account_holder_name'] }}"
                                                aria-label="{{ $bank_account_detail['account_holder_name'] }}" readonly>
                                            <button class="btn btn-primary copy-to-clipboard" data-bs-toggle="tooltip"
                                                data-bs-placement="top" title="Copy to clipboard"
                                                data-clipboard-target="#clip_account_holder_name" type="button">
                                                Copy
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Số TK: </td>
                                    <td>
                                        <div class="input-group">
                                            <input id="clip_account_number" type="text"
                                                class="form-control font-weight-500"
                                                value="{{ $bank_account_detail['account_number'] }}"
                                                aria-label="{{ $bank_account_detail['account_number'] }}" readonly>
                                            <button class="btn btn-primary copy-to-clipboard" data-bs-toggle="tooltip"
                                                data-bs-placement="top" title="Copy to clipboard"
                                                data-clipboard-target="#clip_account_number" type="button">
                                                Copy
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Số tiền: </td>
                                    <td><b>{{ formatNumber($recharge['amount']) }}đ</b></td>
                                </tr>
                                <tr>
                                    <td>Nội dung CK: </td>
                                    <td>
                                        <div class="input-group">
                                            <input id="clip_recharge_id" type="text" class="form-control font-weight-500"
                                                value="{{ $code }}"
                                                aria-label="{{ $code }}" readonly>
                                            <button class="btn btn-primary copy-to-clipboard" data-bs-toggle="tooltip"
                                                data-bs-placement="top" title="Copy to clipboard"
                                                data-clipboard-target="#clip_recharge_id" type="button">
                                                Copy
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <p class="bg-light p-2">
                            Lưu ý: Vui lòng giữ nguyên nội dung chuyển khoản {{ $code }} để hệ thống
                            tự
                            động xác
                            nhận
                            thanh toán
                        </p>
                    </div>
                @elseif ($recharge['status'] == 1)
                    <div class="col-sm-12">
                        <div class="alert alert-success" role="alert">
                            <h4 class="alert-heading mb-2">Đơn hàng đã được thanh toán!</h4>
                            <p>Đơn hàng của bạn đã được thanh toán thành công.</p>
                            <hr class="hr-soft-success">
                            <p>Hãy kiểm tra lịch sử nạp của bạn.</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Page Footer -->
        <div class="hk-footer">
            <footer class="container-xxl footer">
                <div class="row">
                    <div class="col-xl-8">
                        <p class="footer-text">
                            <span class="copy-text">Kango Express © 2024 All rights reserved.</span>

                        </p>
                    </div>
                    <div class="col-xl-4">
                        <label class="footer-extr-link link-default">Version 2.0</label>

                    </div>
                </div>
            </footer>
        </div>
        <!-- / Page Footer -->
    </div>

    @if ($recharge['status'] != 1)
        @push('scripts')
            <script src="{{ asset('assets/vendors/clipboard/dist/clipboard.min.js') }}"></script>
            <script>
                // Thời gian hết hạn
                var countDownDate = new Date(@json($time_expired)).getTime();
                var recharge_id = @json($recharge['recharge_id']);
            </script>
            <script src="{{ asset('js/payments/sepay/recharge.js') }}"></script>
        @endpush
    @endif
@endsection
