<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>ID</th>
                <th>Loại phương tiện</th>
                <th>Trạng thái</th>
                <th>Chi nhánh</th>
                @if (!onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id']))
                    <th>Người tạo</th>
                @endif
                <th>Địa chỉ</th>
            </tr>
        </thead>
        <tbody>
            @php
                $status = ['secondary', 'warning', 'warning', 'success', 'info', 'primary', 'danger'];
            @endphp
            @foreach ($orders_pickup as $key => $order_pickup)
                @php
                    $hidden_text = checkShowInfoPickup($is_shipper, $order_pickup['order_pickup_status']);
                @endphp
                <tr class="odd">
                    <td>
                        @if (!$hidden_text || true)
                            <button id="btn_pickup_{{ $key }}" onclick="showPickupDetail('{{ $key }}')"
                                class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                                data-bs-toggle="collapse" data-bs-target="#pickup_{{ $key }}"
                                aria-expanded="false">
                                <span class="icon">
                                    <i class="fa fa-plus"></i>
                                </span>
                            </button>
                        @endif
                    </td>
                    <td>{{ $order_pickup['order_pickup_code'] }}</td>
                    <td class="align-items-center">
                        <span class="d-block text-high-em">
                            {{ $order_pickup['order_pickup_type_name'] }}
                        </span>
                    </td>
                    <td>
                        <span class="badge badge-soft-{{ $status[$order_pickup['order_pickup_status']] }} my-1">
                            {{ $order_pickup['order_pickup_status_name'] }}
                        </span>
                    </td>
                    <td>{{ $order_pickup['branch']['branch_name'] }}</td>
                    @if (!onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id']))
                        <td>{{ $order_pickup['user']['user_contact_name'] }}</td>
                    @endif
                    <td>{{ $order_pickup['order_pickup_address'] }}</td>
                </tr>
                @if (!$hidden_text || true)
                    <tr class="child collapse" id="pickup_{{ $key }}">
                        <td class="child" colspan="6">
                            <ul class="dtr-details">
                                <li>
                                    <span class="dtr-title"><strong>AWB:</strong></span>
                                    <span class="dtr-data">{{ $order_pickup['order_pickup_awb'] }}</span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Phone:</strong></span>
                                    <span class="dtr-data">{{ $order_pickup['order_pickup_phone'] }}</span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Date/Time:</strong></span>
                                    <span
                                        class="dtr-data">{{ formatFullDate($order_pickup['order_pickup_date_time']) }}</span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Gross Weight:</strong></span>
                                    <span class="dtr-data">{{ $order_pickup['order_pickup_gross_weight'] }}</span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Note:</strong></span>
                                    <span class="dtr-data">{{ $order_pickup['order_pickup_note'] }}</span>
                                </li>
                                <li>
                                    <span class="dtr-title"><strong>Method:</strong></span>
                                    <span class="dtr-data">
                                        @if ($order_pickup['order_pickup_status'] !== ORDER_PICKUP_STATUS_WAITING)
                                            <font color="green">
                                                <i class="fas fa-shipping-fast"></i>
                                                {{ formatFullDate($order_pickup['order_pickup_date_time_method']) }}
                                            </font>
                                            <a href="{{ route('pickup.inpickup.show', ['order_pickup_code' => $order_pickup['order_pickup_code']]) }}"
                                                target="_blank">
                                                <i class="fas fa-file-excel"></i>
                                            </a>
                                        @endif
                                    </span>
                                </li>

                                @if (isset($order_pickup['sale']))
                                    <li>
                                        <span class="dtr-title"><strong>Nhân viên sale phụ trách: </strong></span>
                                        <span class="dtr-data">{{ $order_pickup['sale']['user_contact_name'] }}
                                            ({{ $order_pickup['sale']['user_code'] }})</span>
                                    </li>
                                @endif
                                @if (isset($order_pickup['fwd']))
                                    <li>
                                        <span class="dtr-title"><strong>Công ty: </strong></span>
                                        <span class="dtr-data">{{ $order_pickup['fwd']['user_company_name'] }}
                                            ({{ $order_pickup['fwd']['user_code'] }})</span>
                                    </li>
                                @endif
                                @if (isset($order_pickup['shipper']))
                                    <li>
                                        <span class="dtr-title"><strong>Shipper: </strong></span>
                                        <span class="dtr-data">{{ $order_pickup['shipper']['user_contact_name'] }}
                                            ({{ $order_pickup['shipper']['user_code'] }})</span>
                                    </li>
                                @endif
                                @if ($is_edit || !$is_shipper)
                                    <li class="mt-3">
                                        <button id="btn_edit_order_pickup_{{ $order_pickup['order_pickup_id'] }}"
                                            class="btn btn-sm btn-warning"
                                            onclick="onEditOrderPickup({{ $order_pickup['order_pickup_id'] }})">
                                            <i class="fa fa-pen"></i>
                                        </button>
                                        @if (
                                            (!isset($order_pickup['shipper_location_id']) &&
                                                $order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_WAITING &&
                                                $is_ops_leader) || onCheckAdminAccount())
                                            <button id="btn_edit_order_pickup_{{ $order_pickup['order_pickup_id'] }}"
                                                class="btn btn-sm btn-info ms-2"
                                                onclick="showModallAddShipper({{ $order_pickup['order_pickup_id'] }})">
                                                <i class="fas fa-shipping-fast"></i>
                                            </button>
                                        @endif
                                        @if (isset($order_pickup['shipper_location_id']) &&
                                                $order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_PENDING_CONFIRM &&
                                                onCheckPositionAccounts([SETTING_OPS_LEADER_ACCOUNT, SETTING_ADMIN_ACCOUNT], auth()->user()['position_id']))
                                            <button id="btn_delete_shipper_{{ $order_pickup['order_pickup_id'] }}"
                                                class="btn btn-sm btn-danger ms-2"
                                                onclick="onDeleteShipper({{ $order_pickup['order_pickup_id'] }})">
                                                <i class="fas fa-shipping-fast"></i>
                                            </button>
                                        @endif
                                        @if (
                                            !isset($order_pickup['shipper_location_id']) &&
                                                isGetAllData() &&
                                                $order_pickup['order_pickup_status'] != ORDER_PICKUP_STATUS_CANCEL)
                                            <button id="btn_delete_order_pickup_{{ $order_pickup['order_pickup_id'] }}"
                                                class="btn btn-sm btn-danger ms-2"
                                                onclick="onCancelPickup({{ $order_pickup['order_pickup_id'] }})">
                                                <i class="fas fa-calendar-times"></i>
                                            </button>
                                        @endif
                                    </li>
                                @endif
                                @if ($is_shipper)
                                    <li class="mt-3">
                                        @if ($order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_PENDING_CONFIRM)
                                            <button class="btn btn-sm btn-warning btn-update-status"
                                                data-order_pickup_id="{{ $order_pickup['order_pickup_id'] }}"
                                                data-order_pickup_status="{{ ORDER_PICKUP_STATUS_CONFIRMED }}">
                                                <i class="fas fa-user-check"></i>
                                            </button>
                                        @endif
                                        @if ($order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_CONFIRMED)
                                            <button class="btn btn-sm btn-info btn-update-status"
                                                data-order_pickup_id="{{ $order_pickup['order_pickup_id'] }}"
                                                data-order_pickup_status="{{ ORDER_PICKUP_STATUS_GOING }}">
                                                <i class="fas fa-running"></i>
                                            </button>
                                        @endif
                                        @if ($order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_GOING)
                                            <button class="btn btn-sm btn-info btn-update-status"
                                                data-order_pickup_id="{{ $order_pickup['order_pickup_id'] }}"
                                                data-order_pickup_status="{{ ORDER_PICKUP_STATUS_GONE }}">
                                                <i class="fa fa-chalkboard-teacher"></i>
                                            </button>
                                        @endif
                                        @if ($order_pickup['order_pickup_status'] == ORDER_PICKUP_STATUS_GONE)
                                            <button class="btn btn-sm btn-success btn-update-status-picked"
                                                data-order_pickup_id="{{ $order_pickup['order_pickup_id'] }}"
                                                data-order_pickup_status="{{ ORDER_PICKUP_STATUS_PICKED }}"
                                                data-bs-toggle="modal"
                                                data-bs-target="#modalUploadOrderPickupImageBackdrop">
                                                <i class="fa fa-check-circle"></i>
                                            </button>
                                        @endif
                                        @if (in_array($order_pickup['order_pickup_status'], [ORDER_PICKUP_STATUS_GOING, ORDER_PICKUP_STATUS_GONE]))
                                            <button id="btn_delete_order_pickup_{{ $order_pickup['order_pickup_id'] }}"
                                                class="btn btn-sm btn-danger ms-2"
                                                onclick="onCancelPickup({{ $order_pickup['order_pickup_id'] }})">
                                                <i class="fas fa-calendar-times"></i>
                                            </button>
                                        @endif
                                    </li>
                                @endif
                            </ul>
                        </td>
                    </tr>
                @endif
            @endforeach
        </tbody>
    </table>
    <div class="d-flex justify-content-center mt-5">
        {{ $orders_pickup->links('components.pagination') }}
    </div>
</div>
