<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Pickup {{ $order_pickup['order_pickup_code'] }}</title>
    <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
    <link rel="icon" href="{{ asset('assets/images/favicon.ico') }}" type="image/x-icon">
    <!-- CSS -->
    <link href="{{ asset('assets/dist/css/style.css') }}" rel="stylesheet" type="text/css">
    <style>
        @media print {
            @page {
                margin-left: 0in;
                margin-right: 0in;
                margin-top: 0in;
                margin-bottom: 0;
            }

            .pt-5 {
                padding-top: 1.3rem !important;
            }
        }
    </style>
</head>

<body>
    <div class="p-5 pt-5 fs-7 d-flex justify-content-center">
        <div>
            <div class="row row-cols-2 border border-dark">
                <div class="col-4 border-end border-dark">
                    <div
                        style="width: 100%; height: 100%; display: flex; justify-content: center; align-items: center;">
                        <img src="{{ asset(LOGO) }}" alt=""
                            style="max-width: 100%; max-height: 100%; object-fit: contain;">
                    </div>
                </div>
                <div class="col-8 p-1 fs-8">
                    {{ $system_settings[SETTING_COMPANY_NAME]['value'] }}<br>
                    Trụ sở: {{ $system_settings[SETTING_HEADQUARTERS_ADDRESS]['value'] }}<br>
                    @foreach ($branchs as $branch)
                        CN {{ $branch['branch_name'] }}: {{ $branch['branch_description'] }}<br>
                    @endforeach
                    Email: {{ $system_settings[SETTING_EMAIL_ADDRESS]['value'] }}<br>
                    Web: {{ $system_settings[SETTING_WEBSITE_ADDRESS]['value'] }}<br>
                    Hotline : {{ $system_settings[SETTING_HOTLINE]['value'] }}
                </div>
            </div>
            <div class="row row-cols-1 border border-top-0 border-dark">
                <div class="col text-center p-1">
                    <span class="fw-bold fs-6 text-primary">Delivery and Reception</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Pickup Request Number</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['order_pickup_code'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Account Number</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['user']['user_code'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Awb Number</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['order_pickup_awb'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Pickup Address</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['order_pickup_address'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Phone Number</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['order_pickup_phone'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Company Name</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ isset($order_pickup['user']['user_company_name']) ? $order_pickup['user']['user_company_name'] : $system_settings[SETTING_COMPANY_NAME]['value'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Contact Name</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['user']['user_contact_name'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Pickup Type</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['order_pickup_type_name'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Pickup Datetime</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ formatFullDate($order_pickup['order_pickup_date_time']) }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Total number of Packages</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['order_pickup_number_packages'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Gross Weight</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['order_pickup_gross_weight'] }}</span>
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark">
                <div class="col-4">
                    <span>Special Instructions</span>
                </div>
                <div class="col-8 ps-1">
                    <span>{{ $order_pickup['order_pickup_note'] }}</span>
                </div>
            </div>
            <div class="row row-cols-1 border border-top-0 border-dark">
                <div class="col p-1 d-flex justify-content-center">
                    <img src="{{ asset($order_pickup['order_pickup_image']) }}" alt=""
                        style="width: 402px; height: 275px;">
                </div>
            </div>
            <div class="row row-cols-2 border border-top-0 border-dark text-center">
                <div class="col-4 fs-8 border-end border-dark">
                    <div>Customer ( {{ $order_pickup['user']['position']['position_name'] }} )</div>
                    <div>Contact Name: {{ $order_pickup['user']['user_contact_name'] }}</div>
                    <div>Company: [{{ isset($order_pickup['user']['user_company_name']) ? $order_pickup['user']['user_company_name'] : $system_settings[SETTING_COMPANY_NAME]['value'] }}]</div>
                </div>
                <div class="col-8 p-1 fs-8">
                    <div>Pickup Name</div>
                    <div>Ký, họ tên</div>
                    <div class="d-flex justify-content-center mt-1 mb-1">
                        <div style="height: 100px; width: 200px;">
                            @if (isset($order_pickup['userReceiver']['user_signature']) && $order_pickup['userReceiver']['user_signature'] != '')
                                <img src="{{ asset($order_pickup['userReceiver']['user_signature']) }}" alt=""
                                    style="width: 100%; height: 100%">
                            @endif
                        </div>
                    </div>
                    <div>{{ isset($order_pickup['userReceiver']['user_contact_name']) ? $order_pickup['userReceiver']['user_contact_name'] : '' }}</div>
                </div>
            </div>
        </div>
    </div>
    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>

</html>
